
//
//    (, ):
//
//  -0:
//  +0 (byte)  
//  +1 (byte)    
//  +2 (word)    
//  +4 (byte)   
//  +5 (word)   
//
//   ,     (  8)
//  (0-63),   D3
//
//  +7 bankN0
//  +8 bankN1
//  +9 bankN2
//  +A bankN3
//  +B bankN4
//  +C bankN5
//  +D bankN6
//  +E bankN7
//  +F bankN8
//

//
//  -1: (    -0,     , .. +16 )
//  +0 (byte)  
//  +1 (byte)    
//  +2 (word)    
//  +4 (byte)     (0-63),   D3
//  +5 (word)   
//
//   ,     (  9)
//  (0-63),   D3
//
//  +7 bankN0
//  +8 bankN1
//  +9 bankN2
//  +A bankN3
//  +B bankN4
//  +C bankN5
//  +D bankN6
//  +E bankN7
//  +F bankN8
//

//
//  . 
//       
//
//  A -  
// IX - 
// DE -     
//

init_animation:
	ld (ix+0), a
	ld (ix+16), a
	xor a
	ld (ix+4), a
	ld (ix+20), a

	ld bc, 9
	add ix, bc

init_anim_bank_bits:
	dec ix
	ld a, 088h
	or (ix+7)
	ld (ix+7), a
	ld a, 080h
	or (ix+23)
	ld (ix+23), a
	dec c
	jr nz, init_anim_bank_bits
			
	call make_init_animation_internal
	ld c, 16
	add ix, bc

make_init_animation_internal:
	ld (ix+1), 1
	push de
	exx
	ld a, (ix+4)
	add a, 7
	ld (mega_index2+2), a
mega_index2:	
	ld a, (ix+0)
		
	ld l, a
	rst 32		//     
	ld a, l
	ld hl, 0c000h
	ld c, (hl)	//     
	inc l
	ld b, (hl)
	inc l
	push hl
	add hl, bc
	ld (ix+2), l
	ld (ix+5), l
	ld (ix+3), h
	ld (ix+6), h
	pop hl
	pop de
	ldir		//   , 
	and 008h	//      . 
				//    . ..     3,7   1,5
	jr nz, anim_screen1_is_active
	add a, 2

anim_screen1_is_active:	
	inc a
	ld (anim_bank_tmp+1), a
	rst 32
	exx
	push ix
	push bc
	push de
	ex de, hl
	
	ld a, 0c0h
	call GfxUnpack
	ld a, 0e0h
	call GfxUnpack
	
anim_bank_tmp:
	ld a, 0
	add a, 4
	rst 32
	
	ld a, 0c0h
	call GfxUnpack
	ld a, 0e0h
	call GfxUnpack
	pop de
	pop bc
	pop ix		
	ret

//
//  .
//   -     (0  A ,  1)
// IX -  
// DE -     
//

do_animation:
	add a, a
	and 2
	ld c, a
	inc a
	or 080h
	ld (do_animation_screen_bank+1), a	
	ld a, c
	add a, a
	add a, a
	add a, a
	ld c, a
	ld b, 0
	add ix, bc
	
	//    
	push ix
	push de
	ex de, hl
	
	
	ld a, (ix+4)
	add a,7
	ld (mega_index1+2), a
mega_index1:	
	ld a, (ix+0)
	
	rst 32
	ex de, hl
	ld l, (ix+2)
	ld h, (ix+3)

	ld c, (hl)
	inc hl
	ld b, (hl)
	
	inc hl
	ldir
	
	ld (ix+2), l
	ld (ix+3), h
	ld a, (hl)
	inc hl
	or (hl)
	ld (do_animation_bank_not_completed+1), a
	pop hl
	
	//  ,  
do_animation_screen_bank:
	ld a, 0
	push af
	rst 32
	
	ld a, 0c0h
	call GfxUnpack
	ld a, 0e0h
	call GfxUnpack
	
	pop af
	add a, 4
	rst 32

	ld a, 0c0h
	call GfxUnpack
	ld a, 0e0h
	call GfxUnpack
	
	//   ,   h		
	pop ix
	ld a, (ix+0)
	inc (ix+1)
	sub (ix+1)
	jr nc, do_animation_no_rewind
	
	//   .    
	ld (ix+1), 1
	ld a, (ix+5)
	ld (ix+2), a
	ld a, (ix+6)
	ld (ix+3), a
	ld (ix+4), 0
	ret

do_animation_no_rewind:
	//    ,  ,   
	

do_animation_bank_not_completed:
	ld a, 0
	or a
	ret nz
	
	//      ,  
	ld (ix+2), a
	ld a, 0c0h
	ld (ix+3), a
	inc (ix+4)
	ret
	




//    (, ):
//  +0 (byte)  
//
//  -0:
//  +0 (byte)    
//  +1 (word)    
//  +3 (byte)     (0-63),   D3
//  +4 (word)   
//  +6 (byte)   



#include "gfx_unpack.asm"
