/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.windows;

import org.lwjgl.Sys;
import org.lwjgl.system.DynamicLinkLibrary;
import org.lwjgl.system.windows.WinBase;
import org.lwjgl.system.windows.WindowsPlatform;

public class WindowsLibrary
extends DynamicLinkLibrary.Default {
    public static final long HINSTANCE = WinBase.GetModuleHandle(Sys.JNI_LIBRARY_NAME);
    private final String name;
    private final long handle;

    public WindowsLibrary(String name) {
        this.name = name;
        this.handle = WinBase.LoadLibrary(name);
        if (this.handle == 0L) {
            WindowsPlatform.windowsThrowException("Failed to load library: " + name);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public long getPointer() {
        return this.handle;
    }

    @Override
    public long getFunctionAddress(CharSequence name) {
        return WinBase.GetProcAddress(this.handle, name);
    }

    @Override
    protected void destroy() {
        if (WinBase.FreeLibrary(this.handle) == 0) {
            WindowsPlatform.windowsThrowException("Failed to unload library: " + this.name);
        }
    }

    static {
        if (HINSTANCE == 0L) {
            throw new RuntimeException("Failed to retrieve LWJGL module handle.");
        }
    }
}

