/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.windows;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.Pointer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryUtil;

public final class POINTFLOAT
implements Pointer {
    public static final int SIZEOF;
    public static final int X;
    public static final int Y;
    private final ByteBuffer struct;

    public POINTFLOAT() {
        this(POINTFLOAT.malloc());
    }

    public POINTFLOAT(ByteBuffer struct) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)struct, SIZEOF);
        }
        this.struct = struct;
    }

    public ByteBuffer buffer() {
        return this.struct;
    }

    @Override
    public long getPointer() {
        return MemoryUtil.memAddress(this.struct);
    }

    public void setX(float x) {
        POINTFLOAT.x(this.struct, x);
    }

    public void setY(float y) {
        POINTFLOAT.y(this.struct, y);
    }

    public float getX() {
        return POINTFLOAT.x(this.struct);
    }

    public float getY() {
        return POINTFLOAT.y(this.struct);
    }

    private static native int offsets(long var0);

    public static ByteBuffer malloc() {
        return BufferUtils.createByteBuffer(SIZEOF);
    }

    public static ByteBuffer malloc(float x, float y) {
        ByteBuffer pointfloat = POINTFLOAT.malloc();
        POINTFLOAT.x(pointfloat, x);
        POINTFLOAT.y(pointfloat, y);
        return pointfloat;
    }

    public static void x(ByteBuffer pointfloat, float x) {
        pointfloat.putFloat(pointfloat.position() + X, x);
    }

    public static void y(ByteBuffer pointfloat, float y) {
        pointfloat.putFloat(pointfloat.position() + Y, y);
    }

    public static float x(ByteBuffer pointfloat) {
        return pointfloat.getFloat(pointfloat.position() + X);
    }

    public static float y(ByteBuffer pointfloat) {
        return pointfloat.getFloat(pointfloat.position() + Y);
    }

    static {
        IntBuffer offsets = BufferUtils.createIntBuffer(2);
        SIZEOF = POINTFLOAT.offsets(MemoryUtil.memAddress(offsets));
        X = offsets.get(0);
        Y = offsets.get(1);
    }
}

