/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.windows;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.Pointer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryUtil;

public final class PIXELFORMATDESCRIPTOR
implements Pointer {
    public static final int SIZEOF;
    public static final int SIZE;
    public static final int VERSION;
    public static final int FLAGS;
    public static final int PIXELTYPE;
    public static final int COLORBITS;
    public static final int REDBITS;
    public static final int REDSHIRT;
    public static final int GREENBITS;
    public static final int GREENSHIFT;
    public static final int BLUEBITS;
    public static final int BLUESHIFT;
    public static final int ALPHABITS;
    public static final int ALPHASHIFT;
    public static final int ACCUMBITS;
    public static final int ACCUMREDBITS;
    public static final int ACCUMGREENBITS;
    public static final int ACCUMBLUEBITS;
    public static final int ACCUMALPHABITS;
    public static final int DEPTHBITS;
    public static final int STENCILBITS;
    public static final int AUXBUFFERS;
    public static final int LAYERTYPE;
    public static final int RESERVED;
    public static final int LAYERMASK;
    public static final int VISIBLEMASK;
    public static final int DAMAGEMASK;
    private final ByteBuffer struct;

    public PIXELFORMATDESCRIPTOR() {
        this(PIXELFORMATDESCRIPTOR.malloc());
    }

    public PIXELFORMATDESCRIPTOR(ByteBuffer struct) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)struct, SIZEOF);
        }
        this.struct = struct;
    }

    public ByteBuffer buffer() {
        return this.struct;
    }

    @Override
    public long getPointer() {
        return MemoryUtil.memAddress(this.struct);
    }

    public void setSize(int size) {
        PIXELFORMATDESCRIPTOR.size(this.struct, size);
    }

    public void setVersion(int version) {
        PIXELFORMATDESCRIPTOR.version(this.struct, version);
    }

    public void setFlags(int flags) {
        PIXELFORMATDESCRIPTOR.flags(this.struct, flags);
    }

    public void setPixelType(int pixelType) {
        PIXELFORMATDESCRIPTOR.pixelType(this.struct, pixelType);
    }

    public void setColorBits(int colorBits) {
        PIXELFORMATDESCRIPTOR.colorBits(this.struct, colorBits);
    }

    public void setRedBits(int redBits) {
        PIXELFORMATDESCRIPTOR.redBits(this.struct, redBits);
    }

    public void setRedShirt(int redShirt) {
        PIXELFORMATDESCRIPTOR.redShirt(this.struct, redShirt);
    }

    public void setGreenBits(int greenBits) {
        PIXELFORMATDESCRIPTOR.greenBits(this.struct, greenBits);
    }

    public void setGreenShift(int greenShift) {
        PIXELFORMATDESCRIPTOR.greenShift(this.struct, greenShift);
    }

    public void setBlueBits(int blueBits) {
        PIXELFORMATDESCRIPTOR.blueBits(this.struct, blueBits);
    }

    public void setBlueShift(int blueShift) {
        PIXELFORMATDESCRIPTOR.blueShift(this.struct, blueShift);
    }

    public void setAlphaBits(int alphaBits) {
        PIXELFORMATDESCRIPTOR.alphaBits(this.struct, alphaBits);
    }

    public void setAlphaShift(int alphaShift) {
        PIXELFORMATDESCRIPTOR.alphaShift(this.struct, alphaShift);
    }

    public void setAccumBits(int accumBits) {
        PIXELFORMATDESCRIPTOR.accumBits(this.struct, accumBits);
    }

    public void setAccumRedBits(int accumRedBits) {
        PIXELFORMATDESCRIPTOR.accumRedBits(this.struct, accumRedBits);
    }

    public void setAccumGreenBits(int accumGreenBits) {
        PIXELFORMATDESCRIPTOR.accumGreenBits(this.struct, accumGreenBits);
    }

    public void setAccumBlueBits(int accumBlueBits) {
        PIXELFORMATDESCRIPTOR.accumBlueBits(this.struct, accumBlueBits);
    }

    public void setAccumAlphaBits(int accumAlphaBits) {
        PIXELFORMATDESCRIPTOR.accumAlphaBits(this.struct, accumAlphaBits);
    }

    public void setDepthBits(int depthBits) {
        PIXELFORMATDESCRIPTOR.depthBits(this.struct, depthBits);
    }

    public void setStencilBits(int stencilBits) {
        PIXELFORMATDESCRIPTOR.stencilBits(this.struct, stencilBits);
    }

    public void setAuxBuffers(int auxBuffers) {
        PIXELFORMATDESCRIPTOR.auxBuffers(this.struct, auxBuffers);
    }

    public void setLayerType(int layerType) {
        PIXELFORMATDESCRIPTOR.layerType(this.struct, layerType);
    }

    public void setReserved(int reserved) {
        PIXELFORMATDESCRIPTOR.reserved(this.struct, reserved);
    }

    public void setLayerMask(int layerMask) {
        PIXELFORMATDESCRIPTOR.layerMask(this.struct, layerMask);
    }

    public void setVisibleMask(int visibleMask) {
        PIXELFORMATDESCRIPTOR.visibleMask(this.struct, visibleMask);
    }

    public void setDamageMask(int damageMask) {
        PIXELFORMATDESCRIPTOR.damageMask(this.struct, damageMask);
    }

    public int getSize() {
        return PIXELFORMATDESCRIPTOR.size(this.struct);
    }

    public int getVersion() {
        return PIXELFORMATDESCRIPTOR.version(this.struct);
    }

    public int getFlags() {
        return PIXELFORMATDESCRIPTOR.flags(this.struct);
    }

    public int getPixelType() {
        return PIXELFORMATDESCRIPTOR.pixelType(this.struct);
    }

    public int getColorBits() {
        return PIXELFORMATDESCRIPTOR.colorBits(this.struct);
    }

    public int getRedBits() {
        return PIXELFORMATDESCRIPTOR.redBits(this.struct);
    }

    public int getRedShirt() {
        return PIXELFORMATDESCRIPTOR.redShirt(this.struct);
    }

    public int getGreenBits() {
        return PIXELFORMATDESCRIPTOR.greenBits(this.struct);
    }

    public int getGreenShift() {
        return PIXELFORMATDESCRIPTOR.greenShift(this.struct);
    }

    public int getBlueBits() {
        return PIXELFORMATDESCRIPTOR.blueBits(this.struct);
    }

    public int getBlueShift() {
        return PIXELFORMATDESCRIPTOR.blueShift(this.struct);
    }

    public int getAlphaBits() {
        return PIXELFORMATDESCRIPTOR.alphaBits(this.struct);
    }

    public int getAlphaShift() {
        return PIXELFORMATDESCRIPTOR.alphaShift(this.struct);
    }

    public int getAccumBits() {
        return PIXELFORMATDESCRIPTOR.accumBits(this.struct);
    }

    public int getAccumRedBits() {
        return PIXELFORMATDESCRIPTOR.accumRedBits(this.struct);
    }

    public int getAccumGreenBits() {
        return PIXELFORMATDESCRIPTOR.accumGreenBits(this.struct);
    }

    public int getAccumBlueBits() {
        return PIXELFORMATDESCRIPTOR.accumBlueBits(this.struct);
    }

    public int getAccumAlphaBits() {
        return PIXELFORMATDESCRIPTOR.accumAlphaBits(this.struct);
    }

    public int getDepthBits() {
        return PIXELFORMATDESCRIPTOR.depthBits(this.struct);
    }

    public int getStencilBits() {
        return PIXELFORMATDESCRIPTOR.stencilBits(this.struct);
    }

    public int getAuxBuffers() {
        return PIXELFORMATDESCRIPTOR.auxBuffers(this.struct);
    }

    public int getLayerType() {
        return PIXELFORMATDESCRIPTOR.layerType(this.struct);
    }

    public int getReserved() {
        return PIXELFORMATDESCRIPTOR.reserved(this.struct);
    }

    public int getLayerMask() {
        return PIXELFORMATDESCRIPTOR.layerMask(this.struct);
    }

    public int getVisibleMask() {
        return PIXELFORMATDESCRIPTOR.visibleMask(this.struct);
    }

    public int getDamageMask() {
        return PIXELFORMATDESCRIPTOR.damageMask(this.struct);
    }

    private static native int offsets(long var0);

    public static ByteBuffer malloc() {
        return BufferUtils.createByteBuffer(SIZEOF);
    }

    public static ByteBuffer malloc(int size, int version, int flags, int pixelType, int colorBits, int redBits, int redShirt, int greenBits, int greenShift, int blueBits, int blueShift, int alphaBits, int alphaShift, int accumBits, int accumRedBits, int accumGreenBits, int accumBlueBits, int accumAlphaBits, int depthBits, int stencilBits, int auxBuffers, int layerType, int reserved, int layerMask, int visibleMask, int damageMask) {
        ByteBuffer pixelformatdescriptor = PIXELFORMATDESCRIPTOR.malloc();
        PIXELFORMATDESCRIPTOR.size(pixelformatdescriptor, size);
        PIXELFORMATDESCRIPTOR.version(pixelformatdescriptor, version);
        PIXELFORMATDESCRIPTOR.flags(pixelformatdescriptor, flags);
        PIXELFORMATDESCRIPTOR.pixelType(pixelformatdescriptor, pixelType);
        PIXELFORMATDESCRIPTOR.colorBits(pixelformatdescriptor, colorBits);
        PIXELFORMATDESCRIPTOR.redBits(pixelformatdescriptor, redBits);
        PIXELFORMATDESCRIPTOR.redShirt(pixelformatdescriptor, redShirt);
        PIXELFORMATDESCRIPTOR.greenBits(pixelformatdescriptor, greenBits);
        PIXELFORMATDESCRIPTOR.greenShift(pixelformatdescriptor, greenShift);
        PIXELFORMATDESCRIPTOR.blueBits(pixelformatdescriptor, blueBits);
        PIXELFORMATDESCRIPTOR.blueShift(pixelformatdescriptor, blueShift);
        PIXELFORMATDESCRIPTOR.alphaBits(pixelformatdescriptor, alphaBits);
        PIXELFORMATDESCRIPTOR.alphaShift(pixelformatdescriptor, alphaShift);
        PIXELFORMATDESCRIPTOR.accumBits(pixelformatdescriptor, accumBits);
        PIXELFORMATDESCRIPTOR.accumRedBits(pixelformatdescriptor, accumRedBits);
        PIXELFORMATDESCRIPTOR.accumGreenBits(pixelformatdescriptor, accumGreenBits);
        PIXELFORMATDESCRIPTOR.accumBlueBits(pixelformatdescriptor, accumBlueBits);
        PIXELFORMATDESCRIPTOR.accumAlphaBits(pixelformatdescriptor, accumAlphaBits);
        PIXELFORMATDESCRIPTOR.depthBits(pixelformatdescriptor, depthBits);
        PIXELFORMATDESCRIPTOR.stencilBits(pixelformatdescriptor, stencilBits);
        PIXELFORMATDESCRIPTOR.auxBuffers(pixelformatdescriptor, auxBuffers);
        PIXELFORMATDESCRIPTOR.layerType(pixelformatdescriptor, layerType);
        PIXELFORMATDESCRIPTOR.reserved(pixelformatdescriptor, reserved);
        PIXELFORMATDESCRIPTOR.layerMask(pixelformatdescriptor, layerMask);
        PIXELFORMATDESCRIPTOR.visibleMask(pixelformatdescriptor, visibleMask);
        PIXELFORMATDESCRIPTOR.damageMask(pixelformatdescriptor, damageMask);
        return pixelformatdescriptor;
    }

    public static void size(ByteBuffer pixelformatdescriptor, int size) {
        pixelformatdescriptor.putShort(pixelformatdescriptor.position() + SIZE, (short)size);
    }

    public static void version(ByteBuffer pixelformatdescriptor, int version) {
        pixelformatdescriptor.putShort(pixelformatdescriptor.position() + VERSION, (short)version);
    }

    public static void flags(ByteBuffer pixelformatdescriptor, int flags) {
        pixelformatdescriptor.putInt(pixelformatdescriptor.position() + FLAGS, flags);
    }

    public static void pixelType(ByteBuffer pixelformatdescriptor, int pixelType) {
        pixelformatdescriptor.put(pixelformatdescriptor.position() + PIXELTYPE, (byte)pixelType);
    }

    public static void colorBits(ByteBuffer pixelformatdescriptor, int colorBits) {
        pixelformatdescriptor.put(pixelformatdescriptor.position() + COLORBITS, (byte)colorBits);
    }

    public static void redBits(ByteBuffer pixelformatdescriptor, int redBits) {
        pixelformatdescriptor.put(pixelformatdescriptor.position() + REDBITS, (byte)redBits);
    }

    public static void redShirt(ByteBuffer pixelformatdescriptor, int redShirt) {
        pixelformatdescriptor.put(pixelformatdescriptor.position() + REDSHIRT, (byte)redShirt);
    }

    public static void greenBits(ByteBuffer pixelformatdescriptor, int greenBits) {
        pixelformatdescriptor.put(pixelformatdescriptor.position() + GREENBITS, (byte)greenBits);
    }

    public static void greenShift(ByteBuffer pixelformatdescriptor, int greenShift) {
        pixelformatdescriptor.put(pixelformatdescriptor.position() + GREENSHIFT, (byte)greenShift);
    }

    public static void blueBits(ByteBuffer pixelformatdescriptor, int blueBits) {
        pixelformatdescriptor.put(pixelformatdescriptor.position() + BLUEBITS, (byte)blueBits);
    }

    public static void blueShift(ByteBuffer pixelformatdescriptor, int blueShift) {
        pixelformatdescriptor.put(pixelformatdescriptor.position() + BLUESHIFT, (byte)blueShift);
    }

    public static void alphaBits(ByteBuffer pixelformatdescriptor, int alphaBits) {
        pixelformatdescriptor.put(pixelformatdescriptor.position() + ALPHABITS, (byte)alphaBits);
    }

    public static void alphaShift(ByteBuffer pixelformatdescriptor, int alphaShift) {
        pixelformatdescriptor.put(pixelformatdescriptor.position() + ALPHASHIFT, (byte)alphaShift);
    }

    public static void accumBits(ByteBuffer pixelformatdescriptor, int accumBits) {
        pixelformatdescriptor.put(pixelformatdescriptor.position() + ACCUMBITS, (byte)accumBits);
    }

    public static void accumRedBits(ByteBuffer pixelformatdescriptor, int accumRedBits) {
        pixelformatdescriptor.put(pixelformatdescriptor.position() + ACCUMREDBITS, (byte)accumRedBits);
    }

    public static void accumGreenBits(ByteBuffer pixelformatdescriptor, int accumGreenBits) {
        pixelformatdescriptor.put(pixelformatdescriptor.position() + ACCUMGREENBITS, (byte)accumGreenBits);
    }

    public static void accumBlueBits(ByteBuffer pixelformatdescriptor, int accumBlueBits) {
        pixelformatdescriptor.put(pixelformatdescriptor.position() + ACCUMBLUEBITS, (byte)accumBlueBits);
    }

    public static void accumAlphaBits(ByteBuffer pixelformatdescriptor, int accumAlphaBits) {
        pixelformatdescriptor.put(pixelformatdescriptor.position() + ACCUMALPHABITS, (byte)accumAlphaBits);
    }

    public static void depthBits(ByteBuffer pixelformatdescriptor, int depthBits) {
        pixelformatdescriptor.put(pixelformatdescriptor.position() + DEPTHBITS, (byte)depthBits);
    }

    public static void stencilBits(ByteBuffer pixelformatdescriptor, int stencilBits) {
        pixelformatdescriptor.put(pixelformatdescriptor.position() + STENCILBITS, (byte)stencilBits);
    }

    public static void auxBuffers(ByteBuffer pixelformatdescriptor, int auxBuffers) {
        pixelformatdescriptor.put(pixelformatdescriptor.position() + AUXBUFFERS, (byte)auxBuffers);
    }

    public static void layerType(ByteBuffer pixelformatdescriptor, int layerType) {
        pixelformatdescriptor.put(pixelformatdescriptor.position() + LAYERTYPE, (byte)layerType);
    }

    public static void reserved(ByteBuffer pixelformatdescriptor, int reserved) {
        pixelformatdescriptor.put(pixelformatdescriptor.position() + RESERVED, (byte)reserved);
    }

    public static void layerMask(ByteBuffer pixelformatdescriptor, int layerMask) {
        pixelformatdescriptor.putInt(pixelformatdescriptor.position() + LAYERMASK, layerMask);
    }

    public static void visibleMask(ByteBuffer pixelformatdescriptor, int visibleMask) {
        pixelformatdescriptor.putInt(pixelformatdescriptor.position() + VISIBLEMASK, visibleMask);
    }

    public static void damageMask(ByteBuffer pixelformatdescriptor, int damageMask) {
        pixelformatdescriptor.putInt(pixelformatdescriptor.position() + DAMAGEMASK, damageMask);
    }

    public static int size(ByteBuffer pixelformatdescriptor) {
        return pixelformatdescriptor.getShort(pixelformatdescriptor.position() + SIZE);
    }

    public static int version(ByteBuffer pixelformatdescriptor) {
        return pixelformatdescriptor.getShort(pixelformatdescriptor.position() + VERSION);
    }

    public static int flags(ByteBuffer pixelformatdescriptor) {
        return pixelformatdescriptor.getInt(pixelformatdescriptor.position() + FLAGS);
    }

    public static int pixelType(ByteBuffer pixelformatdescriptor) {
        return pixelformatdescriptor.get(pixelformatdescriptor.position() + PIXELTYPE);
    }

    public static int colorBits(ByteBuffer pixelformatdescriptor) {
        return pixelformatdescriptor.get(pixelformatdescriptor.position() + COLORBITS);
    }

    public static int redBits(ByteBuffer pixelformatdescriptor) {
        return pixelformatdescriptor.get(pixelformatdescriptor.position() + REDBITS);
    }

    public static int redShirt(ByteBuffer pixelformatdescriptor) {
        return pixelformatdescriptor.get(pixelformatdescriptor.position() + REDSHIRT);
    }

    public static int greenBits(ByteBuffer pixelformatdescriptor) {
        return pixelformatdescriptor.get(pixelformatdescriptor.position() + GREENBITS);
    }

    public static int greenShift(ByteBuffer pixelformatdescriptor) {
        return pixelformatdescriptor.get(pixelformatdescriptor.position() + GREENSHIFT);
    }

    public static int blueBits(ByteBuffer pixelformatdescriptor) {
        return pixelformatdescriptor.get(pixelformatdescriptor.position() + BLUEBITS);
    }

    public static int blueShift(ByteBuffer pixelformatdescriptor) {
        return pixelformatdescriptor.get(pixelformatdescriptor.position() + BLUESHIFT);
    }

    public static int alphaBits(ByteBuffer pixelformatdescriptor) {
        return pixelformatdescriptor.get(pixelformatdescriptor.position() + ALPHABITS);
    }

    public static int alphaShift(ByteBuffer pixelformatdescriptor) {
        return pixelformatdescriptor.get(pixelformatdescriptor.position() + ALPHASHIFT);
    }

    public static int accumBits(ByteBuffer pixelformatdescriptor) {
        return pixelformatdescriptor.get(pixelformatdescriptor.position() + ACCUMBITS);
    }

    public static int accumRedBits(ByteBuffer pixelformatdescriptor) {
        return pixelformatdescriptor.get(pixelformatdescriptor.position() + ACCUMREDBITS);
    }

    public static int accumGreenBits(ByteBuffer pixelformatdescriptor) {
        return pixelformatdescriptor.get(pixelformatdescriptor.position() + ACCUMGREENBITS);
    }

    public static int accumBlueBits(ByteBuffer pixelformatdescriptor) {
        return pixelformatdescriptor.get(pixelformatdescriptor.position() + ACCUMBLUEBITS);
    }

    public static int accumAlphaBits(ByteBuffer pixelformatdescriptor) {
        return pixelformatdescriptor.get(pixelformatdescriptor.position() + ACCUMALPHABITS);
    }

    public static int depthBits(ByteBuffer pixelformatdescriptor) {
        return pixelformatdescriptor.get(pixelformatdescriptor.position() + DEPTHBITS);
    }

    public static int stencilBits(ByteBuffer pixelformatdescriptor) {
        return pixelformatdescriptor.get(pixelformatdescriptor.position() + STENCILBITS);
    }

    public static int auxBuffers(ByteBuffer pixelformatdescriptor) {
        return pixelformatdescriptor.get(pixelformatdescriptor.position() + AUXBUFFERS);
    }

    public static int layerType(ByteBuffer pixelformatdescriptor) {
        return pixelformatdescriptor.get(pixelformatdescriptor.position() + LAYERTYPE);
    }

    public static int reserved(ByteBuffer pixelformatdescriptor) {
        return pixelformatdescriptor.get(pixelformatdescriptor.position() + RESERVED);
    }

    public static int layerMask(ByteBuffer pixelformatdescriptor) {
        return pixelformatdescriptor.getInt(pixelformatdescriptor.position() + LAYERMASK);
    }

    public static int visibleMask(ByteBuffer pixelformatdescriptor) {
        return pixelformatdescriptor.getInt(pixelformatdescriptor.position() + VISIBLEMASK);
    }

    public static int damageMask(ByteBuffer pixelformatdescriptor) {
        return pixelformatdescriptor.getInt(pixelformatdescriptor.position() + DAMAGEMASK);
    }

    static {
        IntBuffer offsets = BufferUtils.createIntBuffer(26);
        SIZEOF = PIXELFORMATDESCRIPTOR.offsets(MemoryUtil.memAddress(offsets));
        SIZE = offsets.get(0);
        VERSION = offsets.get(1);
        FLAGS = offsets.get(2);
        PIXELTYPE = offsets.get(3);
        COLORBITS = offsets.get(4);
        REDBITS = offsets.get(5);
        REDSHIRT = offsets.get(6);
        GREENBITS = offsets.get(7);
        GREENSHIFT = offsets.get(8);
        BLUEBITS = offsets.get(9);
        BLUESHIFT = offsets.get(10);
        ALPHABITS = offsets.get(11);
        ALPHASHIFT = offsets.get(12);
        ACCUMBITS = offsets.get(13);
        ACCUMREDBITS = offsets.get(14);
        ACCUMGREENBITS = offsets.get(15);
        ACCUMBLUEBITS = offsets.get(16);
        ACCUMALPHABITS = offsets.get(17);
        DEPTHBITS = offsets.get(18);
        STENCILBITS = offsets.get(19);
        AUXBUFFERS = offsets.get(20);
        LAYERTYPE = offsets.get(21);
        RESERVED = offsets.get(22);
        LAYERMASK = offsets.get(23);
        VISIBLEMASK = offsets.get(24);
        DAMAGEMASK = offsets.get(25);
    }
}

