/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.windows;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.Pointer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.windows.POINT;

public final class LOGPEN
implements Pointer {
    public static final int SIZEOF;
    public static final int LOPNSTYLE;
    public static final int LOPNWIDTH;
    public static final int LOPNCOLOR;
    private final ByteBuffer struct;

    public LOGPEN() {
        this(LOGPEN.malloc());
    }

    public LOGPEN(ByteBuffer struct) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)struct, SIZEOF);
        }
        this.struct = struct;
    }

    public ByteBuffer buffer() {
        return this.struct;
    }

    @Override
    public long getPointer() {
        return MemoryUtil.memAddress(this.struct);
    }

    public void setLopnStyle(int lopnStyle) {
        LOGPEN.lopnStyle(this.struct, lopnStyle);
    }

    public void setLopnWidth(ByteBuffer lopnWidth) {
        LOGPEN.lopnWidthSet(this.struct, lopnWidth);
    }

    public void setLopnWidthX(int x) {
        LOGPEN.lopnWidthX(this.struct, x);
    }

    public void setLopnWidthY(int y) {
        LOGPEN.lopnWidthY(this.struct, y);
    }

    public void setLopnColor(int lopnColor) {
        LOGPEN.lopnColor(this.struct, lopnColor);
    }

    public int getLopnStyle() {
        return LOGPEN.lopnStyle(this.struct);
    }

    public void getLopnWidth(ByteBuffer lopnWidth) {
        LOGPEN.lopnWidthGet(this.struct, lopnWidth);
    }

    public int getLopnWidthX() {
        return LOGPEN.lopnWidthX(this.struct);
    }

    public int getLopnWidthY() {
        return LOGPEN.lopnWidthY(this.struct);
    }

    public int getLopnColor() {
        return LOGPEN.lopnColor(this.struct);
    }

    private static native int offsets(long var0);

    public static ByteBuffer malloc() {
        return BufferUtils.createByteBuffer(SIZEOF);
    }

    public static ByteBuffer malloc(int lopnStyle, ByteBuffer lopnWidth, int lopnColor) {
        ByteBuffer logpen = LOGPEN.malloc();
        LOGPEN.lopnStyle(logpen, lopnStyle);
        LOGPEN.lopnWidthSet(logpen, lopnWidth);
        LOGPEN.lopnColor(logpen, lopnColor);
        return logpen;
    }

    public static void lopnStyle(ByteBuffer logpen, int lopnStyle) {
        logpen.putInt(logpen.position() + LOPNSTYLE, lopnStyle);
    }

    public static void lopnWidthSet(ByteBuffer logpen, ByteBuffer lopnWidth) {
        if (lopnWidth != null) {
            MemoryUtil.memCopy(MemoryUtil.memAddress(lopnWidth), MemoryUtil.memAddress(logpen) + (long)LOPNWIDTH, POINT.SIZEOF);
        }
    }

    public static void lopnWidthX(ByteBuffer logpen, int x) {
        logpen.putInt(logpen.position() + LOPNWIDTH + POINT.X, x);
    }

    public static void lopnWidthY(ByteBuffer logpen, int y) {
        logpen.putInt(logpen.position() + LOPNWIDTH + POINT.Y, y);
    }

    public static void lopnColor(ByteBuffer logpen, int lopnColor) {
        logpen.putInt(logpen.position() + LOPNCOLOR, lopnColor);
    }

    public static int lopnStyle(ByteBuffer logpen) {
        return logpen.getInt(logpen.position() + LOPNSTYLE);
    }

    public static void lopnWidthGet(ByteBuffer logpen, ByteBuffer lopnWidth) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)lopnWidth, POINT.SIZEOF);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(logpen) + (long)LOPNWIDTH, MemoryUtil.memAddress(lopnWidth), POINT.SIZEOF);
    }

    public static int lopnWidthX(ByteBuffer logpen) {
        return logpen.getInt(logpen.position() + LOPNWIDTH + POINT.X);
    }

    public static int lopnWidthY(ByteBuffer logpen) {
        return logpen.getInt(logpen.position() + LOPNWIDTH + POINT.Y);
    }

    public static int lopnColor(ByteBuffer logpen) {
        return logpen.getInt(logpen.position() + LOPNCOLOR);
    }

    static {
        IntBuffer offsets = BufferUtils.createIntBuffer(3);
        SIZEOF = LOGPEN.offsets(MemoryUtil.memAddress(offsets));
        LOPNSTYLE = offsets.get(0);
        LOPNWIDTH = offsets.get(1);
        LOPNCOLOR = offsets.get(2);
    }
}

