/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.linux;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.Pointer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.linux.Visual;

public final class XVisualInfo
implements Pointer {
    public static final int SIZEOF;
    public static final int VISUAL;
    public static final int VISUALID;
    public static final int SCREEN;
    public static final int DEPTH;
    public static final int CLAZZ;
    public static final int RED_MASK;
    public static final int GREEN_MASK;
    public static final int BLUE_MASK;
    public static final int COLORMAP_SIZE;
    public static final int BITS_PER_RGB;
    private final ByteBuffer struct;

    public XVisualInfo() {
        this(XVisualInfo.malloc());
    }

    public XVisualInfo(ByteBuffer struct) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)struct, SIZEOF);
        }
        this.struct = struct;
    }

    public ByteBuffer buffer() {
        return this.struct;
    }

    @Override
    public long getPointer() {
        return MemoryUtil.memAddress(this.struct);
    }

    public void setVisual(long visual) {
        XVisualInfo.visual(this.struct, visual);
    }

    public void setVisual(ByteBuffer visual) {
        XVisualInfo.visual(this.struct, visual);
    }

    public void setVisualid(long visualid) {
        XVisualInfo.visualid(this.struct, visualid);
    }

    public void setScreen(int screen) {
        XVisualInfo.screen(this.struct, screen);
    }

    public void setDepth(int depth) {
        XVisualInfo.depth(this.struct, depth);
    }

    public void setClazz(int clazz) {
        XVisualInfo.clazz(this.struct, clazz);
    }

    public void setRedMask(long red_mask) {
        XVisualInfo.red_mask(this.struct, red_mask);
    }

    public void setGreenMask(long green_mask) {
        XVisualInfo.green_mask(this.struct, green_mask);
    }

    public void setBlueMask(long blue_mask) {
        XVisualInfo.blue_mask(this.struct, blue_mask);
    }

    public void setColormapSize(int colormap_size) {
        XVisualInfo.colormap_size(this.struct, colormap_size);
    }

    public void setBitsPerRgb(int bits_per_rgb) {
        XVisualInfo.bits_per_rgb(this.struct, bits_per_rgb);
    }

    public long getVisual() {
        return XVisualInfo.visual(this.struct);
    }

    public ByteBuffer getVisualBuffer() {
        return XVisualInfo.visualBuffer(this.struct);
    }

    public long getVisualid() {
        return XVisualInfo.visualid(this.struct);
    }

    public int getScreen() {
        return XVisualInfo.screen(this.struct);
    }

    public int getDepth() {
        return XVisualInfo.depth(this.struct);
    }

    public int getClazz() {
        return XVisualInfo.clazz(this.struct);
    }

    public long getRedMask() {
        return XVisualInfo.red_mask(this.struct);
    }

    public long getGreenMask() {
        return XVisualInfo.green_mask(this.struct);
    }

    public long getBlueMask() {
        return XVisualInfo.blue_mask(this.struct);
    }

    public int getColormapSize() {
        return XVisualInfo.colormap_size(this.struct);
    }

    public int getBitsPerRgb() {
        return XVisualInfo.bits_per_rgb(this.struct);
    }

    private static native int offsets(long var0);

    public static ByteBuffer malloc() {
        return BufferUtils.createByteBuffer(SIZEOF);
    }

    public static ByteBuffer malloc(ByteBuffer visual, long visualid, int screen, int depth, int clazz, long red_mask, long green_mask, long blue_mask, int colormap_size, int bits_per_rgb) {
        ByteBuffer xvisualinfo = XVisualInfo.malloc();
        XVisualInfo.visual(xvisualinfo, visual);
        XVisualInfo.visualid(xvisualinfo, visualid);
        XVisualInfo.screen(xvisualinfo, screen);
        XVisualInfo.depth(xvisualinfo, depth);
        XVisualInfo.clazz(xvisualinfo, clazz);
        XVisualInfo.red_mask(xvisualinfo, red_mask);
        XVisualInfo.green_mask(xvisualinfo, green_mask);
        XVisualInfo.blue_mask(xvisualinfo, blue_mask);
        XVisualInfo.colormap_size(xvisualinfo, colormap_size);
        XVisualInfo.bits_per_rgb(xvisualinfo, bits_per_rgb);
        return xvisualinfo;
    }

    public static void visual(ByteBuffer xvisualinfo, long visual) {
        PointerBuffer.put(xvisualinfo, xvisualinfo.position() + VISUAL, visual);
    }

    public static void visual(ByteBuffer xvisualinfo, ByteBuffer visual) {
        XVisualInfo.visual(xvisualinfo, MemoryUtil.memAddressSafe(visual));
    }

    public static void visualid(ByteBuffer xvisualinfo, long visualid) {
        PointerBuffer.put(xvisualinfo, xvisualinfo.position() + VISUALID, visualid);
    }

    public static void screen(ByteBuffer xvisualinfo, int screen) {
        xvisualinfo.putInt(xvisualinfo.position() + SCREEN, screen);
    }

    public static void depth(ByteBuffer xvisualinfo, int depth) {
        xvisualinfo.putInt(xvisualinfo.position() + DEPTH, depth);
    }

    public static void clazz(ByteBuffer xvisualinfo, int clazz) {
        xvisualinfo.putInt(xvisualinfo.position() + CLAZZ, clazz);
    }

    public static void red_mask(ByteBuffer xvisualinfo, long red_mask) {
        PointerBuffer.put(xvisualinfo, xvisualinfo.position() + RED_MASK, red_mask);
    }

    public static void green_mask(ByteBuffer xvisualinfo, long green_mask) {
        PointerBuffer.put(xvisualinfo, xvisualinfo.position() + GREEN_MASK, green_mask);
    }

    public static void blue_mask(ByteBuffer xvisualinfo, long blue_mask) {
        PointerBuffer.put(xvisualinfo, xvisualinfo.position() + BLUE_MASK, blue_mask);
    }

    public static void colormap_size(ByteBuffer xvisualinfo, int colormap_size) {
        xvisualinfo.putInt(xvisualinfo.position() + COLORMAP_SIZE, colormap_size);
    }

    public static void bits_per_rgb(ByteBuffer xvisualinfo, int bits_per_rgb) {
        xvisualinfo.putInt(xvisualinfo.position() + BITS_PER_RGB, bits_per_rgb);
    }

    public static long visual(ByteBuffer xvisualinfo) {
        return PointerBuffer.get(xvisualinfo, xvisualinfo.position() + VISUAL);
    }

    public static ByteBuffer visualBuffer(ByteBuffer xvisualinfo) {
        return MemoryUtil.memByteBuffer(XVisualInfo.visual(xvisualinfo), Visual.SIZEOF);
    }

    public static long visualid(ByteBuffer xvisualinfo) {
        return PointerBuffer.get(xvisualinfo, xvisualinfo.position() + VISUALID);
    }

    public static int screen(ByteBuffer xvisualinfo) {
        return xvisualinfo.getInt(xvisualinfo.position() + SCREEN);
    }

    public static int depth(ByteBuffer xvisualinfo) {
        return xvisualinfo.getInt(xvisualinfo.position() + DEPTH);
    }

    public static int clazz(ByteBuffer xvisualinfo) {
        return xvisualinfo.getInt(xvisualinfo.position() + CLAZZ);
    }

    public static long red_mask(ByteBuffer xvisualinfo) {
        return PointerBuffer.get(xvisualinfo, xvisualinfo.position() + RED_MASK);
    }

    public static long green_mask(ByteBuffer xvisualinfo) {
        return PointerBuffer.get(xvisualinfo, xvisualinfo.position() + GREEN_MASK);
    }

    public static long blue_mask(ByteBuffer xvisualinfo) {
        return PointerBuffer.get(xvisualinfo, xvisualinfo.position() + BLUE_MASK);
    }

    public static int colormap_size(ByteBuffer xvisualinfo) {
        return xvisualinfo.getInt(xvisualinfo.position() + COLORMAP_SIZE);
    }

    public static int bits_per_rgb(ByteBuffer xvisualinfo) {
        return xvisualinfo.getInt(xvisualinfo.position() + BITS_PER_RGB);
    }

    static {
        IntBuffer offsets = BufferUtils.createIntBuffer(10);
        SIZEOF = XVisualInfo.offsets(MemoryUtil.memAddress(offsets));
        VISUAL = offsets.get(0);
        VISUALID = offsets.get(1);
        SCREEN = offsets.get(2);
        DEPTH = offsets.get(3);
        CLAZZ = offsets.get(4);
        RED_MASK = offsets.get(5);
        GREEN_MASK = offsets.get(6);
        BLUE_MASK = offsets.get(7);
        COLORMAP_SIZE = offsets.get(8);
        BITS_PER_RGB = offsets.get(9);
    }
}

