/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.linux;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.Pointer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryUtil;

public final class XRROutputInfo
implements Pointer {
    public static final int SIZEOF;
    public static final int TIMESTAMP;
    public static final int CRTC;
    public static final int NAME;
    public static final int NAMELEN;
    public static final int MM_WIDTH;
    public static final int MM_HEIGHT;
    public static final int CONNECTION;
    public static final int SUBPIXEL_ORDER;
    public static final int NCRTC;
    public static final int CRTCS;
    public static final int NCLONE;
    public static final int CLONES;
    public static final int NMODE;
    public static final int NPREFERRED;
    public static final int MODES;
    private final ByteBuffer struct;

    public XRROutputInfo() {
        this(XRROutputInfo.malloc());
    }

    public XRROutputInfo(ByteBuffer struct) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)struct, SIZEOF);
        }
        this.struct = struct;
    }

    public ByteBuffer buffer() {
        return this.struct;
    }

    @Override
    public long getPointer() {
        return MemoryUtil.memAddress(this.struct);
    }

    public void setTimestamp(long timestamp) {
        XRROutputInfo.timestamp(this.struct, timestamp);
    }

    public void setCrtc(long crtc) {
        XRROutputInfo.crtc(this.struct, crtc);
    }

    public void setName(long name) {
        XRROutputInfo.name(this.struct, name);
    }

    public void setName(ByteBuffer name) {
        XRROutputInfo.name(this.struct, name);
    }

    public void setNameLen(int nameLen) {
        XRROutputInfo.nameLen(this.struct, nameLen);
    }

    public void setMmWidth(long mm_width) {
        XRROutputInfo.mm_width(this.struct, mm_width);
    }

    public void setMmHeight(long mm_height) {
        XRROutputInfo.mm_height(this.struct, mm_height);
    }

    public void setConnection(int connection) {
        XRROutputInfo.connection(this.struct, connection);
    }

    public void setSubpixelOrder(int subpixel_order) {
        XRROutputInfo.subpixel_order(this.struct, subpixel_order);
    }

    public void setNcrtc(int ncrtc) {
        XRROutputInfo.ncrtc(this.struct, ncrtc);
    }

    public void setCrtcs(long crtcs) {
        XRROutputInfo.crtcs(this.struct, crtcs);
    }

    public void setCrtcs(ByteBuffer crtcs) {
        XRROutputInfo.crtcs(this.struct, crtcs);
    }

    public void setNclone(int nclone) {
        XRROutputInfo.nclone(this.struct, nclone);
    }

    public void setClones(long clones) {
        XRROutputInfo.clones(this.struct, clones);
    }

    public void setClones(ByteBuffer clones) {
        XRROutputInfo.clones(this.struct, clones);
    }

    public void setNmode(int nmode) {
        XRROutputInfo.nmode(this.struct, nmode);
    }

    public void setNpreferred(int npreferred) {
        XRROutputInfo.npreferred(this.struct, npreferred);
    }

    public void setModes(long modes) {
        XRROutputInfo.modes(this.struct, modes);
    }

    public void setModes(ByteBuffer modes) {
        XRROutputInfo.modes(this.struct, modes);
    }

    public long getTimestamp() {
        return XRROutputInfo.timestamp(this.struct);
    }

    public long getCrtc() {
        return XRROutputInfo.crtc(this.struct);
    }

    public long getName() {
        return XRROutputInfo.name(this.struct);
    }

    public ByteBuffer getName(int byteLen) {
        return XRROutputInfo.name(this.struct, byteLen);
    }

    public int getNameLen() {
        return XRROutputInfo.nameLen(this.struct);
    }

    public long getMmWidth() {
        return XRROutputInfo.mm_width(this.struct);
    }

    public long getMmHeight() {
        return XRROutputInfo.mm_height(this.struct);
    }

    public int getConnection() {
        return XRROutputInfo.connection(this.struct);
    }

    public int getSubpixelOrder() {
        return XRROutputInfo.subpixel_order(this.struct);
    }

    public int getNcrtc() {
        return XRROutputInfo.ncrtc(this.struct);
    }

    public long getCrtcs() {
        return XRROutputInfo.crtcs(this.struct);
    }

    public ByteBuffer getCrtcs(int byteLen) {
        return XRROutputInfo.crtcs(this.struct, byteLen);
    }

    public int getNclone() {
        return XRROutputInfo.nclone(this.struct);
    }

    public long getClones() {
        return XRROutputInfo.clones(this.struct);
    }

    public ByteBuffer getClones(int byteLen) {
        return XRROutputInfo.clones(this.struct, byteLen);
    }

    public int getNmode() {
        return XRROutputInfo.nmode(this.struct);
    }

    public int getNpreferred() {
        return XRROutputInfo.npreferred(this.struct);
    }

    public long getModes() {
        return XRROutputInfo.modes(this.struct);
    }

    public ByteBuffer getModes(int byteLen) {
        return XRROutputInfo.modes(this.struct, byteLen);
    }

    private static native int offsets(long var0);

    public static ByteBuffer malloc() {
        return BufferUtils.createByteBuffer(SIZEOF);
    }

    public static ByteBuffer malloc(long timestamp, long crtc, ByteBuffer name, int nameLen, long mm_width, long mm_height, int connection, int subpixel_order, int ncrtc, ByteBuffer crtcs, int nclone, ByteBuffer clones, int nmode, int npreferred, ByteBuffer modes) {
        ByteBuffer xrroutputinfo = XRROutputInfo.malloc();
        XRROutputInfo.timestamp(xrroutputinfo, timestamp);
        XRROutputInfo.crtc(xrroutputinfo, crtc);
        XRROutputInfo.name(xrroutputinfo, name);
        XRROutputInfo.nameLen(xrroutputinfo, nameLen);
        XRROutputInfo.mm_width(xrroutputinfo, mm_width);
        XRROutputInfo.mm_height(xrroutputinfo, mm_height);
        XRROutputInfo.connection(xrroutputinfo, connection);
        XRROutputInfo.subpixel_order(xrroutputinfo, subpixel_order);
        XRROutputInfo.ncrtc(xrroutputinfo, ncrtc);
        XRROutputInfo.crtcs(xrroutputinfo, crtcs);
        XRROutputInfo.nclone(xrroutputinfo, nclone);
        XRROutputInfo.clones(xrroutputinfo, clones);
        XRROutputInfo.nmode(xrroutputinfo, nmode);
        XRROutputInfo.npreferred(xrroutputinfo, npreferred);
        XRROutputInfo.modes(xrroutputinfo, modes);
        return xrroutputinfo;
    }

    public static void timestamp(ByteBuffer xrroutputinfo, long timestamp) {
        PointerBuffer.put(xrroutputinfo, xrroutputinfo.position() + TIMESTAMP, timestamp);
    }

    public static void crtc(ByteBuffer xrroutputinfo, long crtc) {
        PointerBuffer.put(xrroutputinfo, xrroutputinfo.position() + CRTC, crtc);
    }

    public static void name(ByteBuffer xrroutputinfo, long name) {
        PointerBuffer.put(xrroutputinfo, xrroutputinfo.position() + NAME, name);
    }

    public static void name(ByteBuffer xrroutputinfo, ByteBuffer name) {
        XRROutputInfo.name(xrroutputinfo, MemoryUtil.memAddressSafe(name));
    }

    public static void nameLen(ByteBuffer xrroutputinfo, int nameLen) {
        xrroutputinfo.putInt(xrroutputinfo.position() + NAMELEN, nameLen);
    }

    public static void mm_width(ByteBuffer xrroutputinfo, long mm_width) {
        PointerBuffer.put(xrroutputinfo, xrroutputinfo.position() + MM_WIDTH, mm_width);
    }

    public static void mm_height(ByteBuffer xrroutputinfo, long mm_height) {
        PointerBuffer.put(xrroutputinfo, xrroutputinfo.position() + MM_HEIGHT, mm_height);
    }

    public static void connection(ByteBuffer xrroutputinfo, int connection) {
        xrroutputinfo.putShort(xrroutputinfo.position() + CONNECTION, (short)connection);
    }

    public static void subpixel_order(ByteBuffer xrroutputinfo, int subpixel_order) {
        xrroutputinfo.putShort(xrroutputinfo.position() + SUBPIXEL_ORDER, (short)subpixel_order);
    }

    public static void ncrtc(ByteBuffer xrroutputinfo, int ncrtc) {
        xrroutputinfo.putInt(xrroutputinfo.position() + NCRTC, ncrtc);
    }

    public static void crtcs(ByteBuffer xrroutputinfo, long crtcs) {
        PointerBuffer.put(xrroutputinfo, xrroutputinfo.position() + CRTCS, crtcs);
    }

    public static void crtcs(ByteBuffer xrroutputinfo, ByteBuffer crtcs) {
        XRROutputInfo.crtcs(xrroutputinfo, MemoryUtil.memAddressSafe(crtcs));
    }

    public static void nclone(ByteBuffer xrroutputinfo, int nclone) {
        xrroutputinfo.putInt(xrroutputinfo.position() + NCLONE, nclone);
    }

    public static void clones(ByteBuffer xrroutputinfo, long clones) {
        PointerBuffer.put(xrroutputinfo, xrroutputinfo.position() + CLONES, clones);
    }

    public static void clones(ByteBuffer xrroutputinfo, ByteBuffer clones) {
        XRROutputInfo.clones(xrroutputinfo, MemoryUtil.memAddressSafe(clones));
    }

    public static void nmode(ByteBuffer xrroutputinfo, int nmode) {
        xrroutputinfo.putInt(xrroutputinfo.position() + NMODE, nmode);
    }

    public static void npreferred(ByteBuffer xrroutputinfo, int npreferred) {
        xrroutputinfo.putInt(xrroutputinfo.position() + NPREFERRED, npreferred);
    }

    public static void modes(ByteBuffer xrroutputinfo, long modes) {
        PointerBuffer.put(xrroutputinfo, xrroutputinfo.position() + MODES, modes);
    }

    public static void modes(ByteBuffer xrroutputinfo, ByteBuffer modes) {
        XRROutputInfo.modes(xrroutputinfo, MemoryUtil.memAddressSafe(modes));
    }

    public static long timestamp(ByteBuffer xrroutputinfo) {
        return PointerBuffer.get(xrroutputinfo, xrroutputinfo.position() + TIMESTAMP);
    }

    public static long crtc(ByteBuffer xrroutputinfo) {
        return PointerBuffer.get(xrroutputinfo, xrroutputinfo.position() + CRTC);
    }

    public static long name(ByteBuffer xrroutputinfo) {
        return PointerBuffer.get(xrroutputinfo, xrroutputinfo.position() + NAME);
    }

    public static ByteBuffer name(ByteBuffer xrroutputinfo, int byteLen) {
        return MemoryUtil.memByteBuffer(XRROutputInfo.name(xrroutputinfo), byteLen);
    }

    public static int nameLen(ByteBuffer xrroutputinfo) {
        return xrroutputinfo.getInt(xrroutputinfo.position() + NAMELEN);
    }

    public static long mm_width(ByteBuffer xrroutputinfo) {
        return PointerBuffer.get(xrroutputinfo, xrroutputinfo.position() + MM_WIDTH);
    }

    public static long mm_height(ByteBuffer xrroutputinfo) {
        return PointerBuffer.get(xrroutputinfo, xrroutputinfo.position() + MM_HEIGHT);
    }

    public static int connection(ByteBuffer xrroutputinfo) {
        return xrroutputinfo.getShort(xrroutputinfo.position() + CONNECTION) & 0xFFFF;
    }

    public static int subpixel_order(ByteBuffer xrroutputinfo) {
        return xrroutputinfo.getShort(xrroutputinfo.position() + SUBPIXEL_ORDER) & 0xFFFF;
    }

    public static int ncrtc(ByteBuffer xrroutputinfo) {
        return xrroutputinfo.getInt(xrroutputinfo.position() + NCRTC);
    }

    public static long crtcs(ByteBuffer xrroutputinfo) {
        return PointerBuffer.get(xrroutputinfo, xrroutputinfo.position() + CRTCS);
    }

    public static ByteBuffer crtcs(ByteBuffer xrroutputinfo, int byteLen) {
        return MemoryUtil.memByteBuffer(XRROutputInfo.crtcs(xrroutputinfo), byteLen);
    }

    public static int nclone(ByteBuffer xrroutputinfo) {
        return xrroutputinfo.getInt(xrroutputinfo.position() + NCLONE);
    }

    public static long clones(ByteBuffer xrroutputinfo) {
        return PointerBuffer.get(xrroutputinfo, xrroutputinfo.position() + CLONES);
    }

    public static ByteBuffer clones(ByteBuffer xrroutputinfo, int byteLen) {
        return MemoryUtil.memByteBuffer(XRROutputInfo.clones(xrroutputinfo), byteLen);
    }

    public static int nmode(ByteBuffer xrroutputinfo) {
        return xrroutputinfo.getInt(xrroutputinfo.position() + NMODE);
    }

    public static int npreferred(ByteBuffer xrroutputinfo) {
        return xrroutputinfo.getInt(xrroutputinfo.position() + NPREFERRED);
    }

    public static long modes(ByteBuffer xrroutputinfo) {
        return PointerBuffer.get(xrroutputinfo, xrroutputinfo.position() + MODES);
    }

    public static ByteBuffer modes(ByteBuffer xrroutputinfo, int byteLen) {
        return MemoryUtil.memByteBuffer(XRROutputInfo.modes(xrroutputinfo), byteLen);
    }

    static {
        IntBuffer offsets = BufferUtils.createIntBuffer(15);
        SIZEOF = XRROutputInfo.offsets(MemoryUtil.memAddress(offsets));
        TIMESTAMP = offsets.get(0);
        CRTC = offsets.get(1);
        NAME = offsets.get(2);
        NAMELEN = offsets.get(3);
        MM_WIDTH = offsets.get(4);
        MM_HEIGHT = offsets.get(5);
        CONNECTION = offsets.get(6);
        SUBPIXEL_ORDER = offsets.get(7);
        NCRTC = offsets.get(8);
        CRTCS = offsets.get(9);
        NCLONE = offsets.get(10);
        CLONES = offsets.get(11);
        NMODE = offsets.get(12);
        NPREFERRED = offsets.get(13);
        MODES = offsets.get(14);
    }
}

