/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.linux;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.Pointer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryUtil;

public final class XIValuatorState
implements Pointer {
    public static final int SIZEOF;
    public static final int MASK_LEN;
    public static final int MASK;
    public static final int VALUES;
    private final ByteBuffer struct;

    public XIValuatorState() {
        this(XIValuatorState.malloc());
    }

    public XIValuatorState(ByteBuffer struct) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)struct, SIZEOF);
        }
        this.struct = struct;
    }

    public ByteBuffer buffer() {
        return this.struct;
    }

    @Override
    public long getPointer() {
        return MemoryUtil.memAddress(this.struct);
    }

    public void setMaskLen(int mask_len) {
        XIValuatorState.mask_len(this.struct, mask_len);
    }

    public void setMask(long mask) {
        XIValuatorState.mask(this.struct, mask);
    }

    public void setMask(ByteBuffer mask) {
        XIValuatorState.mask(this.struct, mask);
    }

    public void setValues(long values) {
        XIValuatorState.values(this.struct, values);
    }

    public void setValues(ByteBuffer values) {
        XIValuatorState.values(this.struct, values);
    }

    public int getMaskLen() {
        return XIValuatorState.mask_len(this.struct);
    }

    public long getMask() {
        return XIValuatorState.mask(this.struct);
    }

    public ByteBuffer getMask(int byteLen) {
        return XIValuatorState.mask(this.struct, byteLen);
    }

    public long getValues() {
        return XIValuatorState.values(this.struct);
    }

    public ByteBuffer getValues(int byteLen) {
        return XIValuatorState.values(this.struct, byteLen);
    }

    private static native int offsets(long var0);

    public static ByteBuffer malloc() {
        return BufferUtils.createByteBuffer(SIZEOF);
    }

    public static ByteBuffer malloc(int mask_len, ByteBuffer mask, ByteBuffer values) {
        ByteBuffer xivaluatorstate = XIValuatorState.malloc();
        XIValuatorState.mask_len(xivaluatorstate, mask_len);
        XIValuatorState.mask(xivaluatorstate, mask);
        XIValuatorState.values(xivaluatorstate, values);
        return xivaluatorstate;
    }

    public static void mask_len(ByteBuffer xivaluatorstate, int mask_len) {
        xivaluatorstate.putInt(xivaluatorstate.position() + MASK_LEN, mask_len);
    }

    public static void mask(ByteBuffer xivaluatorstate, long mask) {
        PointerBuffer.put(xivaluatorstate, xivaluatorstate.position() + MASK, mask);
    }

    public static void mask(ByteBuffer xivaluatorstate, ByteBuffer mask) {
        XIValuatorState.mask(xivaluatorstate, MemoryUtil.memAddressSafe(mask));
    }

    public static void values(ByteBuffer xivaluatorstate, long values) {
        PointerBuffer.put(xivaluatorstate, xivaluatorstate.position() + VALUES, values);
    }

    public static void values(ByteBuffer xivaluatorstate, ByteBuffer values) {
        XIValuatorState.values(xivaluatorstate, MemoryUtil.memAddressSafe(values));
    }

    public static int mask_len(ByteBuffer xivaluatorstate) {
        return xivaluatorstate.getInt(xivaluatorstate.position() + MASK_LEN);
    }

    public static long mask(ByteBuffer xivaluatorstate) {
        return PointerBuffer.get(xivaluatorstate, xivaluatorstate.position() + MASK);
    }

    public static ByteBuffer mask(ByteBuffer xivaluatorstate, int byteLen) {
        return MemoryUtil.memByteBuffer(XIValuatorState.mask(xivaluatorstate), byteLen);
    }

    public static long values(ByteBuffer xivaluatorstate) {
        return PointerBuffer.get(xivaluatorstate, xivaluatorstate.position() + VALUES);
    }

    public static ByteBuffer values(ByteBuffer xivaluatorstate, int byteLen) {
        return MemoryUtil.memByteBuffer(XIValuatorState.values(xivaluatorstate), byteLen);
    }

    static {
        IntBuffer offsets = BufferUtils.createIntBuffer(3);
        SIZEOF = XIValuatorState.offsets(MemoryUtil.memAddress(offsets));
        MASK_LEN = offsets.get(0);
        MASK = offsets.get(1);
        VALUES = offsets.get(2);
    }
}

