/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.linux;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.Pointer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryUtil;

public final class XClassHint
implements Pointer {
    public static final int SIZEOF;
    public static final int RES_NAME;
    public static final int RES_CLASS;
    private final ByteBuffer struct;

    public XClassHint() {
        this(XClassHint.malloc());
    }

    public XClassHint(ByteBuffer struct) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)struct, SIZEOF);
        }
        this.struct = struct;
    }

    public ByteBuffer buffer() {
        return this.struct;
    }

    @Override
    public long getPointer() {
        return MemoryUtil.memAddress(this.struct);
    }

    public void setResName(long res_name) {
        XClassHint.res_name(this.struct, res_name);
    }

    public void setResName(ByteBuffer res_name) {
        XClassHint.res_name(this.struct, res_name);
    }

    public void setResClass(long res_class) {
        XClassHint.res_class(this.struct, res_class);
    }

    public void setResClass(ByteBuffer res_class) {
        XClassHint.res_class(this.struct, res_class);
    }

    public long getResName() {
        return XClassHint.res_name(this.struct);
    }

    public ByteBuffer getResNameBuffer() {
        return XClassHint.res_nameBuffer(this.struct);
    }

    public String getResNameString() {
        return XClassHint.res_nameString(this.struct);
    }

    public long getResClass() {
        return XClassHint.res_class(this.struct);
    }

    public ByteBuffer getResClassBuffer() {
        return XClassHint.res_classBuffer(this.struct);
    }

    public String getResClassString() {
        return XClassHint.res_classString(this.struct);
    }

    private static native int offsets(long var0);

    public static ByteBuffer malloc() {
        return BufferUtils.createByteBuffer(SIZEOF);
    }

    public static ByteBuffer malloc(ByteBuffer res_name, ByteBuffer res_class) {
        ByteBuffer xclasshint = XClassHint.malloc();
        XClassHint.res_name(xclasshint, res_name);
        XClassHint.res_class(xclasshint, res_class);
        return xclasshint;
    }

    public static void res_name(ByteBuffer xclasshint, long res_name) {
        PointerBuffer.put(xclasshint, xclasshint.position() + RES_NAME, res_name);
    }

    public static void res_name(ByteBuffer xclasshint, ByteBuffer res_name) {
        if (LWJGLUtil.CHECKS && res_name != null) {
            Checks.checkNT1(res_name);
        }
        XClassHint.res_name(xclasshint, MemoryUtil.memAddressSafe(res_name));
    }

    public static void res_class(ByteBuffer xclasshint, long res_class) {
        PointerBuffer.put(xclasshint, xclasshint.position() + RES_CLASS, res_class);
    }

    public static void res_class(ByteBuffer xclasshint, ByteBuffer res_class) {
        if (LWJGLUtil.CHECKS && res_class != null) {
            Checks.checkNT1(res_class);
        }
        XClassHint.res_class(xclasshint, MemoryUtil.memAddressSafe(res_class));
    }

    public static long res_name(ByteBuffer xclasshint) {
        return PointerBuffer.get(xclasshint, xclasshint.position() + RES_NAME);
    }

    public static ByteBuffer res_nameBuffer(ByteBuffer xclasshint) {
        return MemoryUtil.memByteBufferNT1(XClassHint.res_name(xclasshint));
    }

    public static String res_nameString(ByteBuffer xclasshint) {
        return MemoryUtil.memDecodeASCII(XClassHint.res_name(xclasshint));
    }

    public static long res_class(ByteBuffer xclasshint) {
        return PointerBuffer.get(xclasshint, xclasshint.position() + RES_CLASS);
    }

    public static ByteBuffer res_classBuffer(ByteBuffer xclasshint) {
        return MemoryUtil.memByteBufferNT1(XClassHint.res_class(xclasshint));
    }

    public static String res_classString(ByteBuffer xclasshint) {
        return MemoryUtil.memDecodeASCII(XClassHint.res_class(xclasshint));
    }

    static {
        IntBuffer offsets = BufferUtils.createIntBuffer(2);
        SIZEOF = XClassHint.offsets(MemoryUtil.memAddress(offsets));
        RES_NAME = offsets.get(0);
        RES_CLASS = offsets.get(1);
    }
}

