/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.linux;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.Pointer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryUtil;

public final class Visual
implements Pointer {
    public static final int SIZEOF;
    public static final int VISUALID;
    public static final int CLAZZ;
    public static final int RED_MASK;
    public static final int GREEN_MASK;
    public static final int BLUE_MASK;
    public static final int BITS_PER_RGB;
    public static final int MAP_ENTRIES;
    private final ByteBuffer struct;

    public Visual() {
        this(Visual.malloc());
    }

    public Visual(ByteBuffer struct) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)struct, SIZEOF);
        }
        this.struct = struct;
    }

    public ByteBuffer buffer() {
        return this.struct;
    }

    @Override
    public long getPointer() {
        return MemoryUtil.memAddress(this.struct);
    }

    public void setVisualid(long visualid) {
        Visual.visualid(this.struct, visualid);
    }

    public void setClazz(int clazz) {
        Visual.clazz(this.struct, clazz);
    }

    public void setRedMask(long red_mask) {
        Visual.red_mask(this.struct, red_mask);
    }

    public void setGreenMask(long green_mask) {
        Visual.green_mask(this.struct, green_mask);
    }

    public void setBlueMask(long blue_mask) {
        Visual.blue_mask(this.struct, blue_mask);
    }

    public void setBitsPerRgb(int bits_per_rgb) {
        Visual.bits_per_rgb(this.struct, bits_per_rgb);
    }

    public void setMapEntries(int map_entries) {
        Visual.map_entries(this.struct, map_entries);
    }

    public long getVisualid() {
        return Visual.visualid(this.struct);
    }

    public int getClazz() {
        return Visual.clazz(this.struct);
    }

    public long getRedMask() {
        return Visual.red_mask(this.struct);
    }

    public long getGreenMask() {
        return Visual.green_mask(this.struct);
    }

    public long getBlueMask() {
        return Visual.blue_mask(this.struct);
    }

    public int getBitsPerRgb() {
        return Visual.bits_per_rgb(this.struct);
    }

    public int getMapEntries() {
        return Visual.map_entries(this.struct);
    }

    private static native int offsets(long var0);

    public static ByteBuffer malloc() {
        return BufferUtils.createByteBuffer(SIZEOF);
    }

    public static ByteBuffer malloc(long visualid, int clazz, long red_mask, long green_mask, long blue_mask, int bits_per_rgb, int map_entries) {
        ByteBuffer visual = Visual.malloc();
        Visual.visualid(visual, visualid);
        Visual.clazz(visual, clazz);
        Visual.red_mask(visual, red_mask);
        Visual.green_mask(visual, green_mask);
        Visual.blue_mask(visual, blue_mask);
        Visual.bits_per_rgb(visual, bits_per_rgb);
        Visual.map_entries(visual, map_entries);
        return visual;
    }

    public static void visualid(ByteBuffer visual, long visualid) {
        PointerBuffer.put(visual, visual.position() + VISUALID, visualid);
    }

    public static void clazz(ByteBuffer visual, int clazz) {
        visual.putInt(visual.position() + CLAZZ, clazz);
    }

    public static void red_mask(ByteBuffer visual, long red_mask) {
        PointerBuffer.put(visual, visual.position() + RED_MASK, red_mask);
    }

    public static void green_mask(ByteBuffer visual, long green_mask) {
        PointerBuffer.put(visual, visual.position() + GREEN_MASK, green_mask);
    }

    public static void blue_mask(ByteBuffer visual, long blue_mask) {
        PointerBuffer.put(visual, visual.position() + BLUE_MASK, blue_mask);
    }

    public static void bits_per_rgb(ByteBuffer visual, int bits_per_rgb) {
        visual.putInt(visual.position() + BITS_PER_RGB, bits_per_rgb);
    }

    public static void map_entries(ByteBuffer visual, int map_entries) {
        visual.putInt(visual.position() + MAP_ENTRIES, map_entries);
    }

    public static long visualid(ByteBuffer visual) {
        return PointerBuffer.get(visual, visual.position() + VISUALID);
    }

    public static int clazz(ByteBuffer visual) {
        return visual.getInt(visual.position() + CLAZZ);
    }

    public static long red_mask(ByteBuffer visual) {
        return PointerBuffer.get(visual, visual.position() + RED_MASK);
    }

    public static long green_mask(ByteBuffer visual) {
        return PointerBuffer.get(visual, visual.position() + GREEN_MASK);
    }

    public static long blue_mask(ByteBuffer visual) {
        return PointerBuffer.get(visual, visual.position() + BLUE_MASK);
    }

    public static int bits_per_rgb(ByteBuffer visual) {
        return visual.getInt(visual.position() + BITS_PER_RGB);
    }

    public static int map_entries(ByteBuffer visual) {
        return visual.getInt(visual.position() + MAP_ENTRIES);
    }

    static {
        IntBuffer offsets = BufferUtils.createIntBuffer(7);
        SIZEOF = Visual.offsets(MemoryUtil.memAddress(offsets));
        VISUALID = offsets.get(0);
        CLAZZ = offsets.get(1);
        RED_MASK = offsets.get(2);
        GREEN_MASK = offsets.get(3);
        BLUE_MASK = offsets.get(4);
        BITS_PER_RGB = offsets.get(5);
        MAP_ENTRIES = offsets.get(6);
    }
}

