/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.libffi;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.Pointer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryUtil;

public final class FFIType
implements Pointer {
    public static final int SIZEOF;
    public static final int SIZE;
    public static final int ALIGNMENT;
    public static final int TYPE;
    public static final int ELEMENTS;
    private final ByteBuffer struct;

    public FFIType() {
        this(FFIType.malloc());
    }

    public FFIType(ByteBuffer struct) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)struct, SIZEOF);
        }
        this.struct = struct;
    }

    public ByteBuffer buffer() {
        return this.struct;
    }

    @Override
    public long getPointer() {
        return MemoryUtil.memAddress(this.struct);
    }

    public void setSize(long size) {
        FFIType.size(this.struct, size);
    }

    public void setAlignment(int alignment) {
        FFIType.alignment(this.struct, alignment);
    }

    public void setType(int type) {
        FFIType.type(this.struct, type);
    }

    public void setElements(long elements) {
        FFIType.elements(this.struct, elements);
    }

    public void setElements(ByteBuffer elements) {
        FFIType.elements(this.struct, elements);
    }

    public long getSize() {
        return FFIType.size(this.struct);
    }

    public int getAlignment() {
        return FFIType.alignment(this.struct);
    }

    public int getType() {
        return FFIType.type(this.struct);
    }

    public long getElements() {
        return FFIType.elements(this.struct);
    }

    public ByteBuffer getElements(int byteLen) {
        return FFIType.elements(this.struct, byteLen);
    }

    private static native int offsets(long var0);

    public static ByteBuffer malloc() {
        return BufferUtils.createByteBuffer(SIZEOF);
    }

    public static ByteBuffer malloc(long size, int alignment, int type, ByteBuffer elements) {
        ByteBuffer ffi_type = FFIType.malloc();
        FFIType.size(ffi_type, size);
        FFIType.alignment(ffi_type, alignment);
        FFIType.type(ffi_type, type);
        FFIType.elements(ffi_type, elements);
        return ffi_type;
    }

    public static void size(ByteBuffer ffi_type, long size) {
        PointerBuffer.put(ffi_type, ffi_type.position() + SIZE, size);
    }

    public static void alignment(ByteBuffer ffi_type, int alignment) {
        ffi_type.putShort(ffi_type.position() + ALIGNMENT, (short)alignment);
    }

    public static void type(ByteBuffer ffi_type, int type) {
        ffi_type.putShort(ffi_type.position() + TYPE, (short)type);
    }

    public static void elements(ByteBuffer ffi_type, long elements) {
        PointerBuffer.put(ffi_type, ffi_type.position() + ELEMENTS, elements);
    }

    public static void elements(ByteBuffer ffi_type, ByteBuffer elements) {
        FFIType.elements(ffi_type, MemoryUtil.memAddressSafe(elements));
    }

    public static long size(ByteBuffer ffi_type) {
        return PointerBuffer.get(ffi_type, ffi_type.position() + SIZE);
    }

    public static int alignment(ByteBuffer ffi_type) {
        return ffi_type.getShort(ffi_type.position() + ALIGNMENT) & 0xFFFF;
    }

    public static int type(ByteBuffer ffi_type) {
        return ffi_type.getShort(ffi_type.position() + TYPE) & 0xFFFF;
    }

    public static long elements(ByteBuffer ffi_type) {
        return PointerBuffer.get(ffi_type, ffi_type.position() + ELEMENTS);
    }

    public static ByteBuffer elements(ByteBuffer ffi_type, int byteLen) {
        return MemoryUtil.memByteBuffer(FFIType.elements(ffi_type), byteLen);
    }

    static {
        IntBuffer offsets = BufferUtils.createIntBuffer(4);
        SIZEOF = FFIType.offsets(MemoryUtil.memAddress(offsets));
        SIZE = offsets.get(0);
        ALIGNMENT = offsets.get(1);
        TYPE = offsets.get(2);
        ELEMENTS = offsets.get(3);
    }
}

