/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.ByteBuffer;
import java.util.Set;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.opengl.GL;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.MemoryUtil;

public final class NVBindlessMultiDrawIndirect {
    public final long MultiDrawArraysIndirectBindlessNV;
    public final long MultiDrawElementsIndirectBindlessNV;

    public NVBindlessMultiDrawIndirect(FunctionProvider provider) {
        this.MultiDrawArraysIndirectBindlessNV = provider.getFunctionAddress("glMultiDrawArraysIndirectBindlessNV");
        this.MultiDrawElementsIndirectBindlessNV = provider.getFunctionAddress("glMultiDrawElementsIndirectBindlessNV");
    }

    public static NVBindlessMultiDrawIndirect getInstance() {
        return GL.getCapabilities().__NVBindlessMultiDrawIndirect;
    }

    static NVBindlessMultiDrawIndirect create(Set<String> ext, FunctionProvider provider) {
        if (!ext.contains("GL_NV_bindless_multi_draw_indirect")) {
            return null;
        }
        NVBindlessMultiDrawIndirect funcs = new NVBindlessMultiDrawIndirect(provider);
        boolean supported = Checks.checkFunctions(funcs.MultiDrawArraysIndirectBindlessNV, funcs.MultiDrawElementsIndirectBindlessNV);
        return GL.checkExtension("GL_NV_bindless_multi_draw_indirect", funcs, supported);
    }

    public static native void nglMultiDrawArraysIndirectBindlessNV(int var0, long var1, int var3, int var4, int var5, long var6);

    public static void nglMultiDrawArraysIndirectBindlessNV(int mode, long indirect, int drawCount, int stride, int vertexBufferCount) {
        long __functionAddress = NVBindlessMultiDrawIndirect.getInstance().MultiDrawArraysIndirectBindlessNV;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        NVBindlessMultiDrawIndirect.nglMultiDrawArraysIndirectBindlessNV(mode, indirect, drawCount, stride, vertexBufferCount, __functionAddress);
    }

    public static void glMultiDrawArraysIndirectBindlessNV(int mode, ByteBuffer indirect, int drawCount, int stride, int vertexBufferCount) {
        NVBindlessMultiDrawIndirect.nglMultiDrawArraysIndirectBindlessNV(mode, MemoryUtil.memAddress(indirect), drawCount, stride, vertexBufferCount);
    }

    public static native void nglMultiDrawElementsIndirectBindlessNV(int var0, int var1, long var2, int var4, int var5, int var6, long var7);

    public static void nglMultiDrawElementsIndirectBindlessNV(int mode, int type, long indirect, int drawCount, int stride, int vertexBufferCount) {
        long __functionAddress = NVBindlessMultiDrawIndirect.getInstance().MultiDrawElementsIndirectBindlessNV;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        NVBindlessMultiDrawIndirect.nglMultiDrawElementsIndirectBindlessNV(mode, type, indirect, drawCount, stride, vertexBufferCount, __functionAddress);
    }

    public static void glMultiDrawElementsIndirectBindlessNV(int mode, int type, ByteBuffer indirect, int drawCount, int stride, int vertexBufferCount) {
        NVBindlessMultiDrawIndirect.nglMultiDrawElementsIndirectBindlessNV(mode, type, MemoryUtil.memAddress(indirect), drawCount, stride, vertexBufferCount);
    }
}

