/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.Pointer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.windows.RECT;

public final class GPU_DEVICE
implements Pointer {
    public static final int SIZEOF;
    public static final int CB;
    public static final int DEVICENAME;
    public static final int DEVICESTRING;
    public static final int FLAGS;
    public static final int VIRTUALSCREEN;
    private final ByteBuffer struct;

    public GPU_DEVICE() {
        this(GPU_DEVICE.malloc());
    }

    public GPU_DEVICE(ByteBuffer struct) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)struct, SIZEOF);
        }
        this.struct = struct;
    }

    public ByteBuffer buffer() {
        return this.struct;
    }

    @Override
    public long getPointer() {
        return MemoryUtil.memAddress(this.struct);
    }

    public void setCb(int cb) {
        GPU_DEVICE.cb(this.struct, cb);
    }

    public void setDeviceName(ByteBuffer DeviceName) {
        GPU_DEVICE.DeviceNameSet(this.struct, DeviceName);
    }

    public void setDeviceName(CharSequence DeviceName) {
        GPU_DEVICE.DeviceName(this.struct, DeviceName);
    }

    public void setDeviceString(ByteBuffer DeviceString) {
        GPU_DEVICE.DeviceStringSet(this.struct, DeviceString);
    }

    public void setDeviceString(CharSequence DeviceString) {
        GPU_DEVICE.DeviceString(this.struct, DeviceString);
    }

    public void setFlags(int Flags) {
        GPU_DEVICE.Flags(this.struct, Flags);
    }

    public void setVirtualScreen(ByteBuffer virtualScreen) {
        GPU_DEVICE.virtualScreenSet(this.struct, virtualScreen);
    }

    public void setVirtualScreenLeft(int left) {
        GPU_DEVICE.virtualScreenLeft(this.struct, left);
    }

    public void setVirtualScreenTop(int top) {
        GPU_DEVICE.virtualScreenTop(this.struct, top);
    }

    public void setVirtualScreenRight(int right) {
        GPU_DEVICE.virtualScreenRight(this.struct, right);
    }

    public void setVirtualScreenBottom(int bottom) {
        GPU_DEVICE.virtualScreenBottom(this.struct, bottom);
    }

    public int getCb() {
        return GPU_DEVICE.cb(this.struct);
    }

    public void getDeviceName(ByteBuffer DeviceName) {
        GPU_DEVICE.DeviceNameGet(this.struct, DeviceName);
    }

    public String getDeviceNameString() {
        return GPU_DEVICE.DeviceNameString(this.struct);
    }

    public String getDeviceNameString(int byteLen) {
        return GPU_DEVICE.DeviceNameString(this.struct, byteLen);
    }

    public void getDeviceString(ByteBuffer DeviceString) {
        GPU_DEVICE.DeviceStringGet(this.struct, DeviceString);
    }

    public String getDeviceStringString() {
        return GPU_DEVICE.DeviceStringString(this.struct);
    }

    public String getDeviceStringString(int byteLen) {
        return GPU_DEVICE.DeviceStringString(this.struct, byteLen);
    }

    public int getFlags() {
        return GPU_DEVICE.Flags(this.struct);
    }

    public void getVirtualScreen(ByteBuffer virtualScreen) {
        GPU_DEVICE.virtualScreenGet(this.struct, virtualScreen);
    }

    public int getVirtualScreenLeft() {
        return GPU_DEVICE.virtualScreenLeft(this.struct);
    }

    public int getVirtualScreenTop() {
        return GPU_DEVICE.virtualScreenTop(this.struct);
    }

    public int getVirtualScreenRight() {
        return GPU_DEVICE.virtualScreenRight(this.struct);
    }

    public int getVirtualScreenBottom() {
        return GPU_DEVICE.virtualScreenBottom(this.struct);
    }

    private static native int offsets(long var0);

    public static ByteBuffer malloc() {
        return BufferUtils.createByteBuffer(SIZEOF);
    }

    public static ByteBuffer malloc(int cb, ByteBuffer DeviceName, ByteBuffer DeviceString, int Flags, ByteBuffer virtualScreen) {
        ByteBuffer gpu_device = GPU_DEVICE.malloc();
        GPU_DEVICE.cb(gpu_device, cb);
        GPU_DEVICE.DeviceNameSet(gpu_device, DeviceName);
        GPU_DEVICE.DeviceStringSet(gpu_device, DeviceString);
        GPU_DEVICE.Flags(gpu_device, Flags);
        GPU_DEVICE.virtualScreenSet(gpu_device, virtualScreen);
        return gpu_device;
    }

    public static ByteBuffer malloc(int cb, CharSequence DeviceName, CharSequence DeviceString, int Flags, ByteBuffer virtualScreen) {
        ByteBuffer gpu_device = GPU_DEVICE.malloc();
        GPU_DEVICE.cb(gpu_device, cb);
        GPU_DEVICE.DeviceName(gpu_device, DeviceName);
        GPU_DEVICE.DeviceString(gpu_device, DeviceString);
        GPU_DEVICE.Flags(gpu_device, Flags);
        GPU_DEVICE.virtualScreenSet(gpu_device, virtualScreen);
        return gpu_device;
    }

    public static void cb(ByteBuffer gpu_device, int cb) {
        gpu_device.putInt(gpu_device.position() + CB, cb);
    }

    public static void DeviceNameSet(ByteBuffer gpu_device, ByteBuffer DeviceName) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkNT2(DeviceName);
            Checks.checkBufferGT(DeviceName, 64);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(DeviceName), MemoryUtil.memAddress(gpu_device) + (long)DEVICENAME, DeviceName.remaining());
    }

    public static void DeviceName(ByteBuffer gpu_device, CharSequence DeviceName) {
        MemoryUtil.memEncodeUTF16(DeviceName, true, gpu_device, DEVICENAME);
    }

    public static void DeviceStringSet(ByteBuffer gpu_device, ByteBuffer DeviceString) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkNT2(DeviceString);
            Checks.checkBufferGT(DeviceString, 256);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(DeviceString), MemoryUtil.memAddress(gpu_device) + (long)DEVICESTRING, DeviceString.remaining());
    }

    public static void DeviceString(ByteBuffer gpu_device, CharSequence DeviceString) {
        MemoryUtil.memEncodeUTF16(DeviceString, true, gpu_device, DEVICESTRING);
    }

    public static void Flags(ByteBuffer gpu_device, int Flags) {
        gpu_device.putInt(gpu_device.position() + FLAGS, Flags);
    }

    public static void virtualScreenSet(ByteBuffer gpu_device, ByteBuffer virtualScreen) {
        if (virtualScreen != null) {
            MemoryUtil.memCopy(MemoryUtil.memAddress(virtualScreen), MemoryUtil.memAddress(gpu_device) + (long)VIRTUALSCREEN, RECT.SIZEOF);
        }
    }

    public static void virtualScreenLeft(ByteBuffer gpu_device, int left) {
        gpu_device.putInt(gpu_device.position() + VIRTUALSCREEN + RECT.LEFT, left);
    }

    public static void virtualScreenTop(ByteBuffer gpu_device, int top) {
        gpu_device.putInt(gpu_device.position() + VIRTUALSCREEN + RECT.TOP, top);
    }

    public static void virtualScreenRight(ByteBuffer gpu_device, int right) {
        gpu_device.putInt(gpu_device.position() + VIRTUALSCREEN + RECT.RIGHT, right);
    }

    public static void virtualScreenBottom(ByteBuffer gpu_device, int bottom) {
        gpu_device.putInt(gpu_device.position() + VIRTUALSCREEN + RECT.BOTTOM, bottom);
    }

    public static int cb(ByteBuffer gpu_device) {
        return gpu_device.getInt(gpu_device.position() + CB);
    }

    public static void DeviceNameGet(ByteBuffer gpu_device, ByteBuffer DeviceName) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBufferGT(DeviceName, 64);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(gpu_device) + (long)DEVICENAME, MemoryUtil.memAddress(DeviceName), DeviceName.remaining());
    }

    public static String DeviceNameString(ByteBuffer gpu_device) {
        return MemoryUtil.memDecodeUTF16(gpu_device, MemoryUtil.memStrLen2(gpu_device, DEVICENAME), DEVICENAME);
    }

    public static String DeviceNameString(ByteBuffer gpu_device, int byteLen) {
        return MemoryUtil.memDecodeUTF16(gpu_device, byteLen, DEVICENAME);
    }

    public static void DeviceStringGet(ByteBuffer gpu_device, ByteBuffer DeviceString) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBufferGT(DeviceString, 256);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(gpu_device) + (long)DEVICESTRING, MemoryUtil.memAddress(DeviceString), DeviceString.remaining());
    }

    public static String DeviceStringString(ByteBuffer gpu_device) {
        return MemoryUtil.memDecodeUTF16(gpu_device, MemoryUtil.memStrLen2(gpu_device, DEVICESTRING), DEVICESTRING);
    }

    public static String DeviceStringString(ByteBuffer gpu_device, int byteLen) {
        return MemoryUtil.memDecodeUTF16(gpu_device, byteLen, DEVICESTRING);
    }

    public static int Flags(ByteBuffer gpu_device) {
        return gpu_device.getInt(gpu_device.position() + FLAGS);
    }

    public static void virtualScreenGet(ByteBuffer gpu_device, ByteBuffer virtualScreen) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)virtualScreen, RECT.SIZEOF);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(gpu_device) + (long)VIRTUALSCREEN, MemoryUtil.memAddress(virtualScreen), RECT.SIZEOF);
    }

    public static int virtualScreenLeft(ByteBuffer gpu_device) {
        return gpu_device.getInt(gpu_device.position() + VIRTUALSCREEN + RECT.LEFT);
    }

    public static int virtualScreenTop(ByteBuffer gpu_device) {
        return gpu_device.getInt(gpu_device.position() + VIRTUALSCREEN + RECT.TOP);
    }

    public static int virtualScreenRight(ByteBuffer gpu_device) {
        return gpu_device.getInt(gpu_device.position() + VIRTUALSCREEN + RECT.RIGHT);
    }

    public static int virtualScreenBottom(ByteBuffer gpu_device) {
        return gpu_device.getInt(gpu_device.position() + VIRTUALSCREEN + RECT.BOTTOM);
    }

    static {
        IntBuffer offsets = BufferUtils.createIntBuffer(5);
        SIZEOF = GPU_DEVICE.offsets(MemoryUtil.memAddress(offsets));
        CB = offsets.get(0);
        DEVICENAME = offsets.get(1);
        DEVICESTRING = offsets.get(2);
        FLAGS = offsets.get(3);
        VIRTUALSCREEN = offsets.get(4);
    }
}

