/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.util.Set;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.opengl.GL;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.MemoryUtil;

public final class GLX11 {
    public static final int GLX_VENDOR = 1;
    public static final int GLX_VERSION = 2;
    public static final int GLX_EXTENSIONS = 3;
    public final long QueryExtensionsString;
    public final long GetClientString;
    public final long QueryServerString;

    public GLX11(FunctionProvider provider) {
        this.QueryExtensionsString = provider.getFunctionAddress("glXQueryExtensionsString");
        this.GetClientString = provider.getFunctionAddress("glXGetClientString");
        this.QueryServerString = provider.getFunctionAddress("glXQueryServerString");
    }

    public static GLX11 getInstance() {
        return GL.getCapabilities().__GLX11;
    }

    static GLX11 create(Set<String> ext, FunctionProvider provider) {
        if (!ext.contains("GLX_11")) {
            return null;
        }
        GLX11 funcs = new GLX11(provider);
        boolean supported = Checks.checkFunctions(funcs.QueryExtensionsString, funcs.GetClientString, funcs.QueryServerString);
        return GL.checkExtension("GLX_11", funcs, supported);
    }

    public static native long nglXQueryExtensionsString(long var0, int var2, long var3);

    public static long nglXQueryExtensionsString(long display, int screen) {
        long __functionAddress = GLX11.getInstance().QueryExtensionsString;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(display);
        }
        return GLX11.nglXQueryExtensionsString(display, screen, __functionAddress);
    }

    public static String glXQueryExtensionsString(long display, int screen) {
        long __result = GLX11.nglXQueryExtensionsString(display, screen);
        return MemoryUtil.memDecodeASCII(__result);
    }

    public static native long nglXGetClientString(long var0, int var2, long var3);

    public static long nglXGetClientString(long display, int name) {
        long __functionAddress = GLX11.getInstance().GetClientString;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(display);
        }
        return GLX11.nglXGetClientString(display, name, __functionAddress);
    }

    public static String glXGetClientString(long display, int name) {
        long __result = GLX11.nglXGetClientString(display, name);
        return MemoryUtil.memDecodeASCII(__result);
    }

    public static native long nglXQueryServerString(long var0, int var2, int var3, long var4);

    public static long nglXQueryServerString(long display, int screen, int name) {
        long __functionAddress = GLX11.getInstance().QueryServerString;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(display);
        }
        return GLX11.nglXQueryServerString(display, screen, name, __functionAddress);
    }

    public static String glXQueryServerString(long display, int screen, int name) {
        long __result = GLX11.nglXQueryServerString(display, screen, name);
        return MemoryUtil.memDecodeASCII(__result);
    }
}

