/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.linux.XVisualInfo;

public final class GLX {
    public static final int GLXBadContext = 0;
    public static final int GLXBadContextState = 1;
    public static final int GLXBadDrawable = 2;
    public static final int GLXBadPixmap = 3;
    public static final int GLXBadContextTag = 4;
    public static final int GLXBadCurrentWindow = 5;
    public static final int GLXBadRenderRequest = 6;
    public static final int GLXBadLargeRequest = 7;
    public static final int GLXUnsupportedPrivateRequest = 8;
    public static final int GLXBadFBConfig = 9;
    public static final int GLXBadPbuffer = 10;
    public static final int GLXBadCurrentDrawable = 11;
    public static final int GLXBadWindow = 12;
    public static final int GLX_USE_GL = 1;
    public static final int GLX_BUFFER_SIZE = 2;
    public static final int GLX_LEVEL = 3;
    public static final int GLX_RGBA = 4;
    public static final int GLX_DOUBLEBUFFER = 5;
    public static final int GLX_STEREO = 6;
    public static final int GLX_AUX_BUFFERS = 7;
    public static final int GLX_RED_SIZE = 8;
    public static final int GLX_GREEN_SIZE = 9;
    public static final int GLX_BLUE_SIZE = 10;
    public static final int GLX_ALPHA_SIZE = 11;
    public static final int GLX_DEPTH_SIZE = 12;
    public static final int GLX_STENCIL_SIZE = 13;
    public static final int GLX_ACCUM_RED_SIZE = 14;
    public static final int GLX_ACCUM_GREEN_SIZE = 15;
    public static final int GLX_ACCUM_BLUE_SIZE = 16;
    public static final int GLX_ACCUM_ALPHA_SIZE = 17;
    public static final int GLX_BAD_SCREEN = 1;
    public static final int GLX_BAD_ATTRIBUTE = 2;
    public static final int GLX_NO_EXTENSION = 3;
    public static final int GLX_BAD_VISUAL = 4;
    public static final int GLX_BAD_CONTEXT = 5;
    public static final int GLX_BAD_VALUE = 6;
    public static final int GLX_BAD_ENUM = 7;

    private GLX() {
    }

    public static native int nglXQueryExtension(long var0, long var2, long var4);

    public static int glXQueryExtension(long display, ByteBuffer error_base, ByteBuffer event_base) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(display);
            Checks.checkBuffer((Buffer)error_base, 4);
            Checks.checkBuffer((Buffer)event_base, 4);
        }
        return GLX.nglXQueryExtension(display, MemoryUtil.memAddress(error_base), MemoryUtil.memAddress(event_base));
    }

    public static int glXQueryExtension(long display, IntBuffer error_base, IntBuffer event_base) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(display);
            Checks.checkBuffer((Buffer)error_base, 1);
            Checks.checkBuffer((Buffer)event_base, 1);
        }
        return GLX.nglXQueryExtension(display, MemoryUtil.memAddress(error_base), MemoryUtil.memAddress(event_base));
    }

    public static native int nglXQueryVersion(long var0, long var2, long var4);

    public static int glXQueryVersion(long display, ByteBuffer major, ByteBuffer minor) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(display);
            Checks.checkBuffer((Buffer)major, 4);
            Checks.checkBuffer((Buffer)minor, 4);
        }
        return GLX.nglXQueryVersion(display, MemoryUtil.memAddress(major), MemoryUtil.memAddress(minor));
    }

    public static int glXQueryVersion(long display, IntBuffer major, IntBuffer minor) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(display);
            Checks.checkBuffer((Buffer)major, 1);
            Checks.checkBuffer((Buffer)minor, 1);
        }
        return GLX.nglXQueryVersion(display, MemoryUtil.memAddress(major), MemoryUtil.memAddress(minor));
    }

    public static native int nglXGetConfig(long var0, long var2, int var4, long var5);

    public static int glXGetConfig(long display, ByteBuffer visual, int attribute, ByteBuffer value) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(display);
            Checks.checkBuffer((Buffer)visual, XVisualInfo.SIZEOF);
            Checks.checkBuffer((Buffer)value, 4);
        }
        return GLX.nglXGetConfig(display, MemoryUtil.memAddress(visual), attribute, MemoryUtil.memAddress(value));
    }

    public static int glXGetConfig(long display, ByteBuffer visual, int attribute, IntBuffer value) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(display);
            Checks.checkBuffer((Buffer)visual, XVisualInfo.SIZEOF);
            Checks.checkBuffer((Buffer)value, 1);
        }
        return GLX.nglXGetConfig(display, MemoryUtil.memAddress(visual), attribute, MemoryUtil.memAddress(value));
    }

    public static native long nglXChooseVisual(long var0, int var2, long var3);

    public static ByteBuffer glXChooseVisual(long display, int screen, ByteBuffer attrib_list) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(display);
            if (attrib_list != null) {
                Checks.checkNT4(attrib_list);
            }
        }
        long __result = GLX.nglXChooseVisual(display, screen, MemoryUtil.memAddressSafe(attrib_list));
        return MemoryUtil.memByteBuffer(__result, XVisualInfo.SIZEOF);
    }

    public static ByteBuffer glXChooseVisual(long display, int screen, IntBuffer attrib_list) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(display);
            if (attrib_list != null) {
                Checks.checkNT(attrib_list);
            }
        }
        long __result = GLX.nglXChooseVisual(display, screen, MemoryUtil.memAddressSafe(attrib_list));
        return MemoryUtil.memByteBuffer(__result, XVisualInfo.SIZEOF);
    }

    public static native long nglXCreateContext(long var0, long var2, long var4, int var6);

    public static long glXCreateContext(long display, ByteBuffer visual, long share_list, int direct) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(display);
            Checks.checkBuffer((Buffer)visual, XVisualInfo.SIZEOF);
        }
        return GLX.nglXCreateContext(display, MemoryUtil.memAddress(visual), share_list, direct);
    }

    public static native int nglXMakeCurrent(long var0, long var2, long var4);

    public static int glXMakeCurrent(long display, long draw, long ctx) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(display);
        }
        return GLX.nglXMakeCurrent(display, draw, ctx);
    }

    public static native void nglXCopyContext(long var0, long var2, long var4, long var6);

    public static void glXCopyContext(long display, long source, long dest, long mask) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(display);
            Checks.checkPointer(source);
            Checks.checkPointer(dest);
        }
        GLX.nglXCopyContext(display, source, dest, mask);
    }

    public static native int nglXIsDirect(long var0, long var2);

    public static int glXIsDirect(long display, long ctx) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(display);
            Checks.checkPointer(ctx);
        }
        return GLX.nglXIsDirect(display, ctx);
    }

    public static native void nglXDestroyContext(long var0, long var2);

    public static void glXDestroyContext(long display, long ctx) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(display);
            Checks.checkPointer(ctx);
        }
        GLX.nglXDestroyContext(display, ctx);
    }

    public static native long glXGetCurrentContext();

    public static native long glXGetCurrentDrawable();

    public static native void glXWaitGL();

    public static native void glXWaitX();

    public static native void nglXSwapBuffers(long var0, long var2);

    public static void glXSwapBuffers(long display, long draw) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(display);
            Checks.checkPointer(draw);
        }
        GLX.nglXSwapBuffers(display, draw);
    }

    public static native void glXUseXFont(long var0, int var2, int var3, int var4);

    public static native long nglXCreateGLXPixmap(long var0, long var2, long var4);

    public static long glXCreateGLXPixmap(long display, ByteBuffer visual, long pixmap) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(display);
            Checks.checkBuffer((Buffer)visual, XVisualInfo.SIZEOF);
        }
        return GLX.nglXCreateGLXPixmap(display, MemoryUtil.memAddress(visual), pixmap);
    }

    public static native void nglXDestroyGLXPixmap(long var0, long var2);

    public static void glXDestroyGLXPixmap(long display, long pixmap) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(display);
            Checks.checkPointer(pixmap);
        }
        GLX.nglXDestroyGLXPixmap(display, pixmap);
    }

    static {
        LWJGLUtil.initialize();
    }
}

