/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import org.lwjgl.LWJGLUtil;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.OpenGLException;

final class GLChecks {
    private GLChecks() {
    }

    static void ensureBufferObject(int binding, boolean enabled) {
        if (LWJGLUtil.DEBUG && GL11.glGetInteger(binding) != 0 ^ enabled) {
            throw new OpenGLException("Cannot use %s when %s buffer object is %s", enabled ? "offsets" : "buffers", GLChecks.translateBufferObjectBinding(binding), enabled ? "disabled" : "enabled");
        }
    }

    private static String translateBufferObjectBinding(int binding) {
        switch (binding) {
            case 34964: {
                return "array";
            }
            case 34965: {
                return "element array";
            }
            case 35053: {
                return "pixel pack";
            }
            case 35055: {
                return "pixel unpack";
            }
            case 36675: {
                return "draw indirect";
            }
            case 37103: {
                return "dispatch indirect";
            }
        }
        throw new IllegalArgumentException(String.format("Unsupported buffer binding: 0x%X", binding));
    }

    static int typeToBytes(int type) {
        switch (type) {
            case 5120: 
            case 5121: {
                return 1;
            }
            case 5122: 
            case 5123: 
            case 5127: 
            case 5131: {
                return 2;
            }
            case 5128: {
                return 3;
            }
            case 5124: 
            case 5125: 
            case 5126: 
            case 5129: {
                return 4;
            }
            case 5130: {
                return 8;
            }
        }
        throw new IllegalArgumentException(String.format("Unsupported OpenGL type: 0x%X", type));
    }

    static int typeToByteShift(int type) {
        switch (type) {
            case 5120: 
            case 5121: {
                return 0;
            }
            case 5122: 
            case 5123: 
            case 5127: 
            case 5131: {
                return 1;
            }
            case 5124: 
            case 5125: 
            case 5126: 
            case 5129: {
                return 2;
            }
            case 5130: {
                return 3;
            }
        }
        throw new IllegalArgumentException(String.format("Unsupported OpenGL type: 0x%X", type));
    }
}

