/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.util.Set;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.Pointer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GLChecks;
import org.lwjgl.system.APIBuffer;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.MemoryUtil;

public final class GL45 {
    public static final int GL_LOWER_LEFT = 36001;
    public static final int GL_UPPER_LEFT = 36002;
    public static final int GL_NEGATIVE_ONE_TO_ONE = 37726;
    public static final int GL_ZERO_TO_ONE = 37727;
    public static final int GL_CLIP_ORIGIN = 37724;
    public static final int GL_CLIP_DEPTH_MODE = 37725;
    public static final int GL_QUERY_WAIT_INVERTED = 36375;
    public static final int GL_QUERY_NO_WAIT_INVERTED = 36376;
    public static final int GL_QUERY_BY_REGION_WAIT_INVERTED = 36377;
    public static final int GL_QUERY_BY_REGION_NO_WAIT_INVERTED = 36378;
    public static final int GL_MAX_CULL_DISTANCES = 33529;
    public static final int GL_MAX_COMBINED_CLIP_AND_CULL_DISTANCES = 33530;
    public static final int GL_TEXTURE_TARGET = 4102;
    public static final int GL_QUERY_TARGET = 33514;
    public static final int GL_TEXTURE_BINDING = 33515;
    public static final int GL_CONTEXT_RELEASE_BEHAVIOR = 33531;
    public static final int GL_CONTEXT_RELEASE_BEHAVIOR_FLUSH = 33532;
    public static final int GL_NO_ERROR = 0;
    public static final int GL_GUILTY_CONTEXT_RESET = 33363;
    public static final int GL_INNOCENT_CONTEXT_RESET = 33364;
    public static final int GL_UNKNOWN_CONTEXT_RESET = 33365;
    public static final int GL_CONTEXT_ROBUST_ACCESS = 37107;
    public static final int GL_RESET_NOTIFICATION_STRATEGY = 33366;
    public static final int GL_LOSE_CONTEXT_ON_RESET = 33362;
    public static final int GL_NO_RESET_NOTIFICATION = 33377;
    public static final int GL_CONTEXT_LOST = 1287;
    public final long ClipControl;
    public final long CreateTransformFeedbacks;
    public final long TransformFeedbackBufferBase;
    public final long TransformFeedbackBufferRange;
    public final long GetTransformFeedbackiv;
    public final long GetTransformFeedbacki_v;
    public final long GetTransformFeedbacki64_v;
    public final long CreateBuffers;
    public final long NamedBufferStorage;
    public final long NamedBufferData;
    public final long NamedBufferSubData;
    public final long CopyNamedBufferSubData;
    public final long ClearNamedBufferData;
    public final long ClearNamedBufferSubData;
    public final long MapNamedBuffer;
    public final long MapNamedBufferRange;
    public final long UnmapNamedBuffer;
    public final long FlushMappedNamedBufferRange;
    public final long GetNamedBufferParameteriv;
    public final long GetNamedBufferParameteri64v;
    public final long GetNamedBufferPointerv;
    public final long GetNamedBufferSubData;
    public final long CreateFramebuffers;
    public final long NamedFramebufferRenderbuffer;
    public final long NamedFramebufferParameteri;
    public final long NamedFramebufferTexture;
    public final long NamedFramebufferTextureLayer;
    public final long NamedFramebufferDrawBuffer;
    public final long NamedFramebufferDrawBuffers;
    public final long NamedFramebufferReadBuffer;
    public final long InvalidateNamedFramebufferData;
    public final long InvalidateNamedFramebufferSubData;
    public final long ClearNamedFramebufferiv;
    public final long ClearNamedFramebufferuiv;
    public final long ClearNamedFramebufferfv;
    public final long ClearNamedFramebufferfi;
    public final long BlitNamedFramebuffer;
    public final long CheckNamedFramebufferStatus;
    public final long GetNamedFramebufferParameteriv;
    public final long GetNamedFramebufferAttachmentParameteriv;
    public final long CreateRenderbuffers;
    public final long NamedRenderbufferStorage;
    public final long NamedRenderbufferStorageMultisample;
    public final long GetNamedRenderbufferParameteriv;
    public final long CreateTextures;
    public final long TextureBuffer;
    public final long TextureBufferRange;
    public final long TextureStorage1D;
    public final long TextureStorage2D;
    public final long TextureStorage3D;
    public final long TextureStorage2DMultisample;
    public final long TextureStorage3DMultisample;
    public final long TextureSubImage1D;
    public final long TextureSubImage2D;
    public final long TextureSubImage3D;
    public final long CompressedTextureSubImage1D;
    public final long CompressedTextureSubImage2D;
    public final long CompressedTextureSubImage3D;
    public final long CopyTextureSubImage1D;
    public final long CopyTextureSubImage2D;
    public final long CopyTextureSubImage3D;
    public final long TextureParameterf;
    public final long TextureParameterfv;
    public final long TextureParameteri;
    public final long TextureParameterIiv;
    public final long TextureParameterIuiv;
    public final long TextureParameteriv;
    public final long GenerateTextureMipmap;
    public final long BindTextureUnit;
    public final long GetTextureImage;
    public final long GetCompressedTextureImage;
    public final long GetTextureLevelParameterfv;
    public final long GetTextureLevelParameteriv;
    public final long GetTextureParameterfv;
    public final long GetTextureParameterIiv;
    public final long GetTextureParameterIuiv;
    public final long GetTextureParameteriv;
    public final long CreateVertexArrays;
    public final long DisableVertexArrayAttrib;
    public final long EnableVertexArrayAttrib;
    public final long VertexArrayElementBuffer;
    public final long VertexArrayVertexBuffer;
    public final long VertexArrayVertexBuffers;
    public final long VertexArrayAttribFormat;
    public final long VertexArrayAttribIFormat;
    public final long VertexArrayAttribLFormat;
    public final long VertexArrayAttribBinding;
    public final long VertexArrayBindingDivisor;
    public final long GetVertexArrayiv;
    public final long GetVertexArrayIndexediv;
    public final long GetVertexArrayIndexed64iv;
    public final long CreateSamplers;
    public final long CreateProgramPipelines;
    public final long CreateQueries;
    public final long MemoryBarrierByRegion;
    public final long GetTextureSubImage;
    public final long GetCompressedTextureSubImage;
    public final long TextureBarrier;
    public final long GetGraphicsResetStatus;
    public final long ReadnPixels;
    public final long GetnUniformfv;
    public final long GetnUniformiv;
    public final long GetnUniformuiv;

    public GL45(FunctionProvider provider) {
        this.ClipControl = provider.getFunctionAddress("glClipControl");
        this.CreateTransformFeedbacks = provider.getFunctionAddress("glCreateTransformFeedbacks");
        this.TransformFeedbackBufferBase = provider.getFunctionAddress("glTransformFeedbackBufferBase");
        this.TransformFeedbackBufferRange = provider.getFunctionAddress("glTransformFeedbackBufferRange");
        this.GetTransformFeedbackiv = provider.getFunctionAddress("glGetTransformFeedbackiv");
        this.GetTransformFeedbacki_v = provider.getFunctionAddress("glGetTransformFeedbacki_v");
        this.GetTransformFeedbacki64_v = provider.getFunctionAddress("glGetTransformFeedbacki64_v");
        this.CreateBuffers = provider.getFunctionAddress("glCreateBuffers");
        this.NamedBufferStorage = provider.getFunctionAddress("glNamedBufferStorage");
        this.NamedBufferData = provider.getFunctionAddress("glNamedBufferData");
        this.NamedBufferSubData = provider.getFunctionAddress("glNamedBufferSubData");
        this.CopyNamedBufferSubData = provider.getFunctionAddress("glCopyNamedBufferSubData");
        this.ClearNamedBufferData = provider.getFunctionAddress("glClearNamedBufferData");
        this.ClearNamedBufferSubData = provider.getFunctionAddress("glClearNamedBufferSubData");
        this.MapNamedBuffer = provider.getFunctionAddress("glMapNamedBuffer");
        this.MapNamedBufferRange = provider.getFunctionAddress("glMapNamedBufferRange");
        this.UnmapNamedBuffer = provider.getFunctionAddress("glUnmapNamedBuffer");
        this.FlushMappedNamedBufferRange = provider.getFunctionAddress("glFlushMappedNamedBufferRange");
        this.GetNamedBufferParameteriv = provider.getFunctionAddress("glGetNamedBufferParameteriv");
        this.GetNamedBufferParameteri64v = provider.getFunctionAddress("glGetNamedBufferParameteri64v");
        this.GetNamedBufferPointerv = provider.getFunctionAddress("glGetNamedBufferPointerv");
        this.GetNamedBufferSubData = provider.getFunctionAddress("glGetNamedBufferSubData");
        this.CreateFramebuffers = provider.getFunctionAddress("glCreateFramebuffers");
        this.NamedFramebufferRenderbuffer = provider.getFunctionAddress("glNamedFramebufferRenderbuffer");
        this.NamedFramebufferParameteri = provider.getFunctionAddress("glNamedFramebufferParameteri");
        this.NamedFramebufferTexture = provider.getFunctionAddress("glNamedFramebufferTexture");
        this.NamedFramebufferTextureLayer = provider.getFunctionAddress("glNamedFramebufferTextureLayer");
        this.NamedFramebufferDrawBuffer = provider.getFunctionAddress("glNamedFramebufferDrawBuffer");
        this.NamedFramebufferDrawBuffers = provider.getFunctionAddress("glNamedFramebufferDrawBuffers");
        this.NamedFramebufferReadBuffer = provider.getFunctionAddress("glNamedFramebufferReadBuffer");
        this.InvalidateNamedFramebufferData = provider.getFunctionAddress("glInvalidateNamedFramebufferData");
        this.InvalidateNamedFramebufferSubData = provider.getFunctionAddress("glInvalidateNamedFramebufferSubData");
        this.ClearNamedFramebufferiv = provider.getFunctionAddress("glClearNamedFramebufferiv");
        this.ClearNamedFramebufferuiv = provider.getFunctionAddress("glClearNamedFramebufferuiv");
        this.ClearNamedFramebufferfv = provider.getFunctionAddress("glClearNamedFramebufferfv");
        this.ClearNamedFramebufferfi = provider.getFunctionAddress("glClearNamedFramebufferfi");
        this.BlitNamedFramebuffer = provider.getFunctionAddress("glBlitNamedFramebuffer");
        this.CheckNamedFramebufferStatus = provider.getFunctionAddress("glCheckNamedFramebufferStatus");
        this.GetNamedFramebufferParameteriv = provider.getFunctionAddress("glGetNamedFramebufferParameteriv");
        this.GetNamedFramebufferAttachmentParameteriv = provider.getFunctionAddress("glGetNamedFramebufferAttachmentParameteriv");
        this.CreateRenderbuffers = provider.getFunctionAddress("glCreateRenderbuffers");
        this.NamedRenderbufferStorage = provider.getFunctionAddress("glNamedRenderbufferStorage");
        this.NamedRenderbufferStorageMultisample = provider.getFunctionAddress("glNamedRenderbufferStorageMultisample");
        this.GetNamedRenderbufferParameteriv = provider.getFunctionAddress("glGetNamedRenderbufferParameteriv");
        this.CreateTextures = provider.getFunctionAddress("glCreateTextures");
        this.TextureBuffer = provider.getFunctionAddress("glTextureBuffer");
        this.TextureBufferRange = provider.getFunctionAddress("glTextureBufferRange");
        this.TextureStorage1D = provider.getFunctionAddress("glTextureStorage1D");
        this.TextureStorage2D = provider.getFunctionAddress("glTextureStorage2D");
        this.TextureStorage3D = provider.getFunctionAddress("glTextureStorage3D");
        this.TextureStorage2DMultisample = provider.getFunctionAddress("glTextureStorage2DMultisample");
        this.TextureStorage3DMultisample = provider.getFunctionAddress("glTextureStorage3DMultisample");
        this.TextureSubImage1D = provider.getFunctionAddress("glTextureSubImage1D");
        this.TextureSubImage2D = provider.getFunctionAddress("glTextureSubImage2D");
        this.TextureSubImage3D = provider.getFunctionAddress("glTextureSubImage3D");
        this.CompressedTextureSubImage1D = provider.getFunctionAddress("glCompressedTextureSubImage1D");
        this.CompressedTextureSubImage2D = provider.getFunctionAddress("glCompressedTextureSubImage2D");
        this.CompressedTextureSubImage3D = provider.getFunctionAddress("glCompressedTextureSubImage3D");
        this.CopyTextureSubImage1D = provider.getFunctionAddress("glCopyTextureSubImage1D");
        this.CopyTextureSubImage2D = provider.getFunctionAddress("glCopyTextureSubImage2D");
        this.CopyTextureSubImage3D = provider.getFunctionAddress("glCopyTextureSubImage3D");
        this.TextureParameterf = provider.getFunctionAddress("glTextureParameterf");
        this.TextureParameterfv = provider.getFunctionAddress("glTextureParameterfv");
        this.TextureParameteri = provider.getFunctionAddress("glTextureParameteri");
        this.TextureParameterIiv = provider.getFunctionAddress("glTextureParameterIiv");
        this.TextureParameterIuiv = provider.getFunctionAddress("glTextureParameterIuiv");
        this.TextureParameteriv = provider.getFunctionAddress("glTextureParameteriv");
        this.GenerateTextureMipmap = provider.getFunctionAddress("glGenerateTextureMipmap");
        this.BindTextureUnit = provider.getFunctionAddress("glBindTextureUnit");
        this.GetTextureImage = provider.getFunctionAddress("glGetTextureImage");
        this.GetCompressedTextureImage = provider.getFunctionAddress("glGetCompressedTextureImage");
        this.GetTextureLevelParameterfv = provider.getFunctionAddress("glGetTextureLevelParameterfv");
        this.GetTextureLevelParameteriv = provider.getFunctionAddress("glGetTextureLevelParameteriv");
        this.GetTextureParameterfv = provider.getFunctionAddress("glGetTextureParameterfv");
        this.GetTextureParameterIiv = provider.getFunctionAddress("glGetTextureParameterIiv");
        this.GetTextureParameterIuiv = provider.getFunctionAddress("glGetTextureParameterIuiv");
        this.GetTextureParameteriv = provider.getFunctionAddress("glGetTextureParameteriv");
        this.CreateVertexArrays = provider.getFunctionAddress("glCreateVertexArrays");
        this.DisableVertexArrayAttrib = provider.getFunctionAddress("glDisableVertexArrayAttrib");
        this.EnableVertexArrayAttrib = provider.getFunctionAddress("glEnableVertexArrayAttrib");
        this.VertexArrayElementBuffer = provider.getFunctionAddress("glVertexArrayElementBuffer");
        this.VertexArrayVertexBuffer = provider.getFunctionAddress("glVertexArrayVertexBuffer");
        this.VertexArrayVertexBuffers = provider.getFunctionAddress("glVertexArrayVertexBuffers");
        this.VertexArrayAttribFormat = provider.getFunctionAddress("glVertexArrayAttribFormat");
        this.VertexArrayAttribIFormat = provider.getFunctionAddress("glVertexArrayAttribIFormat");
        this.VertexArrayAttribLFormat = provider.getFunctionAddress("glVertexArrayAttribLFormat");
        this.VertexArrayAttribBinding = provider.getFunctionAddress("glVertexArrayAttribBinding");
        this.VertexArrayBindingDivisor = provider.getFunctionAddress("glVertexArrayBindingDivisor");
        this.GetVertexArrayiv = provider.getFunctionAddress("glGetVertexArrayiv");
        this.GetVertexArrayIndexediv = provider.getFunctionAddress("glGetVertexArrayIndexediv");
        this.GetVertexArrayIndexed64iv = provider.getFunctionAddress("glGetVertexArrayIndexed64iv");
        this.CreateSamplers = provider.getFunctionAddress("glCreateSamplers");
        this.CreateProgramPipelines = provider.getFunctionAddress("glCreateProgramPipelines");
        this.CreateQueries = provider.getFunctionAddress("glCreateQueries");
        this.MemoryBarrierByRegion = provider.getFunctionAddress("glMemoryBarrierByRegion");
        this.GetTextureSubImage = provider.getFunctionAddress("glGetTextureSubImage");
        this.GetCompressedTextureSubImage = provider.getFunctionAddress("glGetCompressedTextureSubImage");
        this.TextureBarrier = provider.getFunctionAddress("glTextureBarrier");
        this.GetGraphicsResetStatus = provider.getFunctionAddress("glGetGraphicsResetStatus");
        this.ReadnPixels = provider.getFunctionAddress("glReadnPixels");
        this.GetnUniformfv = provider.getFunctionAddress("glGetnUniformfv");
        this.GetnUniformiv = provider.getFunctionAddress("glGetnUniformiv");
        this.GetnUniformuiv = provider.getFunctionAddress("glGetnUniformuiv");
    }

    public static GL45 getInstance() {
        return GL.getCapabilities().__GL45;
    }

    static GL45 create(Set<String> ext, FunctionProvider provider) {
        if (!ext.contains("OpenGL45")) {
            return null;
        }
        GL45 funcs = new GL45(provider);
        boolean supported = Checks.checkFunctions(funcs.ClipControl, funcs.CreateTransformFeedbacks, funcs.TransformFeedbackBufferBase, funcs.TransformFeedbackBufferRange, funcs.GetTransformFeedbackiv, funcs.GetTransformFeedbacki_v, funcs.GetTransformFeedbacki64_v, funcs.CreateBuffers, funcs.NamedBufferStorage, funcs.NamedBufferData, funcs.NamedBufferSubData, funcs.CopyNamedBufferSubData, funcs.ClearNamedBufferData, funcs.ClearNamedBufferSubData, funcs.MapNamedBuffer, funcs.MapNamedBufferRange, funcs.UnmapNamedBuffer, funcs.FlushMappedNamedBufferRange, funcs.GetNamedBufferParameteriv, funcs.GetNamedBufferParameteri64v, funcs.GetNamedBufferPointerv, funcs.GetNamedBufferSubData, funcs.CreateFramebuffers, funcs.NamedFramebufferRenderbuffer, funcs.NamedFramebufferParameteri, funcs.NamedFramebufferTexture, funcs.NamedFramebufferTextureLayer, funcs.NamedFramebufferDrawBuffer, funcs.NamedFramebufferDrawBuffers, funcs.NamedFramebufferReadBuffer, funcs.InvalidateNamedFramebufferData, funcs.InvalidateNamedFramebufferSubData, funcs.ClearNamedFramebufferiv, funcs.ClearNamedFramebufferuiv, funcs.ClearNamedFramebufferfv, funcs.ClearNamedFramebufferfi, funcs.BlitNamedFramebuffer, funcs.CheckNamedFramebufferStatus, funcs.GetNamedFramebufferParameteriv, funcs.GetNamedFramebufferAttachmentParameteriv, funcs.CreateRenderbuffers, funcs.NamedRenderbufferStorage, funcs.NamedRenderbufferStorageMultisample, funcs.GetNamedRenderbufferParameteriv, funcs.CreateTextures, funcs.TextureBuffer, funcs.TextureBufferRange, funcs.TextureStorage1D, funcs.TextureStorage2D, funcs.TextureStorage3D, funcs.TextureStorage2DMultisample, funcs.TextureStorage3DMultisample, funcs.TextureSubImage1D, funcs.TextureSubImage2D, funcs.TextureSubImage3D, funcs.CompressedTextureSubImage1D, funcs.CompressedTextureSubImage2D, funcs.CompressedTextureSubImage3D, funcs.CopyTextureSubImage1D, funcs.CopyTextureSubImage2D, funcs.CopyTextureSubImage3D, funcs.TextureParameterf, funcs.TextureParameterfv, funcs.TextureParameteri, funcs.TextureParameterIiv, funcs.TextureParameterIuiv, funcs.TextureParameteriv, funcs.GenerateTextureMipmap, funcs.BindTextureUnit, funcs.GetTextureImage, funcs.GetCompressedTextureImage, funcs.GetTextureLevelParameterfv, funcs.GetTextureLevelParameteriv, funcs.GetTextureParameterfv, funcs.GetTextureParameterIiv, funcs.GetTextureParameterIuiv, funcs.GetTextureParameteriv, funcs.CreateVertexArrays, funcs.DisableVertexArrayAttrib, funcs.EnableVertexArrayAttrib, funcs.VertexArrayElementBuffer, funcs.VertexArrayVertexBuffer, funcs.VertexArrayVertexBuffers, funcs.VertexArrayAttribFormat, funcs.VertexArrayAttribIFormat, funcs.VertexArrayAttribLFormat, funcs.VertexArrayAttribBinding, funcs.VertexArrayBindingDivisor, funcs.GetVertexArrayiv, funcs.GetVertexArrayIndexediv, funcs.GetVertexArrayIndexed64iv, funcs.CreateSamplers, funcs.CreateProgramPipelines, funcs.CreateQueries, funcs.MemoryBarrierByRegion, funcs.GetTextureSubImage, funcs.GetCompressedTextureSubImage, funcs.TextureBarrier, funcs.GetGraphicsResetStatus, funcs.ReadnPixels, funcs.GetnUniformfv, funcs.GetnUniformiv, funcs.GetnUniformuiv);
        return GL.checkExtension("OpenGL45", funcs, supported);
    }

    public static native void nglClipControl(int var0, int var1, long var2);

    public static void glClipControl(int origin, int depth) {
        long __functionAddress = GL45.getInstance().ClipControl;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL45.nglClipControl(origin, depth, __functionAddress);
    }

    public static native void nglCreateTransformFeedbacks(int var0, long var1, long var3);

    public static void nglCreateTransformFeedbacks(int n, long ids) {
        long __functionAddress = GL45.getInstance().CreateTransformFeedbacks;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL45.nglCreateTransformFeedbacks(n, ids, __functionAddress);
    }

    public static void glCreateTransformFeedbacks(int n, ByteBuffer ids) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)ids, n << 2);
        }
        GL45.nglCreateTransformFeedbacks(n, MemoryUtil.memAddress(ids));
    }

    public static void glCreateTransformFeedbacks(IntBuffer ids) {
        GL45.nglCreateTransformFeedbacks(ids.remaining(), MemoryUtil.memAddress(ids));
    }

    public static int glCreateTransformFeedbacks() {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int ids = __buffer.intParam();
        GL45.nglCreateTransformFeedbacks(1, __buffer.address(ids));
        return __buffer.intValue(ids);
    }

    public static native void nglTransformFeedbackBufferBase(int var0, int var1, int var2, long var3);

    public static void glTransformFeedbackBufferBase(int xfb, int index, int buffer) {
        long __functionAddress = GL45.getInstance().TransformFeedbackBufferBase;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL45.nglTransformFeedbackBufferBase(xfb, index, buffer, __functionAddress);
    }

    public static native void nglTransformFeedbackBufferRange(int var0, int var1, int var2, long var3, long var5, long var7);

    public static void glTransformFeedbackBufferRange(int xfb, int index, int buffer, long offset, long size) {
        long __functionAddress = GL45.getInstance().TransformFeedbackBufferRange;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL45.nglTransformFeedbackBufferRange(xfb, index, buffer, offset, size, __functionAddress);
    }

    public static native void nglGetTransformFeedbackiv(int var0, int var1, long var2, long var4);

    public static void nglGetTransformFeedbackiv(int xfb, int pname, long param) {
        long __functionAddress = GL45.getInstance().GetTransformFeedbackiv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL45.nglGetTransformFeedbackiv(xfb, pname, param, __functionAddress);
    }

    public static void glGetTransformFeedbackiv(int xfb, int pname, ByteBuffer param) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)param, 4);
        }
        GL45.nglGetTransformFeedbackiv(xfb, pname, MemoryUtil.memAddress(param));
    }

    public static void glGetTransformFeedbackiv(int xfb, int pname, IntBuffer param) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)param, 1);
        }
        GL45.nglGetTransformFeedbackiv(xfb, pname, MemoryUtil.memAddress(param));
    }

    public static int glGetTransformFeedbacki(int xfb, int pname) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int param = __buffer.intParam();
        GL45.nglGetTransformFeedbackiv(xfb, pname, __buffer.address(param));
        return __buffer.intValue(param);
    }

    public static native void nglGetTransformFeedbacki_v(int var0, int var1, int var2, long var3, long var5);

    public static void nglGetTransformFeedbacki_v(int xfb, int pname, int index, long param) {
        long __functionAddress = GL45.getInstance().GetTransformFeedbacki_v;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL45.nglGetTransformFeedbacki_v(xfb, pname, index, param, __functionAddress);
    }

    public static void glGetTransformFeedbacki_v(int xfb, int pname, int index, ByteBuffer param) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)param, 4);
        }
        GL45.nglGetTransformFeedbacki_v(xfb, pname, index, MemoryUtil.memAddress(param));
    }

    public static void glGetTransformFeedbacki_v(int xfb, int pname, int index, IntBuffer param) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)param, 1);
        }
        GL45.nglGetTransformFeedbacki_v(xfb, pname, index, MemoryUtil.memAddress(param));
    }

    public static int glGetTransformFeedbacki(int xfb, int pname, int index) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int param = __buffer.intParam();
        GL45.nglGetTransformFeedbacki_v(xfb, pname, index, __buffer.address(param));
        return __buffer.intValue(param);
    }

    public static native void nglGetTransformFeedbacki64_v(int var0, int var1, int var2, long var3, long var5);

    public static void nglGetTransformFeedbacki64_v(int xfb, int pname, int index, long param) {
        long __functionAddress = GL45.getInstance().GetTransformFeedbacki64_v;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL45.nglGetTransformFeedbacki64_v(xfb, pname, index, param, __functionAddress);
    }

    public static void glGetTransformFeedbacki64_v(int xfb, int pname, int index, ByteBuffer param) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)param, 8);
        }
        GL45.nglGetTransformFeedbacki64_v(xfb, pname, index, MemoryUtil.memAddress(param));
    }

    public static void glGetTransformFeedbacki64_v(int xfb, int pname, int index, LongBuffer param) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)param, 1);
        }
        GL45.nglGetTransformFeedbacki64_v(xfb, pname, index, MemoryUtil.memAddress(param));
    }

    public static long glGetTransformFeedbacki64(int xfb, int pname, int index) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int param = __buffer.longParam();
        GL45.nglGetTransformFeedbacki64_v(xfb, pname, index, __buffer.address(param));
        return __buffer.longValue(param);
    }

    public static native void nglCreateBuffers(int var0, long var1, long var3);

    public static void nglCreateBuffers(int n, long buffers) {
        long __functionAddress = GL45.getInstance().CreateBuffers;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL45.nglCreateBuffers(n, buffers, __functionAddress);
    }

    public static void glCreateBuffers(int n, ByteBuffer buffers) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)buffers, n << 2);
        }
        GL45.nglCreateBuffers(n, MemoryUtil.memAddress(buffers));
    }

    public static void glCreateBuffers(IntBuffer buffers) {
        GL45.nglCreateBuffers(buffers.remaining(), MemoryUtil.memAddress(buffers));
    }

    public static int glCreateBuffers() {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int buffers = __buffer.intParam();
        GL45.nglCreateBuffers(1, __buffer.address(buffers));
        return __buffer.intValue(buffers);
    }

    public static native void nglNamedBufferStorage(int var0, long var1, long var3, int var5, long var6);

    public static void nglNamedBufferStorage(int buffer, long size, long data, int flags) {
        long __functionAddress = GL45.getInstance().NamedBufferStorage;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL45.nglNamedBufferStorage(buffer, size, data, flags, __functionAddress);
    }

    public static void glNamedBufferStorage(int buffer, long size, ByteBuffer data, int flags) {
        if (LWJGLUtil.CHECKS && data != null) {
            Checks.checkBuffer((Buffer)data, size);
        }
        GL45.nglNamedBufferStorage(buffer, size, MemoryUtil.memAddressSafe(data), flags);
    }

    public static void glNamedBufferStorage(int buffer, long size, int flags) {
        GL45.nglNamedBufferStorage(buffer, size, 0L, flags);
    }

    public static void glNamedBufferStorage(int buffer, ByteBuffer data, int flags) {
        GL45.nglNamedBufferStorage(buffer, data.remaining(), MemoryUtil.memAddress(data), flags);
    }

    public static void glNamedBufferStorage(int buffer, ShortBuffer data, int flags) {
        GL45.nglNamedBufferStorage(buffer, data.remaining() << 1, MemoryUtil.memAddress(data), flags);
    }

    public static void glNamedBufferStorage(int buffer, IntBuffer data, int flags) {
        GL45.nglNamedBufferStorage(buffer, data.remaining() << 2, MemoryUtil.memAddress(data), flags);
    }

    public static void glNamedBufferStorage(int buffer, FloatBuffer data, int flags) {
        GL45.nglNamedBufferStorage(buffer, data.remaining() << 2, MemoryUtil.memAddress(data), flags);
    }

    public static void glNamedBufferStorage(int buffer, DoubleBuffer data, int flags) {
        GL45.nglNamedBufferStorage(buffer, data.remaining() << 3, MemoryUtil.memAddress(data), flags);
    }

    public static native void nglNamedBufferData(int var0, long var1, long var3, int var5, long var6);

    public static void nglNamedBufferData(int buffer, long size, long data, int usage) {
        long __functionAddress = GL45.getInstance().NamedBufferData;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL45.nglNamedBufferData(buffer, size, data, usage, __functionAddress);
    }

    public static void glNamedBufferData(int buffer, long size, ByteBuffer data, int usage) {
        if (LWJGLUtil.CHECKS && data != null) {
            Checks.checkBuffer((Buffer)data, size);
        }
        GL45.nglNamedBufferData(buffer, size, MemoryUtil.memAddressSafe(data), usage);
    }

    public static void glNamedBufferData(int buffer, long size, int usage) {
        GL45.nglNamedBufferData(buffer, size, 0L, usage);
    }

    public static void glNamedBufferData(int buffer, ByteBuffer data, int usage) {
        GL45.nglNamedBufferData(buffer, data.remaining(), MemoryUtil.memAddress(data), usage);
    }

    public static void glNamedBufferData(int buffer, ShortBuffer data, int usage) {
        GL45.nglNamedBufferData(buffer, data.remaining() << 1, MemoryUtil.memAddress(data), usage);
    }

    public static void glNamedBufferData(int buffer, IntBuffer data, int usage) {
        GL45.nglNamedBufferData(buffer, data.remaining() << 2, MemoryUtil.memAddress(data), usage);
    }

    public static void glNamedBufferData(int buffer, FloatBuffer data, int usage) {
        GL45.nglNamedBufferData(buffer, data.remaining() << 2, MemoryUtil.memAddress(data), usage);
    }

    public static void glNamedBufferData(int buffer, DoubleBuffer data, int usage) {
        GL45.nglNamedBufferData(buffer, data.remaining() << 3, MemoryUtil.memAddress(data), usage);
    }

    public static native void nglNamedBufferSubData(int var0, long var1, long var3, long var5, long var7);

    public static void nglNamedBufferSubData(int buffer, long offset, long size, long data) {
        long __functionAddress = GL45.getInstance().NamedBufferSubData;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL45.nglNamedBufferSubData(buffer, offset, size, data, __functionAddress);
    }

    public static void glNamedBufferSubData(int buffer, long offset, long size, ByteBuffer data) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)data, size);
        }
        GL45.nglNamedBufferSubData(buffer, offset, size, MemoryUtil.memAddress(data));
    }

    public static void glNamedBufferSubData(int buffer, long offset, ByteBuffer data) {
        GL45.nglNamedBufferSubData(buffer, offset, data.remaining(), MemoryUtil.memAddress(data));
    }

    public static void glNamedBufferSubData(int buffer, long offset, ShortBuffer data) {
        GL45.nglNamedBufferSubData(buffer, offset, data.remaining() << 1, MemoryUtil.memAddress(data));
    }

    public static void glNamedBufferSubData(int buffer, long offset, IntBuffer data) {
        GL45.nglNamedBufferSubData(buffer, offset, data.remaining() << 2, MemoryUtil.memAddress(data));
    }

    public static void glNamedBufferSubData(int buffer, long offset, FloatBuffer data) {
        GL45.nglNamedBufferSubData(buffer, offset, data.remaining() << 2, MemoryUtil.memAddress(data));
    }

    public static void glNamedBufferSubData(int buffer, long offset, DoubleBuffer data) {
        GL45.nglNamedBufferSubData(buffer, offset, data.remaining() << 3, MemoryUtil.memAddress(data));
    }

    public static native void nglCopyNamedBufferSubData(int var0, int var1, long var2, long var4, long var6, long var8);

    public static void glCopyNamedBufferSubData(int readBuffer, int writeBuffer, long readOffset, long writeOffset, long size) {
        long __functionAddress = GL45.getInstance().CopyNamedBufferSubData;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL45.nglCopyNamedBufferSubData(readBuffer, writeBuffer, readOffset, writeOffset, size, __functionAddress);
    }

    public static native void nglClearNamedBufferData(int var0, int var1, int var2, int var3, long var4, long var6);

    public static void nglClearNamedBufferData(int buffer, int internalformat, int format, int type, long data) {
        long __functionAddress = GL45.getInstance().ClearNamedBufferData;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL45.nglClearNamedBufferData(buffer, internalformat, format, type, data, __functionAddress);
    }

    public static void glClearNamedBufferData(int buffer, int internalformat, int format, int type, ByteBuffer data) {
        GL45.nglClearNamedBufferData(buffer, internalformat, format, type, MemoryUtil.memAddressSafe(data));
    }

    public static void glClearNamedBufferData(int buffer, int internalformat, int format, int type, ShortBuffer data) {
        GL45.nglClearNamedBufferData(buffer, internalformat, format, type, MemoryUtil.memAddressSafe(data));
    }

    public static void glClearNamedBufferData(int buffer, int internalformat, int format, int type, IntBuffer data) {
        GL45.nglClearNamedBufferData(buffer, internalformat, format, type, MemoryUtil.memAddressSafe(data));
    }

    public static void glClearNamedBufferData(int buffer, int internalformat, int format, int type, FloatBuffer data) {
        GL45.nglClearNamedBufferData(buffer, internalformat, format, type, MemoryUtil.memAddressSafe(data));
    }

    public static native void nglClearNamedBufferSubData(int var0, int var1, long var2, long var4, int var6, int var7, long var8, long var10);

    public static void nglClearNamedBufferSubData(int buffer, int internalformat, long offset, long size, int format, int type, long data) {
        long __functionAddress = GL45.getInstance().ClearNamedBufferSubData;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL45.nglClearNamedBufferSubData(buffer, internalformat, offset, size, format, type, data, __functionAddress);
    }

    public static void glClearNamedBufferSubData(int buffer, int internalformat, long offset, long size, int format, int type, ByteBuffer data) {
        GL45.nglClearNamedBufferSubData(buffer, internalformat, offset, size, format, type, MemoryUtil.memAddressSafe(data));
    }

    public static void glClearNamedBufferSubData(int buffer, int internalformat, long offset, long size, int format, int type, ShortBuffer data) {
        GL45.nglClearNamedBufferSubData(buffer, internalformat, offset, size, format, type, MemoryUtil.memAddressSafe(data));
    }

    public static void glClearNamedBufferSubData(int buffer, int internalformat, long offset, long size, int format, int type, IntBuffer data) {
        GL45.nglClearNamedBufferSubData(buffer, internalformat, offset, size, format, type, MemoryUtil.memAddressSafe(data));
    }

    public static void glClearNamedBufferSubData(int buffer, int internalformat, long offset, long size, int format, int type, FloatBuffer data) {
        GL45.nglClearNamedBufferSubData(buffer, internalformat, offset, size, format, type, MemoryUtil.memAddressSafe(data));
    }

    public static native long nglMapNamedBuffer(int var0, int var1, long var2);

    public static long nglMapNamedBuffer(int buffer, int access) {
        long __functionAddress = GL45.getInstance().MapNamedBuffer;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        return GL45.nglMapNamedBuffer(buffer, access, __functionAddress);
    }

    public static ByteBuffer glMapNamedBuffer(int buffer, int access) {
        long __result = GL45.nglMapNamedBuffer(buffer, access);
        return MemoryUtil.memByteBuffer(__result, GL45.glGetNamedBufferParameteri(buffer, 34660));
    }

    public static ByteBuffer glMapNamedBuffer(int buffer, int access, ByteBuffer old_buffer) {
        long __result = GL45.nglMapNamedBuffer(buffer, access);
        int length = GL45.glGetNamedBufferParameteri(buffer, 34660);
        return old_buffer != null && __result == MemoryUtil.memAddress0(old_buffer) && old_buffer.capacity() == length ? old_buffer : MemoryUtil.memByteBuffer(__result, length);
    }

    public static ByteBuffer glMapNamedBuffer(int buffer, int access, long length, ByteBuffer old_buffer) {
        long __result = GL45.nglMapNamedBuffer(buffer, access);
        return old_buffer != null && __result == MemoryUtil.memAddress0(old_buffer) && (long)old_buffer.capacity() == length ? old_buffer : MemoryUtil.memByteBuffer(__result, (int)length);
    }

    public static native long nglMapNamedBufferRange(int var0, long var1, long var3, int var5, long var6);

    public static long nglMapNamedBufferRange(int buffer, long offset, long length, int access) {
        long __functionAddress = GL45.getInstance().MapNamedBufferRange;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        return GL45.nglMapNamedBufferRange(buffer, offset, length, access, __functionAddress);
    }

    public static ByteBuffer glMapNamedBufferRange(int buffer, long offset, long length, int access) {
        long __result = GL45.nglMapNamedBufferRange(buffer, offset, length, access);
        return MemoryUtil.memByteBuffer(__result, (int)length);
    }

    public static ByteBuffer glMapNamedBufferRange(int buffer, long offset, long length, int access, ByteBuffer old_buffer) {
        long __result = GL45.nglMapNamedBufferRange(buffer, offset, length, access);
        return old_buffer != null && __result == MemoryUtil.memAddress0(old_buffer) && (long)old_buffer.capacity() == length ? old_buffer : MemoryUtil.memByteBuffer(__result, (int)length);
    }

    public static native boolean nglUnmapNamedBuffer(int var0, long var1);

    public static boolean glUnmapNamedBuffer(int buffer) {
        long __functionAddress = GL45.getInstance().UnmapNamedBuffer;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        return GL45.nglUnmapNamedBuffer(buffer, __functionAddress);
    }

    public static native void nglFlushMappedNamedBufferRange(int var0, long var1, long var3, long var5);

    public static void glFlushMappedNamedBufferRange(int buffer, long offset, long length) {
        long __functionAddress = GL45.getInstance().FlushMappedNamedBufferRange;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL45.nglFlushMappedNamedBufferRange(buffer, offset, length, __functionAddress);
    }

    public static native void nglGetNamedBufferParameteriv(int var0, int var1, long var2, long var4);

    public static void nglGetNamedBufferParameteriv(int buffer, int pname, long params) {
        long __functionAddress = GL45.getInstance().GetNamedBufferParameteriv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL45.nglGetNamedBufferParameteriv(buffer, pname, params, __functionAddress);
    }

    public static void glGetNamedBufferParameteriv(int buffer, int pname, ByteBuffer params) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)params, 4);
        }
        GL45.nglGetNamedBufferParameteriv(buffer, pname, MemoryUtil.memAddress(params));
    }

    public static void glGetNamedBufferParameteriv(int buffer, int pname, IntBuffer params) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        GL45.nglGetNamedBufferParameteriv(buffer, pname, MemoryUtil.memAddress(params));
    }

    public static int glGetNamedBufferParameteri(int buffer, int pname) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int params = __buffer.intParam();
        GL45.nglGetNamedBufferParameteriv(buffer, pname, __buffer.address(params));
        return __buffer.intValue(params);
    }

    public static native void nglGetNamedBufferParameteri64v(int var0, int var1, long var2, long var4);

    public static void nglGetNamedBufferParameteri64v(int buffer, int pname, long params) {
        long __functionAddress = GL45.getInstance().GetNamedBufferParameteri64v;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL45.nglGetNamedBufferParameteri64v(buffer, pname, params, __functionAddress);
    }

    public static void glGetNamedBufferParameteri64v(int buffer, int pname, ByteBuffer params) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)params, 8);
        }
        GL45.nglGetNamedBufferParameteri64v(buffer, pname, MemoryUtil.memAddress(params));
    }

    public static void glGetNamedBufferParameteri64v(int buffer, int pname, LongBuffer params) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        GL45.nglGetNamedBufferParameteri64v(buffer, pname, MemoryUtil.memAddress(params));
    }

    public static long glGetNamedBufferParameteri64(int buffer, int pname) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int params = __buffer.longParam();
        GL45.nglGetNamedBufferParameteri64v(buffer, pname, __buffer.address(params));
        return __buffer.longValue(params);
    }

    public static native void nglGetNamedBufferPointerv(int var0, int var1, long var2, long var4);

    public static void nglGetNamedBufferPointerv(int buffer, int pname, long params) {
        long __functionAddress = GL45.getInstance().GetNamedBufferPointerv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL45.nglGetNamedBufferPointerv(buffer, pname, params, __functionAddress);
    }

    public static void glGetNamedBufferPointerv(int buffer, int pname, ByteBuffer params) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1 << Pointer.POINTER_SHIFT);
        }
        GL45.nglGetNamedBufferPointerv(buffer, pname, MemoryUtil.memAddress(params));
    }

    public static void glGetNamedBufferPointerv(int buffer, int pname, PointerBuffer params) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer(params, 1);
        }
        GL45.nglGetNamedBufferPointerv(buffer, pname, MemoryUtil.memAddress(params));
    }

    public static long glGetNamedBufferPointer(int buffer, int pname) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int params = __buffer.pointerParam();
        GL45.nglGetNamedBufferPointerv(buffer, pname, __buffer.address(params));
        return __buffer.pointerValue(params);
    }

    public static native void nglGetNamedBufferSubData(int var0, long var1, long var3, long var5, long var7);

    public static void nglGetNamedBufferSubData(int buffer, long offset, long size, long data) {
        long __functionAddress = GL45.getInstance().GetNamedBufferSubData;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL45.nglGetNamedBufferSubData(buffer, offset, size, data, __functionAddress);
    }

    public static void glGetNamedBufferSubData(int buffer, long offset, long size, ByteBuffer data) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)data, size);
        }
        GL45.nglGetNamedBufferSubData(buffer, offset, size, MemoryUtil.memAddress(data));
    }

    public static void glGetNamedBufferSubData(int buffer, long offset, ByteBuffer data) {
        GL45.nglGetNamedBufferSubData(buffer, offset, data.remaining(), MemoryUtil.memAddress(data));
    }

    public static void glGetNamedBufferSubData(int buffer, long offset, ShortBuffer data) {
        GL45.nglGetNamedBufferSubData(buffer, offset, data.remaining() << 1, MemoryUtil.memAddress(data));
    }

    public static void glGetNamedBufferSubData(int buffer, long offset, IntBuffer data) {
        GL45.nglGetNamedBufferSubData(buffer, offset, data.remaining() << 2, MemoryUtil.memAddress(data));
    }

    public static void glGetNamedBufferSubData(int buffer, long offset, FloatBuffer data) {
        GL45.nglGetNamedBufferSubData(buffer, offset, data.remaining() << 2, MemoryUtil.memAddress(data));
    }

    public static void glGetNamedBufferSubData(int buffer, long offset, DoubleBuffer data) {
        GL45.nglGetNamedBufferSubData(buffer, offset, data.remaining() << 3, MemoryUtil.memAddress(data));
    }

    public static native void nglCreateFramebuffers(int var0, long var1, long var3);

    public static void nglCreateFramebuffers(int n, long framebuffers) {
        long __functionAddress = GL45.getInstance().CreateFramebuffers;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL45.nglCreateFramebuffers(n, framebuffers, __functionAddress);
    }

    public static void glCreateFramebuffers(int n, ByteBuffer framebuffers) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)framebuffers, n << 2);
        }
        GL45.nglCreateFramebuffers(n, MemoryUtil.memAddress(framebuffers));
    }

    public static void glCreateFramebuffers(IntBuffer framebuffers) {
        GL45.nglCreateFramebuffers(framebuffers.remaining(), MemoryUtil.memAddress(framebuffers));
    }

    public static int glCreateFramebuffers() {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int framebuffers = __buffer.intParam();
        GL45.nglCreateFramebuffers(1, __buffer.address(framebuffers));
        return __buffer.intValue(framebuffers);
    }

    public static native void nglNamedFramebufferRenderbuffer(int var0, int var1, int var2, int var3, long var4);

    public static void glNamedFramebufferRenderbuffer(int framebuffer, int attachment, int renderbuffertarget, int renderbuffer) {
        long __functionAddress = GL45.getInstance().NamedFramebufferRenderbuffer;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL45.nglNamedFramebufferRenderbuffer(framebuffer, attachment, renderbuffertarget, renderbuffer, __functionAddress);
    }

    public static native void nglNamedFramebufferParameteri(int var0, int var1, int var2, long var3);

    public static void glNamedFramebufferParameteri(int framebuffer, int pname, int param) {
        long __functionAddress = GL45.getInstance().NamedFramebufferParameteri;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL45.nglNamedFramebufferParameteri(framebuffer, pname, param, __functionAddress);
    }

    public static native void nglNamedFramebufferTexture(int var0, int var1, int var2, int var3, long var4);

    public static void glNamedFramebufferTexture(int framebuffer, int attachment, int texture, int level) {
        long __functionAddress = GL45.getInstance().NamedFramebufferTexture;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL45.nglNamedFramebufferTexture(framebuffer, attachment, texture, level, __functionAddress);
    }

    public static native void nglNamedFramebufferTextureLayer(int var0, int var1, int var2, int var3, int var4, long var5);

    public static void glNamedFramebufferTextureLayer(int framebuffer, int attachment, int texture, int level, int layer) {
        long __functionAddress = GL45.getInstance().NamedFramebufferTextureLayer;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL45.nglNamedFramebufferTextureLayer(framebuffer, attachment, texture, level, layer, __functionAddress);
    }

    public static native void nglNamedFramebufferDrawBuffer(int var0, int var1, long var2);

    public static void glNamedFramebufferDrawBuffer(int framebuffer, int buf) {
        long __functionAddress = GL45.getInstance().NamedFramebufferDrawBuffer;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL45.nglNamedFramebufferDrawBuffer(framebuffer, buf, __functionAddress);
    }

    public static native void nglNamedFramebufferDrawBuffers(int var0, int var1, long var2, long var4);

    public static void nglNamedFramebufferDrawBuffers(int framebuffer, int n, long bufs) {
        long __functionAddress = GL45.getInstance().NamedFramebufferDrawBuffers;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL45.nglNamedFramebufferDrawBuffers(framebuffer, n, bufs, __functionAddress);
    }

    public static void glNamedFramebufferDrawBuffers(int framebuffer, int n, ByteBuffer bufs) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)bufs, n << 2);
        }
        GL45.nglNamedFramebufferDrawBuffers(framebuffer, n, MemoryUtil.memAddress(bufs));
    }

    public static void glNamedFramebufferDrawBuffers(int framebuffer, IntBuffer bufs) {
        GL45.nglNamedFramebufferDrawBuffers(framebuffer, bufs.remaining(), MemoryUtil.memAddress(bufs));
    }

    public static void glNamedFramebufferDrawBuffers(int framebuffer, int buf) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int bufs = __buffer.intParam(buf);
        GL45.nglNamedFramebufferDrawBuffers(framebuffer, 1, __buffer.address(bufs));
    }

    public static native void nglNamedFramebufferReadBuffer(int var0, int var1, long var2);

    public static void glNamedFramebufferReadBuffer(int framebuffer, int src) {
        long __functionAddress = GL45.getInstance().NamedFramebufferReadBuffer;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL45.nglNamedFramebufferReadBuffer(framebuffer, src, __functionAddress);
    }

    public static native void nglInvalidateNamedFramebufferData(int var0, int var1, long var2, long var4);

    public static void nglInvalidateNamedFramebufferData(int framebuffer, int numAttachments, long attachments) {
        long __functionAddress = GL45.getInstance().InvalidateNamedFramebufferData;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL45.nglInvalidateNamedFramebufferData(framebuffer, numAttachments, attachments, __functionAddress);
    }

    public static void glInvalidateNamedFramebufferData(int framebuffer, int numAttachments, ByteBuffer attachments) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)attachments, numAttachments << 2);
        }
        GL45.nglInvalidateNamedFramebufferData(framebuffer, numAttachments, MemoryUtil.memAddress(attachments));
    }

    public static void glInvalidateNamedFramebufferData(int framebuffer, IntBuffer attachments) {
        GL45.nglInvalidateNamedFramebufferData(framebuffer, attachments.remaining(), MemoryUtil.memAddress(attachments));
    }

    public static void glInvalidateNamedFramebufferData(int framebuffer, int attachment) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int attachments = __buffer.intParam(attachment);
        GL45.nglInvalidateNamedFramebufferData(framebuffer, 1, __buffer.address(attachments));
    }

    public static native void nglInvalidateNamedFramebufferSubData(int var0, int var1, long var2, int var4, int var5, int var6, int var7, long var8);

    public static void nglInvalidateNamedFramebufferSubData(int framebuffer, int numAttachments, long attachments, int x, int y, int width, int height) {
        long __functionAddress = GL45.getInstance().InvalidateNamedFramebufferSubData;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL45.nglInvalidateNamedFramebufferSubData(framebuffer, numAttachments, attachments, x, y, width, height, __functionAddress);
    }

    public static void glInvalidateNamedFramebufferSubData(int framebuffer, int numAttachments, ByteBuffer attachments, int x, int y, int width, int height) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)attachments, numAttachments << 2);
        }
        GL45.nglInvalidateNamedFramebufferSubData(framebuffer, numAttachments, MemoryUtil.memAddress(attachments), x, y, width, height);
    }

    public static void glInvalidateNamedFramebufferSubData(int framebuffer, IntBuffer attachments, int x, int y, int width, int height) {
        GL45.nglInvalidateNamedFramebufferSubData(framebuffer, attachments.remaining(), MemoryUtil.memAddress(attachments), x, y, width, height);
    }

    public static void glInvalidateNamedFramebufferSubData(int framebuffer, int attachment, int x, int y, int width, int height) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int attachments = __buffer.intParam(attachment);
        GL45.nglInvalidateNamedFramebufferSubData(framebuffer, 1, __buffer.address(attachments), x, y, width, height);
    }

    public static native void nglClearNamedFramebufferiv(int var0, int var1, int var2, long var3, long var5);

    public static void nglClearNamedFramebufferiv(int framebuffer, int buffer, int drawbuffer, long value) {
        long __functionAddress = GL45.getInstance().ClearNamedFramebufferiv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL45.nglClearNamedFramebufferiv(framebuffer, buffer, drawbuffer, value, __functionAddress);
    }

    public static void glClearNamedFramebufferiv(int framebuffer, int buffer, int drawbuffer, ByteBuffer value) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)value, 4);
        }
        GL45.nglClearNamedFramebufferiv(framebuffer, buffer, drawbuffer, MemoryUtil.memAddress(value));
    }

    public static void glClearNamedFramebufferiv(int framebuffer, int buffer, int drawbuffer, IntBuffer value) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)value, 1);
        }
        GL45.nglClearNamedFramebufferiv(framebuffer, buffer, drawbuffer, MemoryUtil.memAddress(value));
    }

    public static native void nglClearNamedFramebufferuiv(int var0, int var1, int var2, long var3, long var5);

    public static void nglClearNamedFramebufferuiv(int framebuffer, int buffer, int drawbuffer, long value) {
        long __functionAddress = GL45.getInstance().ClearNamedFramebufferuiv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL45.nglClearNamedFramebufferuiv(framebuffer, buffer, drawbuffer, value, __functionAddress);
    }

    public static void glClearNamedFramebufferuiv(int framebuffer, int buffer, int drawbuffer, ByteBuffer value) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)value, 16);
        }
        GL45.nglClearNamedFramebufferuiv(framebuffer, buffer, drawbuffer, MemoryUtil.memAddress(value));
    }

    public static void glClearNamedFramebufferuiv(int framebuffer, int buffer, int drawbuffer, IntBuffer value) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)value, 4);
        }
        GL45.nglClearNamedFramebufferuiv(framebuffer, buffer, drawbuffer, MemoryUtil.memAddress(value));
    }

    public static native void nglClearNamedFramebufferfv(int var0, int var1, int var2, long var3, long var5);

    public static void nglClearNamedFramebufferfv(int framebuffer, int buffer, int drawbuffer, long value) {
        long __functionAddress = GL45.getInstance().ClearNamedFramebufferfv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL45.nglClearNamedFramebufferfv(framebuffer, buffer, drawbuffer, value, __functionAddress);
    }

    public static void glClearNamedFramebufferfv(int framebuffer, int buffer, int drawbuffer, ByteBuffer value) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)value, 4);
        }
        GL45.nglClearNamedFramebufferfv(framebuffer, buffer, drawbuffer, MemoryUtil.memAddress(value));
    }

    public static void glClearNamedFramebufferfv(int framebuffer, int buffer, int drawbuffer, FloatBuffer value) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)value, 1);
        }
        GL45.nglClearNamedFramebufferfv(framebuffer, buffer, drawbuffer, MemoryUtil.memAddress(value));
    }

    public static native void nglClearNamedFramebufferfi(int var0, int var1, float var2, int var3, long var4);

    public static void glClearNamedFramebufferfi(int framebuffer, int buffer, float depth, int stencil) {
        long __functionAddress = GL45.getInstance().ClearNamedFramebufferfi;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL45.nglClearNamedFramebufferfi(framebuffer, buffer, depth, stencil, __functionAddress);
    }

    public static native void nglBlitNamedFramebuffer(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10, int var11, long var12);

    public static void glBlitNamedFramebuffer(int readFramebuffer, int drawFramebuffer, int srcX0, int srcY0, int srcX1, int srcY1, int dstX0, int dstY0, int dstX1, int dstY1, int mask, int filter) {
        long __functionAddress = GL45.getInstance().BlitNamedFramebuffer;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL45.nglBlitNamedFramebuffer(readFramebuffer, drawFramebuffer, srcX0, srcY0, srcX1, srcY1, dstX0, dstY0, dstX1, dstY1, mask, filter, __functionAddress);
    }

    public static native int nglCheckNamedFramebufferStatus(int var0, int var1, long var2);

    public static int glCheckNamedFramebufferStatus(int framebuffer, int target) {
        long __functionAddress = GL45.getInstance().CheckNamedFramebufferStatus;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        return GL45.nglCheckNamedFramebufferStatus(framebuffer, target, __functionAddress);
    }

    public static native void nglGetNamedFramebufferParameteriv(int var0, int var1, long var2, long var4);

    public static void nglGetNamedFramebufferParameteriv(int framebuffer, int pname, long params) {
        long __functionAddress = GL45.getInstance().GetNamedFramebufferParameteriv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL45.nglGetNamedFramebufferParameteriv(framebuffer, pname, params, __functionAddress);
    }

    public static void glGetNamedFramebufferParameteriv(int framebuffer, int pname, ByteBuffer params) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)params, 4);
        }
        GL45.nglGetNamedFramebufferParameteriv(framebuffer, pname, MemoryUtil.memAddress(params));
    }

    public static void glGetNamedFramebufferParameteriv(int framebuffer, int pname, IntBuffer params) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        GL45.nglGetNamedFramebufferParameteriv(framebuffer, pname, MemoryUtil.memAddress(params));
    }

    public static int glGetNamedFramebufferParameteri(int framebuffer, int pname) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int params = __buffer.intParam();
        GL45.nglGetNamedFramebufferParameteriv(framebuffer, pname, __buffer.address(params));
        return __buffer.intValue(params);
    }

    public static native void nglGetNamedFramebufferAttachmentParameteriv(int var0, int var1, int var2, long var3, long var5);

    public static void nglGetNamedFramebufferAttachmentParameteriv(int framebuffer, int attachment, int pname, long params) {
        long __functionAddress = GL45.getInstance().GetNamedFramebufferAttachmentParameteriv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL45.nglGetNamedFramebufferAttachmentParameteriv(framebuffer, attachment, pname, params, __functionAddress);
    }

    public static void glGetNamedFramebufferAttachmentParameteriv(int framebuffer, int attachment, int pname, ByteBuffer params) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)params, 4);
        }
        GL45.nglGetNamedFramebufferAttachmentParameteriv(framebuffer, attachment, pname, MemoryUtil.memAddress(params));
    }

    public static void glGetNamedFramebufferAttachmentParameteriv(int framebuffer, int attachment, int pname, IntBuffer params) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        GL45.nglGetNamedFramebufferAttachmentParameteriv(framebuffer, attachment, pname, MemoryUtil.memAddress(params));
    }

    public static int glGetNamedFramebufferAttachmentParameteri(int framebuffer, int attachment, int pname) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int params = __buffer.intParam();
        GL45.nglGetNamedFramebufferAttachmentParameteriv(framebuffer, attachment, pname, __buffer.address(params));
        return __buffer.intValue(params);
    }

    public static native void nglCreateRenderbuffers(int var0, long var1, long var3);

    public static void nglCreateRenderbuffers(int n, long renderbuffers) {
        long __functionAddress = GL45.getInstance().CreateRenderbuffers;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL45.nglCreateRenderbuffers(n, renderbuffers, __functionAddress);
    }

    public static void glCreateRenderbuffers(int n, ByteBuffer renderbuffers) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)renderbuffers, n << 2);
        }
        GL45.nglCreateRenderbuffers(n, MemoryUtil.memAddress(renderbuffers));
    }

    public static void glCreateRenderbuffers(IntBuffer renderbuffers) {
        GL45.nglCreateRenderbuffers(renderbuffers.remaining(), MemoryUtil.memAddress(renderbuffers));
    }

    public static int glCreateRenderbuffers() {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int renderbuffers = __buffer.intParam();
        GL45.nglCreateRenderbuffers(1, __buffer.address(renderbuffers));
        return __buffer.intValue(renderbuffers);
    }

    public static native void nglNamedRenderbufferStorage(int var0, int var1, int var2, int var3, long var4);

    public static void glNamedRenderbufferStorage(int renderbuffer, int internalformat, int width, int height) {
        long __functionAddress = GL45.getInstance().NamedRenderbufferStorage;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL45.nglNamedRenderbufferStorage(renderbuffer, internalformat, width, height, __functionAddress);
    }

    public static native void nglNamedRenderbufferStorageMultisample(int var0, int var1, int var2, int var3, int var4, long var5);

    public static void glNamedRenderbufferStorageMultisample(int renderbuffer, int samples, int internalformat, int width, int height) {
        long __functionAddress = GL45.getInstance().NamedRenderbufferStorageMultisample;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL45.nglNamedRenderbufferStorageMultisample(renderbuffer, samples, internalformat, width, height, __functionAddress);
    }

    public static native void nglGetNamedRenderbufferParameteriv(int var0, int var1, long var2, long var4);

    public static void nglGetNamedRenderbufferParameteriv(int renderbuffer, int pname, long params) {
        long __functionAddress = GL45.getInstance().GetNamedRenderbufferParameteriv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL45.nglGetNamedRenderbufferParameteriv(renderbuffer, pname, params, __functionAddress);
    }

    public static void glGetNamedRenderbufferParameteriv(int renderbuffer, int pname, ByteBuffer params) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)params, 4);
        }
        GL45.nglGetNamedRenderbufferParameteriv(renderbuffer, pname, MemoryUtil.memAddress(params));
    }

    public static void glGetNamedRenderbufferParameteriv(int renderbuffer, int pname, IntBuffer params) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        GL45.nglGetNamedRenderbufferParameteriv(renderbuffer, pname, MemoryUtil.memAddress(params));
    }

    public static int glGetNamedRenderbufferParameteri(int renderbuffer, int pname) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int params = __buffer.intParam();
        GL45.nglGetNamedRenderbufferParameteriv(renderbuffer, pname, __buffer.address(params));
        return __buffer.intValue(params);
    }

    public static native void nglCreateTextures(int var0, int var1, long var2, long var4);

    public static void nglCreateTextures(int target, int n, long textures) {
        long __functionAddress = GL45.getInstance().CreateTextures;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL45.nglCreateTextures(target, n, textures, __functionAddress);
    }

    public static void glCreateTextures(int target, int n, ByteBuffer textures) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)textures, n << 2);
        }
        GL45.nglCreateTextures(target, n, MemoryUtil.memAddress(textures));
    }

    public static void glCreateTextures(int target, IntBuffer textures) {
        GL45.nglCreateTextures(target, textures.remaining(), MemoryUtil.memAddress(textures));
    }

    public static int glCreateTextures(int target) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int textures = __buffer.intParam();
        GL45.nglCreateTextures(target, 1, __buffer.address(textures));
        return __buffer.intValue(textures);
    }

    public static native void nglTextureBuffer(int var0, int var1, int var2, long var3);

    public static void glTextureBuffer(int texture, int internalformat, int buffer) {
        long __functionAddress = GL45.getInstance().TextureBuffer;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL45.nglTextureBuffer(texture, internalformat, buffer, __functionAddress);
    }

    public static native void nglTextureBufferRange(int var0, int var1, int var2, long var3, long var5, long var7);

    public static void glTextureBufferRange(int texture, int internalformat, int buffer, long offset, long size) {
        long __functionAddress = GL45.getInstance().TextureBufferRange;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL45.nglTextureBufferRange(texture, internalformat, buffer, offset, size, __functionAddress);
    }

    public static native void nglTextureStorage1D(int var0, int var1, int var2, int var3, long var4);

    public static void glTextureStorage1D(int texture, int levels, int internalformat, int width) {
        long __functionAddress = GL45.getInstance().TextureStorage1D;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL45.nglTextureStorage1D(texture, levels, internalformat, width, __functionAddress);
    }

    public static native void nglTextureStorage2D(int var0, int var1, int var2, int var3, int var4, long var5);

    public static void glTextureStorage2D(int texture, int levels, int internalformat, int width, int height) {
        long __functionAddress = GL45.getInstance().TextureStorage2D;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL45.nglTextureStorage2D(texture, levels, internalformat, width, height, __functionAddress);
    }

    public static native void nglTextureStorage3D(int var0, int var1, int var2, int var3, int var4, int var5, long var6);

    public static void glTextureStorage3D(int texture, int levels, int internalformat, int width, int height, int depth) {
        long __functionAddress = GL45.getInstance().TextureStorage3D;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL45.nglTextureStorage3D(texture, levels, internalformat, width, height, depth, __functionAddress);
    }

    public static native void nglTextureStorage2DMultisample(int var0, int var1, int var2, int var3, int var4, boolean var5, long var6);

    public static void glTextureStorage2DMultisample(int texture, int samples, int internalformat, int width, int height, boolean fixedsamplelocations) {
        long __functionAddress = GL45.getInstance().TextureStorage2DMultisample;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL45.nglTextureStorage2DMultisample(texture, samples, internalformat, width, height, fixedsamplelocations, __functionAddress);
    }

    public static native void nglTextureStorage3DMultisample(int var0, int var1, int var2, int var3, int var4, int var5, boolean var6, long var7);

    public static void glTextureStorage3DMultisample(int texture, int samples, int internalformat, int width, int height, int depth, boolean fixedsamplelocations) {
        long __functionAddress = GL45.getInstance().TextureStorage3DMultisample;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL45.nglTextureStorage3DMultisample(texture, samples, internalformat, width, height, depth, fixedsamplelocations, __functionAddress);
    }

    public static native void nglTextureSubImage1D(int var0, int var1, int var2, int var3, int var4, int var5, long var6, long var8);

    public static void nglTextureSubImage1D(int texture, int level, int xoffset, int width, int format, int type, long pixels) {
        long __functionAddress = GL45.getInstance().TextureSubImage1D;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL45.nglTextureSubImage1D(texture, level, xoffset, width, format, type, pixels, __functionAddress);
    }

    public static void glTextureSubImage1D(int texture, int level, int xoffset, int width, int format, int type, ByteBuffer pixels) {
        if (LWJGLUtil.CHECKS) {
            GLChecks.ensureBufferObject(35055, false);
        }
        GL45.nglTextureSubImage1D(texture, level, xoffset, width, format, type, MemoryUtil.memAddress(pixels));
    }

    public static void glTextureSubImage1D(int texture, int level, int xoffset, int width, int format, int type, long pixelsOffset) {
        if (LWJGLUtil.CHECKS) {
            GLChecks.ensureBufferObject(35055, true);
        }
        GL45.nglTextureSubImage1D(texture, level, xoffset, width, format, type, pixelsOffset);
    }

    public static void glTextureSubImage1D(int texture, int level, int xoffset, int width, int format, int type, ShortBuffer pixels) {
        if (LWJGLUtil.CHECKS) {
            GLChecks.ensureBufferObject(35055, false);
        }
        GL45.nglTextureSubImage1D(texture, level, xoffset, width, format, type, MemoryUtil.memAddress(pixels));
    }

    public static void glTextureSubImage1D(int texture, int level, int xoffset, int width, int format, int type, IntBuffer pixels) {
        if (LWJGLUtil.CHECKS) {
            GLChecks.ensureBufferObject(35055, false);
        }
        GL45.nglTextureSubImage1D(texture, level, xoffset, width, format, type, MemoryUtil.memAddress(pixels));
    }

    public static void glTextureSubImage1D(int texture, int level, int xoffset, int width, int format, int type, FloatBuffer pixels) {
        if (LWJGLUtil.CHECKS) {
            GLChecks.ensureBufferObject(35055, false);
        }
        GL45.nglTextureSubImage1D(texture, level, xoffset, width, format, type, MemoryUtil.memAddress(pixels));
    }

    public static void glTextureSubImage1D(int texture, int level, int xoffset, int width, int format, int type, DoubleBuffer pixels) {
        if (LWJGLUtil.CHECKS) {
            GLChecks.ensureBufferObject(35055, false);
        }
        GL45.nglTextureSubImage1D(texture, level, xoffset, width, format, type, MemoryUtil.memAddress(pixels));
    }

    public static native void nglTextureSubImage2D(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, long var8, long var10);

    public static void nglTextureSubImage2D(int texture, int level, int xoffset, int yoffset, int width, int height, int format, int type, long pixels) {
        long __functionAddress = GL45.getInstance().TextureSubImage2D;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL45.nglTextureSubImage2D(texture, level, xoffset, yoffset, width, height, format, type, pixels, __functionAddress);
    }

    public static void glTextureSubImage2D(int texture, int level, int xoffset, int yoffset, int width, int height, int format, int type, ByteBuffer pixels) {
        if (LWJGLUtil.CHECKS) {
            GLChecks.ensureBufferObject(35055, false);
        }
        GL45.nglTextureSubImage2D(texture, level, xoffset, yoffset, width, height, format, type, MemoryUtil.memAddress(pixels));
    }

    public static void glTextureSubImage2D(int texture, int level, int xoffset, int yoffset, int width, int height, int format, int type, long pixelsOffset) {
        if (LWJGLUtil.CHECKS) {
            GLChecks.ensureBufferObject(35055, true);
        }
        GL45.nglTextureSubImage2D(texture, level, xoffset, yoffset, width, height, format, type, pixelsOffset);
    }

    public static void glTextureSubImage2D(int texture, int level, int xoffset, int yoffset, int width, int height, int format, int type, ShortBuffer pixels) {
        if (LWJGLUtil.CHECKS) {
            GLChecks.ensureBufferObject(35055, false);
        }
        GL45.nglTextureSubImage2D(texture, level, xoffset, yoffset, width, height, format, type, MemoryUtil.memAddress(pixels));
    }

    public static void glTextureSubImage2D(int texture, int level, int xoffset, int yoffset, int width, int height, int format, int type, IntBuffer pixels) {
        if (LWJGLUtil.CHECKS) {
            GLChecks.ensureBufferObject(35055, false);
        }
        GL45.nglTextureSubImage2D(texture, level, xoffset, yoffset, width, height, format, type, MemoryUtil.memAddress(pixels));
    }

    public static void glTextureSubImage2D(int texture, int level, int xoffset, int yoffset, int width, int height, int format, int type, FloatBuffer pixels) {
        if (LWJGLUtil.CHECKS) {
            GLChecks.ensureBufferObject(35055, false);
        }
        GL45.nglTextureSubImage2D(texture, level, xoffset, yoffset, width, height, format, type, MemoryUtil.memAddress(pixels));
    }

    public static void glTextureSubImage2D(int texture, int level, int xoffset, int yoffset, int width, int height, int format, int type, DoubleBuffer pixels) {
        if (LWJGLUtil.CHECKS) {
            GLChecks.ensureBufferObject(35055, false);
        }
        GL45.nglTextureSubImage2D(texture, level, xoffset, yoffset, width, height, format, type, MemoryUtil.memAddress(pixels));
    }

    public static native void nglTextureSubImage3D(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, long var10, long var12);

    public static void nglTextureSubImage3D(int texture, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int type, long pixels) {
        long __functionAddress = GL45.getInstance().TextureSubImage3D;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL45.nglTextureSubImage3D(texture, level, xoffset, yoffset, zoffset, width, height, depth, format, type, pixels, __functionAddress);
    }

    public static void glTextureSubImage3D(int texture, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int type, ByteBuffer pixels) {
        if (LWJGLUtil.CHECKS) {
            GLChecks.ensureBufferObject(35055, false);
        }
        GL45.nglTextureSubImage3D(texture, level, xoffset, yoffset, zoffset, width, height, depth, format, type, MemoryUtil.memAddress(pixels));
    }

    public static void glTextureSubImage3D(int texture, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int type, long pixelsOffset) {
        if (LWJGLUtil.CHECKS) {
            GLChecks.ensureBufferObject(35055, true);
        }
        GL45.nglTextureSubImage3D(texture, level, xoffset, yoffset, zoffset, width, height, depth, format, type, pixelsOffset);
    }

    public static void glTextureSubImage3D(int texture, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int type, ShortBuffer pixels) {
        if (LWJGLUtil.CHECKS) {
            GLChecks.ensureBufferObject(35055, false);
        }
        GL45.nglTextureSubImage3D(texture, level, xoffset, yoffset, zoffset, width, height, depth, format, type, MemoryUtil.memAddress(pixels));
    }

    public static void glTextureSubImage3D(int texture, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int type, IntBuffer pixels) {
        if (LWJGLUtil.CHECKS) {
            GLChecks.ensureBufferObject(35055, false);
        }
        GL45.nglTextureSubImage3D(texture, level, xoffset, yoffset, zoffset, width, height, depth, format, type, MemoryUtil.memAddress(pixels));
    }

    public static void glTextureSubImage3D(int texture, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int type, FloatBuffer pixels) {
        if (LWJGLUtil.CHECKS) {
            GLChecks.ensureBufferObject(35055, false);
        }
        GL45.nglTextureSubImage3D(texture, level, xoffset, yoffset, zoffset, width, height, depth, format, type, MemoryUtil.memAddress(pixels));
    }

    public static void glTextureSubImage3D(int texture, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int type, DoubleBuffer pixels) {
        if (LWJGLUtil.CHECKS) {
            GLChecks.ensureBufferObject(35055, false);
        }
        GL45.nglTextureSubImage3D(texture, level, xoffset, yoffset, zoffset, width, height, depth, format, type, MemoryUtil.memAddress(pixels));
    }

    public static native void nglCompressedTextureSubImage1D(int var0, int var1, int var2, int var3, int var4, int var5, long var6, long var8);

    public static void nglCompressedTextureSubImage1D(int texture, int level, int xoffset, int width, int format, int imageSize, long data) {
        long __functionAddress = GL45.getInstance().CompressedTextureSubImage1D;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL45.nglCompressedTextureSubImage1D(texture, level, xoffset, width, format, imageSize, data, __functionAddress);
    }

    public static void glCompressedTextureSubImage1D(int texture, int level, int xoffset, int width, int format, int imageSize, ByteBuffer data) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)data, imageSize);
            GLChecks.ensureBufferObject(35055, false);
        }
        GL45.nglCompressedTextureSubImage1D(texture, level, xoffset, width, format, imageSize, MemoryUtil.memAddress(data));
    }

    public static void glCompressedTextureSubImage1D(int texture, int level, int xoffset, int width, int format, int imageSize, long dataOffset) {
        if (LWJGLUtil.CHECKS) {
            GLChecks.ensureBufferObject(35055, true);
        }
        GL45.nglCompressedTextureSubImage1D(texture, level, xoffset, width, format, imageSize, dataOffset);
    }

    public static void glCompressedTextureSubImage1D(int texture, int level, int xoffset, int width, int format, ByteBuffer data) {
        if (LWJGLUtil.CHECKS) {
            GLChecks.ensureBufferObject(35055, false);
        }
        GL45.nglCompressedTextureSubImage1D(texture, level, xoffset, width, format, data.remaining(), MemoryUtil.memAddress(data));
    }

    public static native void nglCompressedTextureSubImage2D(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, long var8, long var10);

    public static void nglCompressedTextureSubImage2D(int texture, int level, int xoffset, int yoffset, int width, int height, int format, int imageSize, long data) {
        long __functionAddress = GL45.getInstance().CompressedTextureSubImage2D;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL45.nglCompressedTextureSubImage2D(texture, level, xoffset, yoffset, width, height, format, imageSize, data, __functionAddress);
    }

    public static void glCompressedTextureSubImage2D(int texture, int level, int xoffset, int yoffset, int width, int height, int format, int imageSize, ByteBuffer data) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)data, imageSize);
            GLChecks.ensureBufferObject(35055, false);
        }
        GL45.nglCompressedTextureSubImage2D(texture, level, xoffset, yoffset, width, height, format, imageSize, MemoryUtil.memAddress(data));
    }

    public static void glCompressedTextureSubImage2D(int texture, int level, int xoffset, int yoffset, int width, int height, int format, int imageSize, long dataOffset) {
        if (LWJGLUtil.CHECKS) {
            GLChecks.ensureBufferObject(35055, true);
        }
        GL45.nglCompressedTextureSubImage2D(texture, level, xoffset, yoffset, width, height, format, imageSize, dataOffset);
    }

    public static void glCompressedTextureSubImage2D(int texture, int level, int xoffset, int yoffset, int width, int height, int format, ByteBuffer data) {
        if (LWJGLUtil.CHECKS) {
            GLChecks.ensureBufferObject(35055, false);
        }
        GL45.nglCompressedTextureSubImage2D(texture, level, xoffset, yoffset, width, height, format, data.remaining(), MemoryUtil.memAddress(data));
    }

    public static native void nglCompressedTextureSubImage3D(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, long var10, long var12);

    public static void nglCompressedTextureSubImage3D(int texture, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int imageSize, long data) {
        long __functionAddress = GL45.getInstance().CompressedTextureSubImage3D;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL45.nglCompressedTextureSubImage3D(texture, level, xoffset, yoffset, zoffset, width, height, depth, format, imageSize, data, __functionAddress);
    }

    public static void glCompressedTextureSubImage3D(int texture, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int imageSize, ByteBuffer data) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)data, imageSize);
            GLChecks.ensureBufferObject(35055, false);
        }
        GL45.nglCompressedTextureSubImage3D(texture, level, xoffset, yoffset, zoffset, width, height, depth, format, imageSize, MemoryUtil.memAddress(data));
    }

    public static void glCompressedTextureSubImage3D(int texture, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int imageSize, long dataOffset) {
        if (LWJGLUtil.CHECKS) {
            GLChecks.ensureBufferObject(35055, true);
        }
        GL45.nglCompressedTextureSubImage3D(texture, level, xoffset, yoffset, zoffset, width, height, depth, format, imageSize, dataOffset);
    }

    public static void glCompressedTextureSubImage3D(int texture, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, ByteBuffer data) {
        if (LWJGLUtil.CHECKS) {
            GLChecks.ensureBufferObject(35055, false);
        }
        GL45.nglCompressedTextureSubImage3D(texture, level, xoffset, yoffset, zoffset, width, height, depth, format, data.remaining(), MemoryUtil.memAddress(data));
    }

    public static native void nglCopyTextureSubImage1D(int var0, int var1, int var2, int var3, int var4, int var5, long var6);

    public static void glCopyTextureSubImage1D(int texture, int level, int xoffset, int x, int y, int width) {
        long __functionAddress = GL45.getInstance().CopyTextureSubImage1D;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL45.nglCopyTextureSubImage1D(texture, level, xoffset, x, y, width, __functionAddress);
    }

    public static native void nglCopyTextureSubImage2D(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, long var8);

    public static void glCopyTextureSubImage2D(int texture, int level, int xoffset, int yoffset, int x, int y, int width, int height) {
        long __functionAddress = GL45.getInstance().CopyTextureSubImage2D;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL45.nglCopyTextureSubImage2D(texture, level, xoffset, yoffset, x, y, width, height, __functionAddress);
    }

    public static native void nglCopyTextureSubImage3D(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, long var9);

    public static void glCopyTextureSubImage3D(int texture, int level, int xoffset, int yoffset, int zoffset, int x, int y, int width, int height) {
        long __functionAddress = GL45.getInstance().CopyTextureSubImage3D;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL45.nglCopyTextureSubImage3D(texture, level, xoffset, yoffset, zoffset, x, y, width, height, __functionAddress);
    }

    public static native void nglTextureParameterf(int var0, int var1, float var2, long var3);

    public static void glTextureParameterf(int texture, int pname, float param) {
        long __functionAddress = GL45.getInstance().TextureParameterf;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL45.nglTextureParameterf(texture, pname, param, __functionAddress);
    }

    public static native void nglTextureParameterfv(int var0, int var1, long var2, long var4);

    public static void nglTextureParameterfv(int texture, int pname, long params) {
        long __functionAddress = GL45.getInstance().TextureParameterfv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL45.nglTextureParameterfv(texture, pname, params, __functionAddress);
    }

    public static void glTextureParameterfv(int texture, int pname, ByteBuffer params) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)params, 16);
        }
        GL45.nglTextureParameterfv(texture, pname, MemoryUtil.memAddress(params));
    }

    public static void glTextureParameterfv(int texture, int pname, FloatBuffer params) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)params, 4);
        }
        GL45.nglTextureParameterfv(texture, pname, MemoryUtil.memAddress(params));
    }

    public static native void nglTextureParameteri(int var0, int var1, int var2, long var3);

    public static void glTextureParameteri(int texture, int pname, int param) {
        long __functionAddress = GL45.getInstance().TextureParameteri;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL45.nglTextureParameteri(texture, pname, param, __functionAddress);
    }

    public static native void nglTextureParameterIiv(int var0, int var1, long var2, long var4);

    public static void nglTextureParameterIiv(int texture, int pname, long params) {
        long __functionAddress = GL45.getInstance().TextureParameterIiv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL45.nglTextureParameterIiv(texture, pname, params, __functionAddress);
    }

    public static void glTextureParameterIiv(int texture, int pname, ByteBuffer params) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)params, 4);
        }
        GL45.nglTextureParameterIiv(texture, pname, MemoryUtil.memAddress(params));
    }

    public static void glTextureParameterIiv(int texture, int pname, IntBuffer params) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        GL45.nglTextureParameterIiv(texture, pname, MemoryUtil.memAddress(params));
    }

    public static void glTextureParameterIi(int texture, int pname, int param) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int params = __buffer.intParam(param);
        GL45.nglTextureParameterIiv(texture, pname, __buffer.address(params));
    }

    public static native void nglTextureParameterIuiv(int var0, int var1, long var2, long var4);

    public static void nglTextureParameterIuiv(int texture, int pname, long params) {
        long __functionAddress = GL45.getInstance().TextureParameterIuiv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL45.nglTextureParameterIuiv(texture, pname, params, __functionAddress);
    }

    public static void glTextureParameterIuiv(int texture, int pname, ByteBuffer params) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)params, 4);
        }
        GL45.nglTextureParameterIuiv(texture, pname, MemoryUtil.memAddress(params));
    }

    public static void glTextureParameterIuiv(int texture, int pname, IntBuffer params) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        GL45.nglTextureParameterIuiv(texture, pname, MemoryUtil.memAddress(params));
    }

    public static void glTextureParameterIui(int texture, int pname, int param) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int params = __buffer.intParam(param);
        GL45.nglTextureParameterIuiv(texture, pname, __buffer.address(params));
    }

    public static native void nglTextureParameteriv(int var0, int var1, long var2, long var4);

    public static void nglTextureParameteriv(int texture, int pname, long params) {
        long __functionAddress = GL45.getInstance().TextureParameteriv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL45.nglTextureParameteriv(texture, pname, params, __functionAddress);
    }

    public static void glTextureParameteriv(int texture, int pname, ByteBuffer params) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)params, 16);
        }
        GL45.nglTextureParameteriv(texture, pname, MemoryUtil.memAddress(params));
    }

    public static void glTextureParameteriv(int texture, int pname, IntBuffer params) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)params, 4);
        }
        GL45.nglTextureParameteriv(texture, pname, MemoryUtil.memAddress(params));
    }

    public static native void nglGenerateTextureMipmap(int var0, long var1);

    public static void glGenerateTextureMipmap(int texture) {
        long __functionAddress = GL45.getInstance().GenerateTextureMipmap;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL45.nglGenerateTextureMipmap(texture, __functionAddress);
    }

    public static native void nglBindTextureUnit(int var0, int var1, long var2);

    public static void glBindTextureUnit(int unit, int texture) {
        long __functionAddress = GL45.getInstance().BindTextureUnit;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL45.nglBindTextureUnit(unit, texture, __functionAddress);
    }

    public static native void nglGetTextureImage(int var0, int var1, int var2, int var3, int var4, long var5, long var7);

    public static void nglGetTextureImage(int texture, int level, int format, int type, int bufSize, long pixels) {
        long __functionAddress = GL45.getInstance().GetTextureImage;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL45.nglGetTextureImage(texture, level, format, type, bufSize, pixels, __functionAddress);
    }

    public static void glGetTextureImage(int texture, int level, int format, int type, int bufSize, ByteBuffer pixels) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)pixels, bufSize);
            GLChecks.ensureBufferObject(35053, false);
        }
        GL45.nglGetTextureImage(texture, level, format, type, bufSize, MemoryUtil.memAddress(pixels));
    }

    public static void glGetTextureImage(int texture, int level, int format, int type, int bufSize, long pixelsOffset) {
        if (LWJGLUtil.CHECKS) {
            GLChecks.ensureBufferObject(35053, true);
        }
        GL45.nglGetTextureImage(texture, level, format, type, bufSize, pixelsOffset);
    }

    public static void glGetTextureImage(int texture, int level, int format, int type, ShortBuffer pixels) {
        if (LWJGLUtil.CHECKS) {
            GLChecks.ensureBufferObject(35053, false);
        }
        GL45.nglGetTextureImage(texture, level, format, type, pixels.remaining() << 1, MemoryUtil.memAddress(pixels));
    }

    public static void glGetTextureImage(int texture, int level, int format, int type, IntBuffer pixels) {
        if (LWJGLUtil.CHECKS) {
            GLChecks.ensureBufferObject(35053, false);
        }
        GL45.nglGetTextureImage(texture, level, format, type, pixels.remaining() << 2, MemoryUtil.memAddress(pixels));
    }

    public static void glGetTextureImage(int texture, int level, int format, int type, FloatBuffer pixels) {
        if (LWJGLUtil.CHECKS) {
            GLChecks.ensureBufferObject(35053, false);
        }
        GL45.nglGetTextureImage(texture, level, format, type, pixels.remaining() << 2, MemoryUtil.memAddress(pixels));
    }

    public static void glGetTextureImage(int texture, int level, int format, int type, DoubleBuffer pixels) {
        if (LWJGLUtil.CHECKS) {
            GLChecks.ensureBufferObject(35053, false);
        }
        GL45.nglGetTextureImage(texture, level, format, type, pixels.remaining() << 3, MemoryUtil.memAddress(pixels));
    }

    public static native void nglGetCompressedTextureImage(int var0, int var1, int var2, long var3, long var5);

    public static void nglGetCompressedTextureImage(int texture, int level, int bufSize, long pixels) {
        long __functionAddress = GL45.getInstance().GetCompressedTextureImage;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL45.nglGetCompressedTextureImage(texture, level, bufSize, pixels, __functionAddress);
    }

    public static void glGetCompressedTextureImage(int texture, int level, int bufSize, ByteBuffer pixels) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)pixels, bufSize);
            if (LWJGLUtil.DEBUG) {
                Checks.checkBuffer((Buffer)pixels, GL45.glGetTextureLevelParameteri(texture, level, 34464));
            }
            GLChecks.ensureBufferObject(35053, false);
        }
        GL45.nglGetCompressedTextureImage(texture, level, bufSize, MemoryUtil.memAddress(pixels));
    }

    public static void glGetCompressedTextureImage(int texture, int level, int bufSize, long pixelsOffset) {
        if (LWJGLUtil.CHECKS) {
            GLChecks.ensureBufferObject(35053, true);
        }
        GL45.nglGetCompressedTextureImage(texture, level, bufSize, pixelsOffset);
    }

    public static void glGetCompressedTextureImage(int texture, int level, ByteBuffer pixels) {
        if (LWJGLUtil.CHECKS) {
            if (LWJGLUtil.DEBUG) {
                Checks.checkBuffer((Buffer)pixels, GL45.glGetTextureLevelParameteri(texture, level, 34464));
            }
            GLChecks.ensureBufferObject(35053, false);
        }
        GL45.nglGetCompressedTextureImage(texture, level, pixels.remaining(), MemoryUtil.memAddress(pixels));
    }

    public static native void nglGetTextureLevelParameterfv(int var0, int var1, int var2, long var3, long var5);

    public static void nglGetTextureLevelParameterfv(int texture, int level, int pname, long params) {
        long __functionAddress = GL45.getInstance().GetTextureLevelParameterfv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL45.nglGetTextureLevelParameterfv(texture, level, pname, params, __functionAddress);
    }

    public static void glGetTextureLevelParameterfv(int texture, int level, int pname, ByteBuffer params) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)params, 4);
        }
        GL45.nglGetTextureLevelParameterfv(texture, level, pname, MemoryUtil.memAddress(params));
    }

    public static void glGetTextureLevelParameterfv(int texture, int level, int pname, FloatBuffer params) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        GL45.nglGetTextureLevelParameterfv(texture, level, pname, MemoryUtil.memAddress(params));
    }

    public static float glGetTextureLevelParameterf(int texture, int level, int pname) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int params = __buffer.floatParam();
        GL45.nglGetTextureLevelParameterfv(texture, level, pname, __buffer.address(params));
        return __buffer.floatValue(params);
    }

    public static native void nglGetTextureLevelParameteriv(int var0, int var1, int var2, long var3, long var5);

    public static void nglGetTextureLevelParameteriv(int texture, int level, int pname, long params) {
        long __functionAddress = GL45.getInstance().GetTextureLevelParameteriv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL45.nglGetTextureLevelParameteriv(texture, level, pname, params, __functionAddress);
    }

    public static void glGetTextureLevelParameteriv(int texture, int level, int pname, ByteBuffer params) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)params, 4);
        }
        GL45.nglGetTextureLevelParameteriv(texture, level, pname, MemoryUtil.memAddress(params));
    }

    public static void glGetTextureLevelParameteriv(int texture, int level, int pname, IntBuffer params) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        GL45.nglGetTextureLevelParameteriv(texture, level, pname, MemoryUtil.memAddress(params));
    }

    public static int glGetTextureLevelParameteri(int texture, int level, int pname) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int params = __buffer.intParam();
        GL45.nglGetTextureLevelParameteriv(texture, level, pname, __buffer.address(params));
        return __buffer.intValue(params);
    }

    public static native void nglGetTextureParameterfv(int var0, int var1, long var2, long var4);

    public static void nglGetTextureParameterfv(int texture, int pname, long params) {
        long __functionAddress = GL45.getInstance().GetTextureParameterfv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL45.nglGetTextureParameterfv(texture, pname, params, __functionAddress);
    }

    public static void glGetTextureParameterfv(int texture, int pname, ByteBuffer params) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)params, 4);
        }
        GL45.nglGetTextureParameterfv(texture, pname, MemoryUtil.memAddress(params));
    }

    public static void glGetTextureParameterfv(int texture, int pname, FloatBuffer params) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        GL45.nglGetTextureParameterfv(texture, pname, MemoryUtil.memAddress(params));
    }

    public static float glGetTextureParameterf(int texture, int pname) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int params = __buffer.floatParam();
        GL45.nglGetTextureParameterfv(texture, pname, __buffer.address(params));
        return __buffer.floatValue(params);
    }

    public static native void nglGetTextureParameterIiv(int var0, int var1, long var2, long var4);

    public static void nglGetTextureParameterIiv(int texture, int pname, long params) {
        long __functionAddress = GL45.getInstance().GetTextureParameterIiv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL45.nglGetTextureParameterIiv(texture, pname, params, __functionAddress);
    }

    public static void glGetTextureParameterIiv(int texture, int pname, ByteBuffer params) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)params, 4);
        }
        GL45.nglGetTextureParameterIiv(texture, pname, MemoryUtil.memAddress(params));
    }

    public static void glGetTextureParameterIiv(int texture, int pname, IntBuffer params) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        GL45.nglGetTextureParameterIiv(texture, pname, MemoryUtil.memAddress(params));
    }

    public static int glGetTextureParameterIi(int texture, int pname) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int params = __buffer.intParam();
        GL45.nglGetTextureParameterIiv(texture, pname, __buffer.address(params));
        return __buffer.intValue(params);
    }

    public static native void nglGetTextureParameterIuiv(int var0, int var1, long var2, long var4);

    public static void nglGetTextureParameterIuiv(int texture, int pname, long params) {
        long __functionAddress = GL45.getInstance().GetTextureParameterIuiv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL45.nglGetTextureParameterIuiv(texture, pname, params, __functionAddress);
    }

    public static void glGetTextureParameterIuiv(int texture, int pname, ByteBuffer params) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)params, 4);
        }
        GL45.nglGetTextureParameterIuiv(texture, pname, MemoryUtil.memAddress(params));
    }

    public static void glGetTextureParameterIuiv(int texture, int pname, IntBuffer params) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        GL45.nglGetTextureParameterIuiv(texture, pname, MemoryUtil.memAddress(params));
    }

    public static int glGetTextureParameterIui(int texture, int pname) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int params = __buffer.intParam();
        GL45.nglGetTextureParameterIuiv(texture, pname, __buffer.address(params));
        return __buffer.intValue(params);
    }

    public static native void nglGetTextureParameteriv(int var0, int var1, long var2, long var4);

    public static void nglGetTextureParameteriv(int texture, int pname, long params) {
        long __functionAddress = GL45.getInstance().GetTextureParameteriv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL45.nglGetTextureParameteriv(texture, pname, params, __functionAddress);
    }

    public static void glGetTextureParameteriv(int texture, int pname, ByteBuffer params) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)params, 4);
        }
        GL45.nglGetTextureParameteriv(texture, pname, MemoryUtil.memAddress(params));
    }

    public static void glGetTextureParameteriv(int texture, int pname, IntBuffer params) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        GL45.nglGetTextureParameteriv(texture, pname, MemoryUtil.memAddress(params));
    }

    public static int glGetTextureParameteri(int texture, int pname) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int params = __buffer.intParam();
        GL45.nglGetTextureParameteriv(texture, pname, __buffer.address(params));
        return __buffer.intValue(params);
    }

    public static native void nglCreateVertexArrays(int var0, long var1, long var3);

    public static void nglCreateVertexArrays(int n, long arrays) {
        long __functionAddress = GL45.getInstance().CreateVertexArrays;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL45.nglCreateVertexArrays(n, arrays, __functionAddress);
    }

    public static void glCreateVertexArrays(int n, ByteBuffer arrays) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)arrays, n << 2);
        }
        GL45.nglCreateVertexArrays(n, MemoryUtil.memAddress(arrays));
    }

    public static void glCreateVertexArrays(IntBuffer arrays) {
        GL45.nglCreateVertexArrays(arrays.remaining(), MemoryUtil.memAddress(arrays));
    }

    public static int glCreateVertexArrays() {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int arrays = __buffer.intParam();
        GL45.nglCreateVertexArrays(1, __buffer.address(arrays));
        return __buffer.intValue(arrays);
    }

    public static native void nglDisableVertexArrayAttrib(int var0, int var1, long var2);

    public static void glDisableVertexArrayAttrib(int vaobj, int index) {
        long __functionAddress = GL45.getInstance().DisableVertexArrayAttrib;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL45.nglDisableVertexArrayAttrib(vaobj, index, __functionAddress);
    }

    public static native void nglEnableVertexArrayAttrib(int var0, int var1, long var2);

    public static void glEnableVertexArrayAttrib(int vaobj, int index) {
        long __functionAddress = GL45.getInstance().EnableVertexArrayAttrib;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL45.nglEnableVertexArrayAttrib(vaobj, index, __functionAddress);
    }

    public static native void nglVertexArrayElementBuffer(int var0, int var1, long var2);

    public static void glVertexArrayElementBuffer(int vaobj, int buffer) {
        long __functionAddress = GL45.getInstance().VertexArrayElementBuffer;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL45.nglVertexArrayElementBuffer(vaobj, buffer, __functionAddress);
    }

    public static native void nglVertexArrayVertexBuffer(int var0, int var1, int var2, long var3, int var5, long var6);

    public static void glVertexArrayVertexBuffer(int vaobj, int bindingindex, int buffer, long offset, int stride) {
        long __functionAddress = GL45.getInstance().VertexArrayVertexBuffer;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL45.nglVertexArrayVertexBuffer(vaobj, bindingindex, buffer, offset, stride, __functionAddress);
    }

    public static native void nglVertexArrayVertexBuffers(int var0, int var1, int var2, long var3, long var5, long var7, long var9);

    public static void nglVertexArrayVertexBuffers(int vaobj, int first, int count, long buffers, long offsets, long strides) {
        long __functionAddress = GL45.getInstance().VertexArrayVertexBuffers;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL45.nglVertexArrayVertexBuffers(vaobj, first, count, buffers, offsets, strides, __functionAddress);
    }

    public static void glVertexArrayVertexBuffers(int vaobj, int first, int count, ByteBuffer buffers, ByteBuffer offsets, ByteBuffer strides) {
        if (LWJGLUtil.CHECKS) {
            if (buffers != null) {
                Checks.checkBuffer((Buffer)buffers, count << 2);
            }
            if (offsets != null) {
                Checks.checkBuffer((Buffer)offsets, count << Pointer.POINTER_SHIFT);
            }
            if (strides != null) {
                Checks.checkBuffer((Buffer)strides, count << 2);
            }
        }
        GL45.nglVertexArrayVertexBuffers(vaobj, first, count, MemoryUtil.memAddressSafe(buffers), MemoryUtil.memAddressSafe(offsets), MemoryUtil.memAddressSafe(strides));
    }

    public static void glVertexArrayVertexBuffers(int vaobj, int first, IntBuffer buffers, PointerBuffer offsets, IntBuffer strides) {
        if (LWJGLUtil.CHECKS) {
            if (offsets != null) {
                Checks.checkBuffer(offsets, buffers.remaining());
            }
            if (strides != null) {
                Checks.checkBuffer((Buffer)strides, buffers.remaining());
            }
        }
        GL45.nglVertexArrayVertexBuffers(vaobj, first, buffers == null ? 0 : buffers.remaining(), MemoryUtil.memAddressSafe(buffers), MemoryUtil.memAddressSafe(offsets), MemoryUtil.memAddressSafe(strides));
    }

    public static native void nglVertexArrayAttribFormat(int var0, int var1, int var2, int var3, boolean var4, int var5, long var6);

    public static void glVertexArrayAttribFormat(int vaobj, int attribindex, int size, int type, boolean normalized, int relativeoffset) {
        long __functionAddress = GL45.getInstance().VertexArrayAttribFormat;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL45.nglVertexArrayAttribFormat(vaobj, attribindex, size, type, normalized, relativeoffset, __functionAddress);
    }

    public static native void nglVertexArrayAttribIFormat(int var0, int var1, int var2, int var3, int var4, long var5);

    public static void glVertexArrayAttribIFormat(int vaobj, int attribindex, int size, int type, int relativeoffset) {
        long __functionAddress = GL45.getInstance().VertexArrayAttribIFormat;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL45.nglVertexArrayAttribIFormat(vaobj, attribindex, size, type, relativeoffset, __functionAddress);
    }

    public static native void nglVertexArrayAttribLFormat(int var0, int var1, int var2, int var3, int var4, long var5);

    public static void glVertexArrayAttribLFormat(int vaobj, int attribindex, int size, int type, int relativeoffset) {
        long __functionAddress = GL45.getInstance().VertexArrayAttribLFormat;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL45.nglVertexArrayAttribLFormat(vaobj, attribindex, size, type, relativeoffset, __functionAddress);
    }

    public static native void nglVertexArrayAttribBinding(int var0, int var1, int var2, long var3);

    public static void glVertexArrayAttribBinding(int vaobj, int attribindex, int bindingindex) {
        long __functionAddress = GL45.getInstance().VertexArrayAttribBinding;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL45.nglVertexArrayAttribBinding(vaobj, attribindex, bindingindex, __functionAddress);
    }

    public static native void nglVertexArrayBindingDivisor(int var0, int var1, int var2, long var3);

    public static void glVertexArrayBindingDivisor(int vaobj, int bindingindex, int divisor) {
        long __functionAddress = GL45.getInstance().VertexArrayBindingDivisor;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL45.nglVertexArrayBindingDivisor(vaobj, bindingindex, divisor, __functionAddress);
    }

    public static native void nglGetVertexArrayiv(int var0, int var1, long var2, long var4);

    public static void nglGetVertexArrayiv(int vaobj, int pname, long param) {
        long __functionAddress = GL45.getInstance().GetVertexArrayiv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL45.nglGetVertexArrayiv(vaobj, pname, param, __functionAddress);
    }

    public static void glGetVertexArrayiv(int vaobj, int pname, ByteBuffer param) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)param, 4);
        }
        GL45.nglGetVertexArrayiv(vaobj, pname, MemoryUtil.memAddress(param));
    }

    public static void glGetVertexArrayiv(int vaobj, int pname, IntBuffer param) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)param, 1);
        }
        GL45.nglGetVertexArrayiv(vaobj, pname, MemoryUtil.memAddress(param));
    }

    public static int glGetVertexArrayi(int vaobj, int pname) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int param = __buffer.intParam();
        GL45.nglGetVertexArrayiv(vaobj, pname, __buffer.address(param));
        return __buffer.intValue(param);
    }

    public static native void nglGetVertexArrayIndexediv(int var0, int var1, int var2, long var3, long var5);

    public static void nglGetVertexArrayIndexediv(int vaobj, int index, int pname, long param) {
        long __functionAddress = GL45.getInstance().GetVertexArrayIndexediv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL45.nglGetVertexArrayIndexediv(vaobj, index, pname, param, __functionAddress);
    }

    public static void glGetVertexArrayIndexediv(int vaobj, int index, int pname, ByteBuffer param) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)param, 4);
        }
        GL45.nglGetVertexArrayIndexediv(vaobj, index, pname, MemoryUtil.memAddress(param));
    }

    public static void glGetVertexArrayIndexediv(int vaobj, int index, int pname, IntBuffer param) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)param, 1);
        }
        GL45.nglGetVertexArrayIndexediv(vaobj, index, pname, MemoryUtil.memAddress(param));
    }

    public static int glGetVertexArrayIndexedi(int vaobj, int index, int pname) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int param = __buffer.intParam();
        GL45.nglGetVertexArrayIndexediv(vaobj, index, pname, __buffer.address(param));
        return __buffer.intValue(param);
    }

    public static native void nglGetVertexArrayIndexed64iv(int var0, int var1, int var2, long var3, long var5);

    public static void nglGetVertexArrayIndexed64iv(int vaobj, int index, int pname, long param) {
        long __functionAddress = GL45.getInstance().GetVertexArrayIndexed64iv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL45.nglGetVertexArrayIndexed64iv(vaobj, index, pname, param, __functionAddress);
    }

    public static void glGetVertexArrayIndexed64iv(int vaobj, int index, int pname, ByteBuffer param) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)param, 8);
        }
        GL45.nglGetVertexArrayIndexed64iv(vaobj, index, pname, MemoryUtil.memAddress(param));
    }

    public static void glGetVertexArrayIndexed64iv(int vaobj, int index, int pname, LongBuffer param) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)param, 1);
        }
        GL45.nglGetVertexArrayIndexed64iv(vaobj, index, pname, MemoryUtil.memAddress(param));
    }

    public static long glGetVertexArrayIndexed64i(int vaobj, int index, int pname) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int param = __buffer.longParam();
        GL45.nglGetVertexArrayIndexed64iv(vaobj, index, pname, __buffer.address(param));
        return __buffer.longValue(param);
    }

    public static native void nglCreateSamplers(int var0, long var1, long var3);

    public static void nglCreateSamplers(int n, long samplers) {
        long __functionAddress = GL45.getInstance().CreateSamplers;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL45.nglCreateSamplers(n, samplers, __functionAddress);
    }

    public static void glCreateSamplers(int n, ByteBuffer samplers) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)samplers, n << 2);
        }
        GL45.nglCreateSamplers(n, MemoryUtil.memAddress(samplers));
    }

    public static void glCreateSamplers(IntBuffer samplers) {
        GL45.nglCreateSamplers(samplers.remaining(), MemoryUtil.memAddress(samplers));
    }

    public static int glCreateSamplers() {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int samplers = __buffer.intParam();
        GL45.nglCreateSamplers(1, __buffer.address(samplers));
        return __buffer.intValue(samplers);
    }

    public static native void nglCreateProgramPipelines(int var0, long var1, long var3);

    public static void nglCreateProgramPipelines(int n, long pipelines) {
        long __functionAddress = GL45.getInstance().CreateProgramPipelines;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL45.nglCreateProgramPipelines(n, pipelines, __functionAddress);
    }

    public static void glCreateProgramPipelines(int n, ByteBuffer pipelines) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)pipelines, n << 2);
        }
        GL45.nglCreateProgramPipelines(n, MemoryUtil.memAddress(pipelines));
    }

    public static void glCreateProgramPipelines(IntBuffer pipelines) {
        GL45.nglCreateProgramPipelines(pipelines.remaining(), MemoryUtil.memAddress(pipelines));
    }

    public static int glCreateProgramPipelines() {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int pipelines = __buffer.intParam();
        GL45.nglCreateProgramPipelines(1, __buffer.address(pipelines));
        return __buffer.intValue(pipelines);
    }

    public static native void nglCreateQueries(int var0, int var1, long var2, long var4);

    public static void nglCreateQueries(int target, int n, long ids) {
        long __functionAddress = GL45.getInstance().CreateQueries;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL45.nglCreateQueries(target, n, ids, __functionAddress);
    }

    public static void glCreateQueries(int target, int n, ByteBuffer ids) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)ids, n << 2);
        }
        GL45.nglCreateQueries(target, n, MemoryUtil.memAddress(ids));
    }

    public static void glCreateQueries(int target, IntBuffer ids) {
        GL45.nglCreateQueries(target, ids.remaining(), MemoryUtil.memAddress(ids));
    }

    public static int glCreateQueries(int target) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int ids = __buffer.intParam();
        GL45.nglCreateQueries(target, 1, __buffer.address(ids));
        return __buffer.intValue(ids);
    }

    public static native void nglMemoryBarrierByRegion(int var0, long var1);

    public static void glMemoryBarrierByRegion(int barriers) {
        long __functionAddress = GL45.getInstance().MemoryBarrierByRegion;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL45.nglMemoryBarrierByRegion(barriers, __functionAddress);
    }

    public static native void nglGetTextureSubImage(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10, long var11, long var13);

    public static void nglGetTextureSubImage(int texture, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int type, int bufSize, long pixels) {
        long __functionAddress = GL45.getInstance().GetTextureSubImage;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL45.nglGetTextureSubImage(texture, level, xoffset, yoffset, zoffset, width, height, depth, format, type, bufSize, pixels, __functionAddress);
    }

    public static void glGetTextureSubImage(int texture, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int type, int bufSize, ByteBuffer pixels) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)pixels, bufSize);
            GLChecks.ensureBufferObject(35053, false);
        }
        GL45.nglGetTextureSubImage(texture, level, xoffset, yoffset, zoffset, width, height, depth, format, type, bufSize, MemoryUtil.memAddress(pixels));
    }

    public static void glGetTextureSubImage(int texture, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int type, int bufSize, long pixelsOffset) {
        if (LWJGLUtil.CHECKS) {
            GLChecks.ensureBufferObject(35053, true);
        }
        GL45.nglGetTextureSubImage(texture, level, xoffset, yoffset, zoffset, width, height, depth, format, type, bufSize, pixelsOffset);
    }

    public static void glGetTextureSubImage(int texture, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int type, ShortBuffer pixels) {
        if (LWJGLUtil.CHECKS) {
            GLChecks.ensureBufferObject(35053, false);
        }
        GL45.nglGetTextureSubImage(texture, level, xoffset, yoffset, zoffset, width, height, depth, format, type, pixels.remaining() << 1, MemoryUtil.memAddress(pixels));
    }

    public static void glGetTextureSubImage(int texture, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int type, IntBuffer pixels) {
        if (LWJGLUtil.CHECKS) {
            GLChecks.ensureBufferObject(35053, false);
        }
        GL45.nglGetTextureSubImage(texture, level, xoffset, yoffset, zoffset, width, height, depth, format, type, pixels.remaining() << 2, MemoryUtil.memAddress(pixels));
    }

    public static void glGetTextureSubImage(int texture, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int type, FloatBuffer pixels) {
        if (LWJGLUtil.CHECKS) {
            GLChecks.ensureBufferObject(35053, false);
        }
        GL45.nglGetTextureSubImage(texture, level, xoffset, yoffset, zoffset, width, height, depth, format, type, pixels.remaining() << 2, MemoryUtil.memAddress(pixels));
    }

    public static void glGetTextureSubImage(int texture, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int type, DoubleBuffer pixels) {
        if (LWJGLUtil.CHECKS) {
            GLChecks.ensureBufferObject(35053, false);
        }
        GL45.nglGetTextureSubImage(texture, level, xoffset, yoffset, zoffset, width, height, depth, format, type, pixels.remaining() << 3, MemoryUtil.memAddress(pixels));
    }

    public static native void nglGetCompressedTextureSubImage(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, long var9, long var11);

    public static void nglGetCompressedTextureSubImage(int texture, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int bufSize, long pixels) {
        long __functionAddress = GL45.getInstance().GetCompressedTextureSubImage;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL45.nglGetCompressedTextureSubImage(texture, level, xoffset, yoffset, zoffset, width, height, depth, bufSize, pixels, __functionAddress);
    }

    public static void glGetCompressedTextureSubImage(int texture, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int bufSize, ByteBuffer pixels) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)pixels, bufSize);
            GLChecks.ensureBufferObject(35053, false);
        }
        GL45.nglGetCompressedTextureSubImage(texture, level, xoffset, yoffset, zoffset, width, height, depth, bufSize, MemoryUtil.memAddress(pixels));
    }

    public static void glGetCompressedTextureSubImage(int texture, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int bufSize, long pixelsOffset) {
        if (LWJGLUtil.CHECKS) {
            GLChecks.ensureBufferObject(35053, true);
        }
        GL45.nglGetCompressedTextureSubImage(texture, level, xoffset, yoffset, zoffset, width, height, depth, bufSize, pixelsOffset);
    }

    public static void glGetCompressedTextureSubImage(int texture, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, ShortBuffer pixels) {
        if (LWJGLUtil.CHECKS) {
            GLChecks.ensureBufferObject(35053, false);
        }
        GL45.nglGetCompressedTextureSubImage(texture, level, xoffset, yoffset, zoffset, width, height, depth, pixels.remaining() << 1, MemoryUtil.memAddress(pixels));
    }

    public static void glGetCompressedTextureSubImage(int texture, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, IntBuffer pixels) {
        if (LWJGLUtil.CHECKS) {
            GLChecks.ensureBufferObject(35053, false);
        }
        GL45.nglGetCompressedTextureSubImage(texture, level, xoffset, yoffset, zoffset, width, height, depth, pixels.remaining() << 2, MemoryUtil.memAddress(pixels));
    }

    public static void glGetCompressedTextureSubImage(int texture, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, FloatBuffer pixels) {
        if (LWJGLUtil.CHECKS) {
            GLChecks.ensureBufferObject(35053, false);
        }
        GL45.nglGetCompressedTextureSubImage(texture, level, xoffset, yoffset, zoffset, width, height, depth, pixels.remaining() << 2, MemoryUtil.memAddress(pixels));
    }

    public static void glGetCompressedTextureSubImage(int texture, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, DoubleBuffer pixels) {
        if (LWJGLUtil.CHECKS) {
            GLChecks.ensureBufferObject(35053, false);
        }
        GL45.nglGetCompressedTextureSubImage(texture, level, xoffset, yoffset, zoffset, width, height, depth, pixels.remaining() << 3, MemoryUtil.memAddress(pixels));
    }

    public static native void nglTextureBarrier(long var0);

    public static void glTextureBarrier() {
        long __functionAddress = GL45.getInstance().TextureBarrier;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL45.nglTextureBarrier(__functionAddress);
    }

    public static native int nglGetGraphicsResetStatus(long var0);

    public static int glGetGraphicsResetStatus() {
        long __functionAddress = GL45.getInstance().GetGraphicsResetStatus;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        return GL45.nglGetGraphicsResetStatus(__functionAddress);
    }

    public static native void nglReadnPixels(int var0, int var1, int var2, int var3, int var4, int var5, int var6, long var7, long var9);

    public static void nglReadnPixels(int x, int y, int width, int height, int format, int type, int bufSize, long pixels) {
        long __functionAddress = GL45.getInstance().ReadnPixels;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL45.nglReadnPixels(x, y, width, height, format, type, bufSize, pixels, __functionAddress);
    }

    public static void glReadnPixels(int x, int y, int width, int height, int format, int type, int bufSize, ByteBuffer pixels) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)pixels, bufSize);
            GLChecks.ensureBufferObject(35053, false);
        }
        GL45.nglReadnPixels(x, y, width, height, format, type, bufSize, MemoryUtil.memAddress(pixels));
    }

    public static void glReadnPixels(int x, int y, int width, int height, int format, int type, int bufSize, long pixelsOffset) {
        if (LWJGLUtil.CHECKS) {
            GLChecks.ensureBufferObject(35053, true);
        }
        GL45.nglReadnPixels(x, y, width, height, format, type, bufSize, pixelsOffset);
    }

    public static void glReadnPixels(int x, int y, int width, int height, int format, int type, ShortBuffer pixels) {
        if (LWJGLUtil.CHECKS) {
            GLChecks.ensureBufferObject(35053, false);
        }
        GL45.nglReadnPixels(x, y, width, height, format, type, pixels.remaining() << 1, MemoryUtil.memAddress(pixels));
    }

    public static void glReadnPixels(int x, int y, int width, int height, int format, int type, IntBuffer pixels) {
        if (LWJGLUtil.CHECKS) {
            GLChecks.ensureBufferObject(35053, false);
        }
        GL45.nglReadnPixels(x, y, width, height, format, type, pixels.remaining() << 2, MemoryUtil.memAddress(pixels));
    }

    public static void glReadnPixels(int x, int y, int width, int height, int format, int type, FloatBuffer pixels) {
        if (LWJGLUtil.CHECKS) {
            GLChecks.ensureBufferObject(35053, false);
        }
        GL45.nglReadnPixels(x, y, width, height, format, type, pixels.remaining() << 2, MemoryUtil.memAddress(pixels));
    }

    public static native void nglGetnUniformfv(int var0, int var1, int var2, long var3, long var5);

    public static void nglGetnUniformfv(int program, int location, int bufSize, long params) {
        long __functionAddress = GL45.getInstance().GetnUniformfv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL45.nglGetnUniformfv(program, location, bufSize, params, __functionAddress);
    }

    public static void glGetnUniformfv(int program, int location, int bufSize, ByteBuffer params) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)params, bufSize << 2);
        }
        GL45.nglGetnUniformfv(program, location, bufSize, MemoryUtil.memAddress(params));
    }

    public static void glGetnUniformfv(int program, int location, FloatBuffer params) {
        GL45.nglGetnUniformfv(program, location, params.remaining(), MemoryUtil.memAddress(params));
    }

    public static native void nglGetnUniformiv(int var0, int var1, int var2, long var3, long var5);

    public static void nglGetnUniformiv(int program, int location, int bufSize, long params) {
        long __functionAddress = GL45.getInstance().GetnUniformiv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL45.nglGetnUniformiv(program, location, bufSize, params, __functionAddress);
    }

    public static void glGetnUniformiv(int program, int location, int bufSize, ByteBuffer params) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)params, bufSize << 2);
        }
        GL45.nglGetnUniformiv(program, location, bufSize, MemoryUtil.memAddress(params));
    }

    public static void glGetnUniformiv(int program, int location, FloatBuffer params) {
        GL45.nglGetnUniformiv(program, location, params.remaining(), MemoryUtil.memAddress(params));
    }

    public static native void nglGetnUniformuiv(int var0, int var1, int var2, long var3, long var5);

    public static void nglGetnUniformuiv(int program, int location, int bufSize, long params) {
        long __functionAddress = GL45.getInstance().GetnUniformuiv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL45.nglGetnUniformuiv(program, location, bufSize, params, __functionAddress);
    }

    public static void glGetnUniformuiv(int program, int location, int bufSize, ByteBuffer params) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)params, bufSize << 2);
        }
        GL45.nglGetnUniformuiv(program, location, bufSize, MemoryUtil.memAddress(params));
    }

    public static void glGetnUniformuiv(int program, int location, FloatBuffer params) {
        GL45.nglGetnUniformuiv(program, location, params.remaining(), MemoryUtil.memAddress(params));
    }
}

