/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.util.Set;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.Pointer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.opengl.GL;
import org.lwjgl.system.APIBuffer;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.MemoryUtil;

public final class GL15 {
    public static final int GL_FOG_COORD_SRC = 33872;
    public static final int GL_FOG_COORD = 33873;
    public static final int GL_CURRENT_FOG_COORD = 33875;
    public static final int GL_FOG_COORD_ARRAY_TYPE = 33876;
    public static final int GL_FOG_COORD_ARRAY_STRIDE = 33877;
    public static final int GL_FOG_COORD_ARRAY_POINTER = 33878;
    public static final int GL_FOG_COORD_ARRAY = 33879;
    public static final int GL_FOG_COORD_ARRAY_BUFFER_BINDING = 34973;
    public static final int GL_SRC0_RGB = 34176;
    public static final int GL_SRC1_RGB = 34177;
    public static final int GL_SRC2_RGB = 34178;
    public static final int GL_SRC0_ALPHA = 34184;
    public static final int GL_SRC1_ALPHA = 34185;
    public static final int GL_SRC2_ALPHA = 34186;
    public static final int GL_ARRAY_BUFFER = 34962;
    public static final int GL_ELEMENT_ARRAY_BUFFER = 34963;
    public static final int GL_ARRAY_BUFFER_BINDING = 34964;
    public static final int GL_ELEMENT_ARRAY_BUFFER_BINDING = 34965;
    public static final int GL_VERTEX_ARRAY_BUFFER_BINDING = 34966;
    public static final int GL_NORMAL_ARRAY_BUFFER_BINDING = 34967;
    public static final int GL_COLOR_ARRAY_BUFFER_BINDING = 34968;
    public static final int GL_INDEX_ARRAY_BUFFER_BINDING = 34969;
    public static final int GL_TEXTURE_COORD_ARRAY_BUFFER_BINDING = 34970;
    public static final int GL_EDGE_FLAG_ARRAY_BUFFER_BINDING = 34971;
    public static final int GL_SECONDARY_COLOR_ARRAY_BUFFER_BINDING = 34972;
    public static final int GL_FOG_COORDINATE_ARRAY_BUFFER_BINDING = 34973;
    public static final int GL_WEIGHT_ARRAY_BUFFER_BINDING = 34974;
    public static final int GL_VERTEX_ATTRIB_ARRAY_BUFFER_BINDING = 34975;
    public static final int GL_STREAM_DRAW = 35040;
    public static final int GL_STREAM_READ = 35041;
    public static final int GL_STREAM_COPY = 35042;
    public static final int GL_STATIC_DRAW = 35044;
    public static final int GL_STATIC_READ = 35045;
    public static final int GL_STATIC_COPY = 35046;
    public static final int GL_DYNAMIC_DRAW = 35048;
    public static final int GL_DYNAMIC_READ = 35049;
    public static final int GL_DYNAMIC_COPY = 35050;
    public static final int GL_READ_ONLY = 35000;
    public static final int GL_WRITE_ONLY = 35001;
    public static final int GL_READ_WRITE = 35002;
    public static final int GL_BUFFER_SIZE = 34660;
    public static final int GL_BUFFER_USAGE = 34661;
    public static final int GL_BUFFER_ACCESS = 35003;
    public static final int GL_BUFFER_MAPPED = 35004;
    public static final int GL_BUFFER_MAP_POINTER = 35005;
    public static final int GL_SAMPLES_PASSED = 35092;
    public static final int GL_QUERY_COUNTER_BITS = 34916;
    public static final int GL_CURRENT_QUERY = 34917;
    public static final int GL_QUERY_RESULT = 34918;
    public static final int GL_QUERY_RESULT_AVAILABLE = 34919;
    public final long BindBuffer;
    public final long DeleteBuffers;
    public final long GenBuffers;
    public final long IsBuffer;
    public final long BufferData;
    public final long BufferSubData;
    public final long GetBufferSubData;
    public final long MapBuffer;
    public final long UnmapBuffer;
    public final long GetBufferParameteriv;
    public final long GetBufferPointerv;
    public final long GenQueries;
    public final long DeleteQueries;
    public final long IsQuery;
    public final long BeginQuery;
    public final long EndQuery;
    public final long GetQueryiv;
    public final long GetQueryObjectiv;
    public final long GetQueryObjectuiv;

    public GL15(FunctionProvider provider) {
        this.BindBuffer = provider.getFunctionAddress("glBindBuffer");
        this.DeleteBuffers = provider.getFunctionAddress("glDeleteBuffers");
        this.GenBuffers = provider.getFunctionAddress("glGenBuffers");
        this.IsBuffer = provider.getFunctionAddress("glIsBuffer");
        this.BufferData = provider.getFunctionAddress("glBufferData");
        this.BufferSubData = provider.getFunctionAddress("glBufferSubData");
        this.GetBufferSubData = provider.getFunctionAddress("glGetBufferSubData");
        this.MapBuffer = provider.getFunctionAddress("glMapBuffer");
        this.UnmapBuffer = provider.getFunctionAddress("glUnmapBuffer");
        this.GetBufferParameteriv = provider.getFunctionAddress("glGetBufferParameteriv");
        this.GetBufferPointerv = provider.getFunctionAddress("glGetBufferPointerv");
        this.GenQueries = provider.getFunctionAddress("glGenQueries");
        this.DeleteQueries = provider.getFunctionAddress("glDeleteQueries");
        this.IsQuery = provider.getFunctionAddress("glIsQuery");
        this.BeginQuery = provider.getFunctionAddress("glBeginQuery");
        this.EndQuery = provider.getFunctionAddress("glEndQuery");
        this.GetQueryiv = provider.getFunctionAddress("glGetQueryiv");
        this.GetQueryObjectiv = provider.getFunctionAddress("glGetQueryObjectiv");
        this.GetQueryObjectuiv = provider.getFunctionAddress("glGetQueryObjectuiv");
    }

    public static GL15 getInstance() {
        return GL.getCapabilities().__GL15;
    }

    static GL15 create(Set<String> ext, FunctionProvider provider) {
        if (!ext.contains("OpenGL15")) {
            return null;
        }
        GL15 funcs = new GL15(provider);
        boolean supported = Checks.checkFunctions(funcs.BindBuffer, funcs.DeleteBuffers, funcs.GenBuffers, funcs.IsBuffer, funcs.BufferData, funcs.BufferSubData, funcs.GetBufferSubData, funcs.MapBuffer, funcs.UnmapBuffer, funcs.GetBufferParameteriv, funcs.GetBufferPointerv, funcs.GenQueries, funcs.DeleteQueries, funcs.IsQuery, funcs.BeginQuery, funcs.EndQuery, funcs.GetQueryiv, funcs.GetQueryObjectiv, funcs.GetQueryObjectuiv);
        return GL.checkExtension("OpenGL15", funcs, supported);
    }

    public static native void nglBindBuffer(int var0, int var1, long var2);

    public static void glBindBuffer(int target, int buffer) {
        long __functionAddress = GL15.getInstance().BindBuffer;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL15.nglBindBuffer(target, buffer, __functionAddress);
    }

    public static native void nglDeleteBuffers(int var0, long var1, long var3);

    public static void nglDeleteBuffers(int n, long buffers) {
        long __functionAddress = GL15.getInstance().DeleteBuffers;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL15.nglDeleteBuffers(n, buffers, __functionAddress);
    }

    public static void glDeleteBuffers(int n, ByteBuffer buffers) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)buffers, n << 2);
        }
        GL15.nglDeleteBuffers(n, MemoryUtil.memAddress(buffers));
    }

    public static void glDeleteBuffers(IntBuffer buffers) {
        GL15.nglDeleteBuffers(buffers.remaining(), MemoryUtil.memAddress(buffers));
    }

    public static void glDeleteBuffers(int buffer) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int buffers = __buffer.intParam(buffer);
        GL15.nglDeleteBuffers(1, __buffer.address(buffers));
    }

    public static native void nglGenBuffers(int var0, long var1, long var3);

    public static void nglGenBuffers(int n, long buffers) {
        long __functionAddress = GL15.getInstance().GenBuffers;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL15.nglGenBuffers(n, buffers, __functionAddress);
    }

    public static void glGenBuffers(int n, ByteBuffer buffers) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)buffers, n << 2);
        }
        GL15.nglGenBuffers(n, MemoryUtil.memAddress(buffers));
    }

    public static void glGenBuffers(IntBuffer buffers) {
        GL15.nglGenBuffers(buffers.remaining(), MemoryUtil.memAddress(buffers));
    }

    public static int glGenBuffers() {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int buffers = __buffer.intParam();
        GL15.nglGenBuffers(1, __buffer.address(buffers));
        return __buffer.intValue(buffers);
    }

    public static native boolean nglIsBuffer(int var0, long var1);

    public static boolean glIsBuffer(int buffer) {
        long __functionAddress = GL15.getInstance().IsBuffer;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        return GL15.nglIsBuffer(buffer, __functionAddress);
    }

    public static native void nglBufferData(int var0, long var1, long var3, int var5, long var6);

    public static void nglBufferData(int target, long size, long data, int usage) {
        long __functionAddress = GL15.getInstance().BufferData;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL15.nglBufferData(target, size, data, usage, __functionAddress);
    }

    public static void glBufferData(int target, long size, ByteBuffer data, int usage) {
        if (LWJGLUtil.CHECKS && data != null) {
            Checks.checkBuffer((Buffer)data, size);
        }
        GL15.nglBufferData(target, size, MemoryUtil.memAddressSafe(data), usage);
    }

    public static void glBufferData(int target, long size, int usage) {
        GL15.nglBufferData(target, size, 0L, usage);
    }

    public static void glBufferData(int target, ByteBuffer data, int usage) {
        GL15.nglBufferData(target, data.remaining(), MemoryUtil.memAddress(data), usage);
    }

    public static void glBufferData(int target, ShortBuffer data, int usage) {
        GL15.nglBufferData(target, data.remaining() << 1, MemoryUtil.memAddress(data), usage);
    }

    public static void glBufferData(int target, IntBuffer data, int usage) {
        GL15.nglBufferData(target, data.remaining() << 2, MemoryUtil.memAddress(data), usage);
    }

    public static void glBufferData(int target, FloatBuffer data, int usage) {
        GL15.nglBufferData(target, data.remaining() << 2, MemoryUtil.memAddress(data), usage);
    }

    public static void glBufferData(int target, DoubleBuffer data, int usage) {
        GL15.nglBufferData(target, data.remaining() << 3, MemoryUtil.memAddress(data), usage);
    }

    public static native void nglBufferSubData(int var0, long var1, long var3, long var5, long var7);

    public static void nglBufferSubData(int target, long offset, long size, long data) {
        long __functionAddress = GL15.getInstance().BufferSubData;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL15.nglBufferSubData(target, offset, size, data, __functionAddress);
    }

    public static void glBufferSubData(int target, long offset, long size, ByteBuffer data) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)data, size);
        }
        GL15.nglBufferSubData(target, offset, size, MemoryUtil.memAddress(data));
    }

    public static void glBufferSubData(int target, long offset, ByteBuffer data) {
        GL15.nglBufferSubData(target, offset, data.remaining(), MemoryUtil.memAddress(data));
    }

    public static void glBufferSubData(int target, long offset, ShortBuffer data) {
        GL15.nglBufferSubData(target, offset, data.remaining() << 1, MemoryUtil.memAddress(data));
    }

    public static void glBufferSubData(int target, long offset, IntBuffer data) {
        GL15.nglBufferSubData(target, offset, data.remaining() << 2, MemoryUtil.memAddress(data));
    }

    public static void glBufferSubData(int target, long offset, FloatBuffer data) {
        GL15.nglBufferSubData(target, offset, data.remaining() << 2, MemoryUtil.memAddress(data));
    }

    public static void glBufferSubData(int target, long offset, DoubleBuffer data) {
        GL15.nglBufferSubData(target, offset, data.remaining() << 3, MemoryUtil.memAddress(data));
    }

    public static native void nglGetBufferSubData(int var0, long var1, long var3, long var5, long var7);

    public static void nglGetBufferSubData(int target, long offset, long size, long data) {
        long __functionAddress = GL15.getInstance().GetBufferSubData;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL15.nglGetBufferSubData(target, offset, size, data, __functionAddress);
    }

    public static void glGetBufferSubData(int target, long offset, long size, ByteBuffer data) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)data, size);
        }
        GL15.nglGetBufferSubData(target, offset, size, MemoryUtil.memAddress(data));
    }

    public static void glGetBufferSubData(int target, long offset, ByteBuffer data) {
        GL15.nglGetBufferSubData(target, offset, data.remaining(), MemoryUtil.memAddress(data));
    }

    public static void glGetBufferSubData(int target, long offset, ShortBuffer data) {
        GL15.nglGetBufferSubData(target, offset, data.remaining() << 1, MemoryUtil.memAddress(data));
    }

    public static void glGetBufferSubData(int target, long offset, IntBuffer data) {
        GL15.nglGetBufferSubData(target, offset, data.remaining() << 2, MemoryUtil.memAddress(data));
    }

    public static void glGetBufferSubData(int target, long offset, FloatBuffer data) {
        GL15.nglGetBufferSubData(target, offset, data.remaining() << 2, MemoryUtil.memAddress(data));
    }

    public static void glGetBufferSubData(int target, long offset, DoubleBuffer data) {
        GL15.nglGetBufferSubData(target, offset, data.remaining() << 3, MemoryUtil.memAddress(data));
    }

    public static native long nglMapBuffer(int var0, int var1, long var2);

    public static long nglMapBuffer(int target, int access) {
        long __functionAddress = GL15.getInstance().MapBuffer;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        return GL15.nglMapBuffer(target, access, __functionAddress);
    }

    public static ByteBuffer glMapBuffer(int target, int access) {
        long __result = GL15.nglMapBuffer(target, access);
        return MemoryUtil.memByteBuffer(__result, GL15.glGetBufferParameteri(target, 34660));
    }

    public static ByteBuffer glMapBuffer(int target, int access, ByteBuffer old_buffer) {
        long __result = GL15.nglMapBuffer(target, access);
        int length = GL15.glGetBufferParameteri(target, 34660);
        return old_buffer != null && __result == MemoryUtil.memAddress0(old_buffer) && old_buffer.capacity() == length ? old_buffer : MemoryUtil.memByteBuffer(__result, length);
    }

    public static ByteBuffer glMapBuffer(int target, int access, long length, ByteBuffer old_buffer) {
        long __result = GL15.nglMapBuffer(target, access);
        return old_buffer != null && __result == MemoryUtil.memAddress0(old_buffer) && (long)old_buffer.capacity() == length ? old_buffer : MemoryUtil.memByteBuffer(__result, (int)length);
    }

    public static native boolean nglUnmapBuffer(int var0, long var1);

    public static boolean glUnmapBuffer(int target) {
        long __functionAddress = GL15.getInstance().UnmapBuffer;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        return GL15.nglUnmapBuffer(target, __functionAddress);
    }

    public static native void nglGetBufferParameteriv(int var0, int var1, long var2, long var4);

    public static void nglGetBufferParameteriv(int target, int pname, long params) {
        long __functionAddress = GL15.getInstance().GetBufferParameteriv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL15.nglGetBufferParameteriv(target, pname, params, __functionAddress);
    }

    public static void glGetBufferParameteriv(int target, int pname, ByteBuffer params) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)params, 4);
        }
        GL15.nglGetBufferParameteriv(target, pname, MemoryUtil.memAddress(params));
    }

    public static void glGetBufferParameteriv(int target, int pname, IntBuffer params) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        GL15.nglGetBufferParameteriv(target, pname, MemoryUtil.memAddress(params));
    }

    public static int glGetBufferParameteri(int target, int pname) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int params = __buffer.intParam();
        GL15.nglGetBufferParameteriv(target, pname, __buffer.address(params));
        return __buffer.intValue(params);
    }

    public static native void nglGetBufferPointerv(int var0, int var1, long var2, long var4);

    public static void nglGetBufferPointerv(int target, int pname, long params) {
        long __functionAddress = GL15.getInstance().GetBufferPointerv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL15.nglGetBufferPointerv(target, pname, params, __functionAddress);
    }

    public static void glGetBufferPointerv(int target, int pname, ByteBuffer params) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1 << Pointer.POINTER_SHIFT);
        }
        GL15.nglGetBufferPointerv(target, pname, MemoryUtil.memAddress(params));
    }

    public static void glGetBufferPointerv(int target, int pname, PointerBuffer params) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer(params, 1);
        }
        GL15.nglGetBufferPointerv(target, pname, MemoryUtil.memAddress(params));
    }

    public static long glGetBufferPointer(int target, int pname) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int params = __buffer.pointerParam();
        GL15.nglGetBufferPointerv(target, pname, __buffer.address(params));
        return __buffer.pointerValue(params);
    }

    public static native void nglGenQueries(int var0, long var1, long var3);

    public static void nglGenQueries(int n, long ids) {
        long __functionAddress = GL15.getInstance().GenQueries;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL15.nglGenQueries(n, ids, __functionAddress);
    }

    public static void glGenQueries(int n, ByteBuffer ids) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)ids, n << 2);
        }
        GL15.nglGenQueries(n, MemoryUtil.memAddress(ids));
    }

    public static void glGenQueries(IntBuffer ids) {
        GL15.nglGenQueries(ids.remaining(), MemoryUtil.memAddress(ids));
    }

    public static int glGenQueries() {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int ids = __buffer.intParam();
        GL15.nglGenQueries(1, __buffer.address(ids));
        return __buffer.intValue(ids);
    }

    public static native void nglDeleteQueries(int var0, long var1, long var3);

    public static void nglDeleteQueries(int n, long ids) {
        long __functionAddress = GL15.getInstance().DeleteQueries;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL15.nglDeleteQueries(n, ids, __functionAddress);
    }

    public static void glDeleteQueries(int n, ByteBuffer ids) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)ids, n << 2);
        }
        GL15.nglDeleteQueries(n, MemoryUtil.memAddress(ids));
    }

    public static void glDeleteQueries(IntBuffer ids) {
        GL15.nglDeleteQueries(ids.remaining(), MemoryUtil.memAddress(ids));
    }

    public static void glDeleteQueries(int id) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int ids = __buffer.intParam(id);
        GL15.nglDeleteQueries(1, __buffer.address(ids));
    }

    public static native boolean nglIsQuery(int var0, long var1);

    public static boolean glIsQuery(int id) {
        long __functionAddress = GL15.getInstance().IsQuery;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        return GL15.nglIsQuery(id, __functionAddress);
    }

    public static native void nglBeginQuery(int var0, int var1, long var2);

    public static void glBeginQuery(int target, int id) {
        long __functionAddress = GL15.getInstance().BeginQuery;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL15.nglBeginQuery(target, id, __functionAddress);
    }

    public static native void nglEndQuery(int var0, long var1);

    public static void glEndQuery(int target) {
        long __functionAddress = GL15.getInstance().EndQuery;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL15.nglEndQuery(target, __functionAddress);
    }

    public static native void nglGetQueryiv(int var0, int var1, long var2, long var4);

    public static void nglGetQueryiv(int target, int pname, long params) {
        long __functionAddress = GL15.getInstance().GetQueryiv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL15.nglGetQueryiv(target, pname, params, __functionAddress);
    }

    public static void glGetQueryiv(int target, int pname, ByteBuffer params) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)params, 4);
        }
        GL15.nglGetQueryiv(target, pname, MemoryUtil.memAddress(params));
    }

    public static void glGetQueryiv(int target, int pname, IntBuffer params) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        GL15.nglGetQueryiv(target, pname, MemoryUtil.memAddress(params));
    }

    public static int glGetQueryi(int target, int pname) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int params = __buffer.intParam();
        GL15.nglGetQueryiv(target, pname, __buffer.address(params));
        return __buffer.intValue(params);
    }

    public static native void nglGetQueryObjectiv(int var0, int var1, long var2, long var4);

    public static void nglGetQueryObjectiv(int id, int pname, long params) {
        long __functionAddress = GL15.getInstance().GetQueryObjectiv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL15.nglGetQueryObjectiv(id, pname, params, __functionAddress);
    }

    public static void glGetQueryObjectiv(int id, int pname, ByteBuffer params) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)params, 4);
        }
        GL15.nglGetQueryObjectiv(id, pname, MemoryUtil.memAddress(params));
    }

    public static void glGetQueryObjectiv(int id, int pname, IntBuffer params) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        GL15.nglGetQueryObjectiv(id, pname, MemoryUtil.memAddress(params));
    }

    public static int glGetQueryObjecti(int id, int pname) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int params = __buffer.intParam();
        GL15.nglGetQueryObjectiv(id, pname, __buffer.address(params));
        return __buffer.intValue(params);
    }

    public static native void nglGetQueryObjectuiv(int var0, int var1, long var2, long var4);

    public static void nglGetQueryObjectuiv(int id, int pname, long params) {
        long __functionAddress = GL15.getInstance().GetQueryObjectuiv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL15.nglGetQueryObjectuiv(id, pname, params, __functionAddress);
    }

    public static void glGetQueryObjectuiv(int id, int pname, ByteBuffer params) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)params, 4);
        }
        GL15.nglGetQueryObjectuiv(id, pname, MemoryUtil.memAddress(params));
    }

    public static void glGetQueryObjectuiv(int id, int pname, IntBuffer params) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        GL15.nglGetQueryObjectuiv(id, pname, MemoryUtil.memAddress(params));
    }

    public static int glGetQueryObjectui(int id, int pname) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int params = __buffer.intParam();
        GL15.nglGetQueryObjectuiv(id, pname, __buffer.address(params));
        return __buffer.intValue(params);
    }
}

