/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.util.Set;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL42;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;

public final class ARBTextureStorage {
    public static final int GL_TEXTURE_IMMUTABLE_FORMAT = 37167;
    public final long TexStorage1D;
    public final long TexStorage2D;
    public final long TexStorage3D;
    public final long TextureStorage1DEXT;
    public final long TextureStorage2DEXT;
    public final long TextureStorage3DEXT;

    public ARBTextureStorage(FunctionProvider provider) {
        this.TexStorage1D = provider.getFunctionAddress("glTexStorage1D");
        this.TexStorage2D = provider.getFunctionAddress("glTexStorage2D");
        this.TexStorage3D = provider.getFunctionAddress("glTexStorage3D");
        this.TextureStorage1DEXT = provider.getFunctionAddress("glTextureStorage1DEXT");
        this.TextureStorage2DEXT = provider.getFunctionAddress("glTextureStorage2DEXT");
        this.TextureStorage3DEXT = provider.getFunctionAddress("glTextureStorage3DEXT");
    }

    public static ARBTextureStorage getInstance() {
        return GL.getCapabilities().__ARBTextureStorage;
    }

    static ARBTextureStorage create(Set<String> ext, FunctionProvider provider) {
        if (!ext.contains("GL_ARB_texture_storage")) {
            return null;
        }
        ARBTextureStorage funcs = new ARBTextureStorage(provider);
        boolean supported = Checks.checkFunctions(funcs.TexStorage1D, funcs.TexStorage2D, funcs.TexStorage3D, ext.contains("GL_EXT_direct_state_access") ? funcs.TextureStorage1DEXT : -1L, ext.contains("GL_EXT_direct_state_access") ? funcs.TextureStorage2DEXT : -1L, ext.contains("GL_EXT_direct_state_access") ? funcs.TextureStorage3DEXT : -1L);
        return GL.checkExtension("GL_ARB_texture_storage", funcs, supported);
    }

    public static void glTexStorage1D(int target, int levels, int internalformat, int width) {
        long __functionAddress = ARBTextureStorage.getInstance().TexStorage1D;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL42.nglTexStorage1D(target, levels, internalformat, width, __functionAddress);
    }

    public static void glTexStorage2D(int target, int levels, int internalformat, int width, int height) {
        long __functionAddress = ARBTextureStorage.getInstance().TexStorage2D;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL42.nglTexStorage2D(target, levels, internalformat, width, height, __functionAddress);
    }

    public static void glTexStorage3D(int target, int levels, int internalformat, int width, int height, int depth) {
        long __functionAddress = ARBTextureStorage.getInstance().TexStorage3D;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL42.nglTexStorage3D(target, levels, internalformat, width, height, depth, __functionAddress);
    }

    public static native void nglTextureStorage1DEXT(int var0, int var1, int var2, int var3, int var4, long var5);

    public static void glTextureStorage1DEXT(int texture, int target, int levels, int internalformat, int width) {
        long __functionAddress = ARBTextureStorage.getInstance().TextureStorage1DEXT;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        ARBTextureStorage.nglTextureStorage1DEXT(texture, target, levels, internalformat, width, __functionAddress);
    }

    public static native void nglTextureStorage2DEXT(int var0, int var1, int var2, int var3, int var4, int var5, long var6);

    public static void glTextureStorage2DEXT(int texture, int target, int levels, int internalformat, int width, int height) {
        long __functionAddress = ARBTextureStorage.getInstance().TextureStorage2DEXT;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        ARBTextureStorage.nglTextureStorage2DEXT(texture, target, levels, internalformat, width, height, __functionAddress);
    }

    public static native void nglTextureStorage3DEXT(int var0, int var1, int var2, int var3, int var4, int var5, int var6, long var7);

    public static void glTextureStorage3DEXT(int texture, int target, int levels, int internalformat, int width, int height, int depth) {
        long __functionAddress = ARBTextureStorage.getInstance().TextureStorage3DEXT;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        ARBTextureStorage.nglTextureStorage3DEXT(texture, target, levels, internalformat, width, height, depth, __functionAddress);
    }
}

