/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.Set;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GLChecks;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.MemoryUtil;

public final class ARBIndirectParameters {
    public static final int GL_PARAMETER_BUFFER_ARB = 33006;
    public static final int GL_PARAMETER_BUFFER_BINDING_ARB = 33007;
    public final long MultiDrawArraysIndirectCountARB;
    public final long MultiDrawElementsIndirectCountARB;

    public ARBIndirectParameters(FunctionProvider provider) {
        this.MultiDrawArraysIndirectCountARB = provider.getFunctionAddress("glMultiDrawArraysIndirectCountARB");
        this.MultiDrawElementsIndirectCountARB = provider.getFunctionAddress("glMultiDrawElementsIndirectCountARB");
    }

    public static ARBIndirectParameters getInstance() {
        return GL.getCapabilities().__ARBIndirectParameters;
    }

    static ARBIndirectParameters create(Set<String> ext, FunctionProvider provider) {
        if (!ext.contains("GL_ARB_indirect_parameters")) {
            return null;
        }
        ARBIndirectParameters funcs = new ARBIndirectParameters(provider);
        boolean supported = Checks.checkFunctions(funcs.MultiDrawArraysIndirectCountARB, funcs.MultiDrawElementsIndirectCountARB);
        return GL.checkExtension("GL_ARB_indirect_parameters", funcs, supported);
    }

    public static native void nglMultiDrawArraysIndirectCountARB(int var0, long var1, long var3, int var5, int var6, long var7);

    public static void nglMultiDrawArraysIndirectCountARB(int mode, long indirect, long drawcount, int maxdrawcount, int stride) {
        long __functionAddress = ARBIndirectParameters.getInstance().MultiDrawArraysIndirectCountARB;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        ARBIndirectParameters.nglMultiDrawArraysIndirectCountARB(mode, indirect, drawcount, maxdrawcount, stride, __functionAddress);
    }

    public static void glMultiDrawArraysIndirectCountARB(int mode, ByteBuffer indirect, long drawcount, int maxdrawcount, int stride) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)indirect, maxdrawcount * (stride == 0 ? 16 : stride));
            GLChecks.ensureBufferObject(36675, false);
        }
        ARBIndirectParameters.nglMultiDrawArraysIndirectCountARB(mode, MemoryUtil.memAddress(indirect), drawcount, maxdrawcount, stride);
    }

    public static void glMultiDrawArraysIndirectCountARB(int mode, long indirectOffset, long drawcount, int maxdrawcount, int stride) {
        if (LWJGLUtil.CHECKS) {
            GLChecks.ensureBufferObject(36675, true);
        }
        ARBIndirectParameters.nglMultiDrawArraysIndirectCountARB(mode, indirectOffset, drawcount, maxdrawcount, stride);
    }

    public static void glMultiDrawArraysIndirectCountARB(int mode, IntBuffer indirect, long drawcount, int maxdrawcount, int stride) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)indirect, maxdrawcount * (stride == 0 ? 16 : stride) >> 2);
            GLChecks.ensureBufferObject(36675, false);
        }
        ARBIndirectParameters.nglMultiDrawArraysIndirectCountARB(mode, MemoryUtil.memAddress(indirect), drawcount, maxdrawcount, stride);
    }

    public static native void nglMultiDrawElementsIndirectCountARB(int var0, int var1, long var2, long var4, int var6, int var7, long var8);

    public static void nglMultiDrawElementsIndirectCountARB(int mode, int type, long indirect, long drawcount, int maxdrawcount, int stride) {
        long __functionAddress = ARBIndirectParameters.getInstance().MultiDrawElementsIndirectCountARB;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        ARBIndirectParameters.nglMultiDrawElementsIndirectCountARB(mode, type, indirect, drawcount, maxdrawcount, stride, __functionAddress);
    }

    public static void glMultiDrawElementsIndirectCountARB(int mode, int type, ByteBuffer indirect, long drawcount, int maxdrawcount, int stride) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)indirect, maxdrawcount * (stride == 0 ? 20 : stride));
            GLChecks.ensureBufferObject(36675, false);
        }
        ARBIndirectParameters.nglMultiDrawElementsIndirectCountARB(mode, type, MemoryUtil.memAddress(indirect), drawcount, maxdrawcount, stride);
    }

    public static void glMultiDrawElementsIndirectCountARB(int mode, int type, long indirectOffset, long drawcount, int maxdrawcount, int stride) {
        if (LWJGLUtil.CHECKS) {
            GLChecks.ensureBufferObject(36675, true);
        }
        ARBIndirectParameters.nglMultiDrawElementsIndirectCountARB(mode, type, indirectOffset, drawcount, maxdrawcount, stride);
    }

    public static void glMultiDrawElementsIndirectCountARB(int mode, int type, IntBuffer indirect, long drawcount, int maxdrawcount, int stride) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)indirect, maxdrawcount * (stride == 0 ? 20 : stride) >> 2);
            GLChecks.ensureBufferObject(36675, false);
        }
        ARBIndirectParameters.nglMultiDrawElementsIndirectCountARB(mode, type, MemoryUtil.memAddress(indirect), drawcount, maxdrawcount, stride);
    }
}

