/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.util.Set;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL43;
import org.lwjgl.opengl.GLChecks;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;

public final class ARBComputeShader {
    public static final int GL_COMPUTE_SHADER = 37305;
    public static final int GL_MAX_COMPUTE_UNIFORM_BLOCKS = 37307;
    public static final int GL_MAX_COMPUTE_TEXTURE_IMAGE_UNITS = 37308;
    public static final int GL_MAX_COMPUTE_IMAGE_UNIFORMS = 37309;
    public static final int GL_MAX_COMPUTE_SHARED_MEMORY_SIZE = 33378;
    public static final int GL_MAX_COMPUTE_UNIFORM_COMPONENTS = 33379;
    public static final int GL_MAX_COMPUTE_ATOMIC_COUNTER_BUFFERS = 33380;
    public static final int GL_MAX_COMPUTE_ATOMIC_COUNTERS = 33381;
    public static final int GL_MAX_COMBINED_COMPUTE_UNIFORM_COMPONENTS = 33382;
    public static final int GL_MAX_COMPUTE_WORK_GROUP_INVOCATIONS = 37099;
    public static final int GL_MAX_COMPUTE_WORK_GROUP_COUNT = 37310;
    public static final int GL_MAX_COMPUTE_WORK_GROUP_SIZE = 37311;
    public static final int GL_COMPUTE_WORK_GROUP_SIZE = 33383;
    public static final int GL_UNIFORM_BLOCK_REFERENCED_BY_COMPUTE_SHADER = 37100;
    public static final int GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_COMPUTE_SHADER = 37101;
    public static final int GL_DISPATCH_INDIRECT_BUFFER = 37102;
    public static final int GL_DISPATCH_INDIRECT_BUFFER_BINDING = 37103;
    public static final int GL_COMPUTE_SHADER_BIT = 32;
    public final long DispatchCompute;
    public final long DispatchComputeIndirect;

    public ARBComputeShader(FunctionProvider provider) {
        this.DispatchCompute = provider.getFunctionAddress("glDispatchCompute");
        this.DispatchComputeIndirect = provider.getFunctionAddress("glDispatchComputeIndirect");
    }

    public static ARBComputeShader getInstance() {
        return GL.getCapabilities().__ARBComputeShader;
    }

    static ARBComputeShader create(Set<String> ext, FunctionProvider provider) {
        if (!ext.contains("GL_ARB_compute_shader")) {
            return null;
        }
        ARBComputeShader funcs = new ARBComputeShader(provider);
        boolean supported = Checks.checkFunctions(funcs.DispatchCompute, funcs.DispatchComputeIndirect);
        return GL.checkExtension("GL_ARB_compute_shader", funcs, supported);
    }

    public static void glDispatchCompute(int num_groups_x, int num_groups_y, int num_groups_z) {
        long __functionAddress = ARBComputeShader.getInstance().DispatchCompute;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL43.nglDispatchCompute(num_groups_x, num_groups_y, num_groups_z, __functionAddress);
    }

    public static void glDispatchComputeIndirect(long indirect) {
        long __functionAddress = ARBComputeShader.getInstance().DispatchComputeIndirect;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            GLChecks.ensureBufferObject(37103, true);
        }
        GL43.nglDispatchComputeIndirect(indirect, __functionAddress);
    }
}

