/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opencl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.Pointer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.opencl.CL;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.MemoryUtil;

public final class INTELAccelerator {
    public static final int CL_ACCELERATOR_DESCRIPTOR_INTEL = 16528;
    public static final int CL_ACCELERATOR_REFERENCE_COUNT_INTEL = 16529;
    public static final int CL_ACCELERATOR_CONTEXT_INTEL = 16530;
    public static final int CL_ACCELERATOR_TYPE_INTEL = 16531;
    public static final int CL_INVALID_ACCELERATOR_INTEL = -1094;
    public static final int CL_INVALID_ACCELERATOR_TYPE_INTEL = -1095;
    public static final int CL_INVALID_ACCELERATOR_DESCRIPTOR_INTEL = -1096;
    public static final int CL_ACCELERATOR_TYPE_NOT_SUPPORTED_INTEL = -1097;
    public final long CreateAcceleratorINTEL;
    public final long RetainAcceleratorINTEL;
    public final long ReleaseAcceleratorINTEL;
    public final long GetAcceleratorInfoINTEL;

    public INTELAccelerator(FunctionProvider provider) {
        this.CreateAcceleratorINTEL = provider.getFunctionAddress("clCreateAcceleratorINTEL");
        this.RetainAcceleratorINTEL = provider.getFunctionAddress("clRetainAcceleratorINTEL");
        this.ReleaseAcceleratorINTEL = provider.getFunctionAddress("clReleaseAcceleratorINTEL");
        this.GetAcceleratorInfoINTEL = provider.getFunctionAddress("clGetAcceleratorInfoINTEL");
    }

    public static INTELAccelerator getInstance() {
        return CL.getICD().__INTELAccelerator;
    }

    static INTELAccelerator create(FunctionProvider provider) {
        INTELAccelerator funcs = new INTELAccelerator(provider);
        boolean supported = Checks.checkFunctions(funcs.CreateAcceleratorINTEL, funcs.RetainAcceleratorINTEL, funcs.ReleaseAcceleratorINTEL, funcs.GetAcceleratorInfoINTEL);
        return supported ? funcs : null;
    }

    public static native long nclCreateAcceleratorINTEL(long var0, int var2, long var3, long var5, long var7, long var9);

    public static long nclCreateAcceleratorINTEL(long context, int accelerator_type, long descriptor_size, long descriptor, long errcode_ret) {
        long __functionAddress = INTELAccelerator.getInstance().CreateAcceleratorINTEL;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(context);
        }
        return INTELAccelerator.nclCreateAcceleratorINTEL(context, accelerator_type, descriptor_size, descriptor, errcode_ret, __functionAddress);
    }

    public static long clCreateAcceleratorINTEL(long context, int accelerator_type, long descriptor_size, ByteBuffer descriptor, ByteBuffer errcode_ret) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)descriptor, descriptor_size);
            if (errcode_ret != null) {
                Checks.checkBuffer((Buffer)errcode_ret, 4);
            }
        }
        return INTELAccelerator.nclCreateAcceleratorINTEL(context, accelerator_type, descriptor_size, MemoryUtil.memAddress(descriptor), MemoryUtil.memAddressSafe(errcode_ret));
    }

    public static long clCreateAcceleratorINTEL(long context, int accelerator_type, ByteBuffer descriptor, IntBuffer errcode_ret) {
        if (LWJGLUtil.CHECKS && errcode_ret != null) {
            Checks.checkBuffer((Buffer)errcode_ret, 1);
        }
        return INTELAccelerator.nclCreateAcceleratorINTEL(context, accelerator_type, descriptor.remaining(), MemoryUtil.memAddress(descriptor), MemoryUtil.memAddressSafe(errcode_ret));
    }

    public static native int nclRetainAcceleratorINTEL(long var0, long var2);

    public static int clRetainAcceleratorINTEL(long accelerator) {
        long __functionAddress = INTELAccelerator.getInstance().RetainAcceleratorINTEL;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(accelerator);
        }
        return INTELAccelerator.nclRetainAcceleratorINTEL(accelerator, __functionAddress);
    }

    public static native int nclReleaseAcceleratorINTEL(long var0, long var2);

    public static int clReleaseAcceleratorINTEL(long accelerator) {
        long __functionAddress = INTELAccelerator.getInstance().ReleaseAcceleratorINTEL;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(accelerator);
        }
        return INTELAccelerator.nclReleaseAcceleratorINTEL(accelerator, __functionAddress);
    }

    public static native int nclGetAcceleratorInfoINTEL(long var0, int var2, long var3, long var5, long var7, long var9);

    public static int nclGetAcceleratorInfoINTEL(long accelerator, int param_name, long param_value_size, long param_value, long param_value_size_ret) {
        long __functionAddress = INTELAccelerator.getInstance().GetAcceleratorInfoINTEL;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(accelerator);
        }
        return INTELAccelerator.nclGetAcceleratorInfoINTEL(accelerator, param_name, param_value_size, param_value, param_value_size_ret, __functionAddress);
    }

    public static int clGetAcceleratorInfoINTEL(long accelerator, int param_name, long param_value_size, ByteBuffer param_value, ByteBuffer param_value_size_ret) {
        if (LWJGLUtil.CHECKS) {
            if (param_value != null) {
                Checks.checkBuffer((Buffer)param_value, param_value_size);
            }
            if (param_value_size_ret != null) {
                Checks.checkBuffer((Buffer)param_value_size_ret, 1 << Pointer.POINTER_SHIFT);
            }
        }
        return INTELAccelerator.nclGetAcceleratorInfoINTEL(accelerator, param_name, param_value_size, MemoryUtil.memAddressSafe(param_value), MemoryUtil.memAddressSafe(param_value_size_ret));
    }

    public static int clGetAcceleratorInfoINTEL(long accelerator, int param_name, long param_value_size, ByteBuffer param_value, PointerBuffer param_value_size_ret) {
        if (LWJGLUtil.CHECKS && param_value_size_ret != null) {
            Checks.checkBuffer(param_value_size_ret, 1);
        }
        return INTELAccelerator.nclGetAcceleratorInfoINTEL(accelerator, param_name, param_value_size, MemoryUtil.memAddressSafe(param_value), MemoryUtil.memAddressSafe(param_value_size_ret));
    }

    public static int clGetAcceleratorInfoINTEL(long accelerator, int param_name, IntBuffer param_value, PointerBuffer param_value_size_ret) {
        if (LWJGLUtil.CHECKS && param_value_size_ret != null) {
            Checks.checkBuffer(param_value_size_ret, 1);
        }
        return INTELAccelerator.nclGetAcceleratorInfoINTEL(accelerator, param_name, (param_value == null ? 0 : param_value.remaining()) << 2, MemoryUtil.memAddressSafe(param_value), MemoryUtil.memAddressSafe(param_value_size_ret));
    }

    public static int clGetAcceleratorInfoINTEL(long accelerator, int param_name, PointerBuffer param_value, PointerBuffer param_value_size_ret) {
        if (LWJGLUtil.CHECKS && param_value_size_ret != null) {
            Checks.checkBuffer(param_value_size_ret, 1);
        }
        return INTELAccelerator.nclGetAcceleratorInfoINTEL(accelerator, param_name, (param_value == null ? 0 : param_value.remaining()) << Pointer.POINTER_SHIFT, MemoryUtil.memAddressSafe(param_value), MemoryUtil.memAddressSafe(param_value_size_ret));
    }
}

