/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opencl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.Pointer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryUtil;

public final class CLMotionEstimationDescINTEL
implements Pointer {
    public static final int SIZEOF;
    public static final int MB_BLOCK_TYPE;
    public static final int SUBPIXEL_MODE;
    public static final int SAD_ADJUST_MODE;
    public static final int SEARCH_PATH_TYPE;
    private final ByteBuffer struct;

    public CLMotionEstimationDescINTEL() {
        this(CLMotionEstimationDescINTEL.malloc());
    }

    public CLMotionEstimationDescINTEL(ByteBuffer struct) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)struct, SIZEOF);
        }
        this.struct = struct;
    }

    public ByteBuffer buffer() {
        return this.struct;
    }

    @Override
    public long getPointer() {
        return MemoryUtil.memAddress(this.struct);
    }

    public void setMbBlockType(int mb_block_type) {
        CLMotionEstimationDescINTEL.mb_block_type(this.struct, mb_block_type);
    }

    public void setSubpixelMode(int subpixel_mode) {
        CLMotionEstimationDescINTEL.subpixel_mode(this.struct, subpixel_mode);
    }

    public void setSadAdjustMode(int sad_adjust_mode) {
        CLMotionEstimationDescINTEL.sad_adjust_mode(this.struct, sad_adjust_mode);
    }

    public void setSearchPathType(int search_path_type) {
        CLMotionEstimationDescINTEL.search_path_type(this.struct, search_path_type);
    }

    public int getMbBlockType() {
        return CLMotionEstimationDescINTEL.mb_block_type(this.struct);
    }

    public int getSubpixelMode() {
        return CLMotionEstimationDescINTEL.subpixel_mode(this.struct);
    }

    public int getSadAdjustMode() {
        return CLMotionEstimationDescINTEL.sad_adjust_mode(this.struct);
    }

    public int getSearchPathType() {
        return CLMotionEstimationDescINTEL.search_path_type(this.struct);
    }

    private static native int offsets(long var0);

    public static ByteBuffer malloc() {
        return BufferUtils.createByteBuffer(SIZEOF);
    }

    public static ByteBuffer malloc(int mb_block_type, int subpixel_mode, int sad_adjust_mode, int search_path_type) {
        ByteBuffer cl_motion_estimation_desc_intel = CLMotionEstimationDescINTEL.malloc();
        CLMotionEstimationDescINTEL.mb_block_type(cl_motion_estimation_desc_intel, mb_block_type);
        CLMotionEstimationDescINTEL.subpixel_mode(cl_motion_estimation_desc_intel, subpixel_mode);
        CLMotionEstimationDescINTEL.sad_adjust_mode(cl_motion_estimation_desc_intel, sad_adjust_mode);
        CLMotionEstimationDescINTEL.search_path_type(cl_motion_estimation_desc_intel, search_path_type);
        return cl_motion_estimation_desc_intel;
    }

    public static void mb_block_type(ByteBuffer cl_motion_estimation_desc_intel, int mb_block_type) {
        cl_motion_estimation_desc_intel.putInt(cl_motion_estimation_desc_intel.position() + MB_BLOCK_TYPE, mb_block_type);
    }

    public static void subpixel_mode(ByteBuffer cl_motion_estimation_desc_intel, int subpixel_mode) {
        cl_motion_estimation_desc_intel.putInt(cl_motion_estimation_desc_intel.position() + SUBPIXEL_MODE, subpixel_mode);
    }

    public static void sad_adjust_mode(ByteBuffer cl_motion_estimation_desc_intel, int sad_adjust_mode) {
        cl_motion_estimation_desc_intel.putInt(cl_motion_estimation_desc_intel.position() + SAD_ADJUST_MODE, sad_adjust_mode);
    }

    public static void search_path_type(ByteBuffer cl_motion_estimation_desc_intel, int search_path_type) {
        cl_motion_estimation_desc_intel.putInt(cl_motion_estimation_desc_intel.position() + SEARCH_PATH_TYPE, search_path_type);
    }

    public static int mb_block_type(ByteBuffer cl_motion_estimation_desc_intel) {
        return cl_motion_estimation_desc_intel.getInt(cl_motion_estimation_desc_intel.position() + MB_BLOCK_TYPE);
    }

    public static int subpixel_mode(ByteBuffer cl_motion_estimation_desc_intel) {
        return cl_motion_estimation_desc_intel.getInt(cl_motion_estimation_desc_intel.position() + SUBPIXEL_MODE);
    }

    public static int sad_adjust_mode(ByteBuffer cl_motion_estimation_desc_intel) {
        return cl_motion_estimation_desc_intel.getInt(cl_motion_estimation_desc_intel.position() + SAD_ADJUST_MODE);
    }

    public static int search_path_type(ByteBuffer cl_motion_estimation_desc_intel) {
        return cl_motion_estimation_desc_intel.getInt(cl_motion_estimation_desc_intel.position() + SEARCH_PATH_TYPE);
    }

    static {
        IntBuffer offsets = BufferUtils.createIntBuffer(4);
        SIZEOF = CLMotionEstimationDescINTEL.offsets(MemoryUtil.memAddress(offsets));
        MB_BLOCK_TYPE = offsets.get(0);
        SUBPIXEL_MODE = offsets.get(1);
        SAD_ADJUST_MODE = offsets.get(2);
        SEARCH_PATH_TYPE = offsets.get(3);
    }
}

