/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opencl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.Pointer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.opencl.CL;
import org.lwjgl.opencl.CLSVMFreeCallback;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.MemoryUtil;

public final class CL20 {
    public static final int CL_VERSION_2_0 = 1;
    public static final int CL_INVALID_PIPE_SIZE = -69;
    public static final int CL_INVALID_DEVICE_QUEUE = -70;
    public static final int CL_DEVICE_QUEUE_ON_HOST_PROPERTIES = 4138;
    public static final int CL_DEVICE_MAX_READ_WRITE_IMAGE_ARGS = 4172;
    public static final int CL_DEVICE_MAX_GLOBAL_VARIABLE_SIZE = 4173;
    public static final int CL_DEVICE_QUEUE_ON_DEVICE_PROPERTIES = 4174;
    public static final int CL_DEVICE_QUEUE_ON_DEVICE_PREFERRED_SIZE = 4175;
    public static final int CL_DEVICE_QUEUE_ON_DEVICE_MAX_SIZE = 4176;
    public static final int CL_DEVICE_MAX_ON_DEVICE_QUEUES = 4177;
    public static final int CL_DEVICE_MAX_ON_DEVICE_EVENTS = 4178;
    public static final int CL_DEVICE_SVM_CAPABILITIES = 4179;
    public static final int CL_DEVICE_GLOBAL_VARIABLE_PREFERRED_TOTAL_SIZE = 4180;
    public static final int CL_DEVICE_MAX_PIPE_ARGS = 4181;
    public static final int CL_DEVICE_PIPE_MAX_ACTIVE_RESERVATIONS = 4182;
    public static final int CL_DEVICE_PIPE_MAX_PACKET_SIZE = 4183;
    public static final int CL_DEVICE_PREFERRED_PLATFORM_ATOMIC_ALIGNMENT = 4184;
    public static final int CL_DEVICE_PREFERRED_GLOBAL_ATOMIC_ALIGNMENT = 4185;
    public static final int CL_DEVICE_PREFERRED_LOCAL_ATOMIC_ALIGNMENT = 4186;
    public static final int CL_QUEUE_ON_DEVICE = 4;
    public static final int CL_QUEUE_ON_DEVICE_DEFAULT = 8;
    public static final int CL_DEVICE_SVM_COARSE_GRAIN_BUFFER = 1;
    public static final int CL_DEVICE_SVM_FINE_GRAIN_BUFFER = 2;
    public static final int CL_DEVICE_SVM_FINE_GRAIN_SYSTEM = 4;
    public static final int CL_DEVICE_SVM_ATOMICS = 8;
    public static final int CL_QUEUE_SIZE = 4244;
    public static final int CL_MEM_SVM_FINE_GRAIN_BUFFER = 1024;
    public static final int CL_MEM_SVM_ATOMICS = 2048;
    public static final int CL_MEM_OBJECT_PIPE = 4343;
    public static final int CL_MEM_USES_SVM_POINTER = 4361;
    public static final int CL_sRGB = 4287;
    public static final int CL_sRGBx = 4288;
    public static final int CL_sRGBA = 4289;
    public static final int CL_sBGRA = 4290;
    public static final int CL_ABGR = 4291;
    public static final int CL_PIPE_PACKET_SIZE = 4384;
    public static final int CL_PIPE_MAX_PACKETS = 4385;
    public static final int CL_SAMPLER_MIP_FILTER_MODE = 4437;
    public static final int CL_SAMPLER_LOD_MIN = 4438;
    public static final int CL_SAMPLER_LOD_MAX = 4439;
    public static final int CL_PROGRAM_BUILD_GLOBAL_VARIABLE_TOTAL_SIZE = 4485;
    public static final int CL_KERNEL_ARG_TYPE_PIPE = 8;
    public static final int CL_KERNEL_EXEC_INFO_SVM_PTRS = 4534;
    public static final int CL_KERNEL_EXEC_INFO_SVM_FINE_GRAIN_SYSTEM = 4535;
    public static final int CL_COMMAND_SVM_FREE = 4617;
    public static final int CL_COMMAND_SVM_MEMCPY = 4618;
    public static final int CL_COMMAND_SVM_MEMFILL = 4619;
    public static final int CL_COMMAND_SVM_MAP = 4620;
    public static final int CL_COMMAND_SVM_UNMAP = 4621;
    public static final int CL_PROFILING_COMMAND_COMPLETE = 4740;
    public final long CreateCommandQueueWithProperties;
    public final long CreatePipe;
    public final long GetPipeInfo;
    public final long SVMAlloc;
    public final long SVMFree;
    public final long EnqueueSVMFree;
    public final long EnqueueSVMMemcpy;
    public final long EnqueueSVMMemFill;
    public final long EnqueueSVMMap;
    public final long EnqueueSVMUnmap;
    public final long SetKernelArgSVMPointer;
    public final long SetKernelExecInfo;
    public final long CreateSamplerWithProperties;

    public CL20(FunctionProvider provider) {
        this.CreateCommandQueueWithProperties = provider.getFunctionAddress("clCreateCommandQueueWithProperties");
        this.CreatePipe = provider.getFunctionAddress("clCreatePipe");
        this.GetPipeInfo = provider.getFunctionAddress("clGetPipeInfo");
        this.SVMAlloc = provider.getFunctionAddress("clSVMAlloc");
        this.SVMFree = provider.getFunctionAddress("clSVMFree");
        this.EnqueueSVMFree = provider.getFunctionAddress("clEnqueueSVMFree");
        this.EnqueueSVMMemcpy = provider.getFunctionAddress("clEnqueueSVMMemcpy");
        this.EnqueueSVMMemFill = provider.getFunctionAddress("clEnqueueSVMMemFill");
        this.EnqueueSVMMap = provider.getFunctionAddress("clEnqueueSVMMap");
        this.EnqueueSVMUnmap = provider.getFunctionAddress("clEnqueueSVMUnmap");
        this.SetKernelArgSVMPointer = provider.getFunctionAddress("clSetKernelArgSVMPointer");
        this.SetKernelExecInfo = provider.getFunctionAddress("clSetKernelExecInfo");
        this.CreateSamplerWithProperties = provider.getFunctionAddress("clCreateSamplerWithProperties");
    }

    public static CL20 getInstance() {
        return CL.getICD().__CL20;
    }

    static CL20 create(FunctionProvider provider) {
        CL20 funcs = new CL20(provider);
        boolean supported = Checks.checkFunctions(funcs.CreateCommandQueueWithProperties, funcs.CreatePipe, funcs.GetPipeInfo, funcs.SVMAlloc, funcs.SVMFree, funcs.EnqueueSVMFree, funcs.EnqueueSVMMemcpy, funcs.EnqueueSVMMemFill, funcs.EnqueueSVMMap, funcs.EnqueueSVMUnmap, funcs.SetKernelArgSVMPointer, funcs.SetKernelExecInfo, funcs.CreateSamplerWithProperties);
        return supported ? funcs : null;
    }

    public static native long nclCreateCommandQueueWithProperties(long var0, long var2, long var4, long var6, long var8);

    public static long nclCreateCommandQueueWithProperties(long context, long device, long properties, long errcode_ret) {
        long __functionAddress = CL20.getInstance().CreateCommandQueueWithProperties;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(context);
            Checks.checkPointer(device);
        }
        return CL20.nclCreateCommandQueueWithProperties(context, device, properties, errcode_ret, __functionAddress);
    }

    public static long clCreateCommandQueueWithProperties(long context, long device, ByteBuffer properties, ByteBuffer errcode_ret) {
        if (LWJGLUtil.CHECKS && errcode_ret != null) {
            Checks.checkBuffer((Buffer)errcode_ret, 4);
        }
        return CL20.nclCreateCommandQueueWithProperties(context, device, MemoryUtil.memAddress(properties), MemoryUtil.memAddressSafe(errcode_ret));
    }

    public static long clCreateCommandQueueWithProperties(long context, long device, LongBuffer properties, IntBuffer errcode_ret) {
        if (LWJGLUtil.CHECKS && errcode_ret != null) {
            Checks.checkBuffer((Buffer)errcode_ret, 1);
        }
        return CL20.nclCreateCommandQueueWithProperties(context, device, MemoryUtil.memAddress(properties), MemoryUtil.memAddressSafe(errcode_ret));
    }

    public static native long nclCreatePipe(long var0, long var2, int var4, int var5, long var6, long var8, long var10);

    public static long nclCreatePipe(long context, long flags, int pipe_packet_size, int pipe_max_packets, long properties, long errcode_ret) {
        long __functionAddress = CL20.getInstance().CreatePipe;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(context);
        }
        return CL20.nclCreatePipe(context, flags, pipe_packet_size, pipe_max_packets, properties, errcode_ret, __functionAddress);
    }

    public static long clCreatePipe(long context, long flags, int pipe_packet_size, int pipe_max_packets, ByteBuffer properties, ByteBuffer errcode_ret) {
        if (LWJGLUtil.CHECKS && errcode_ret != null) {
            Checks.checkBuffer((Buffer)errcode_ret, 4);
        }
        return CL20.nclCreatePipe(context, flags, pipe_packet_size, pipe_max_packets, MemoryUtil.memAddress(properties), MemoryUtil.memAddressSafe(errcode_ret));
    }

    public static long clCreatePipe(long context, long flags, int pipe_packet_size, int pipe_max_packets, IntBuffer properties, IntBuffer errcode_ret) {
        if (LWJGLUtil.CHECKS && errcode_ret != null) {
            Checks.checkBuffer((Buffer)errcode_ret, 1);
        }
        return CL20.nclCreatePipe(context, flags, pipe_packet_size, pipe_max_packets, MemoryUtil.memAddress(properties), MemoryUtil.memAddressSafe(errcode_ret));
    }

    public static native int nclGetPipeInfo(long var0, int var2, long var3, long var5, long var7, long var9);

    public static int nclGetPipeInfo(long pipe, int param_name, long param_value_size, long param_value, long param_value_size_ret) {
        long __functionAddress = CL20.getInstance().GetPipeInfo;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(pipe);
        }
        return CL20.nclGetPipeInfo(pipe, param_name, param_value_size, param_value, param_value_size_ret, __functionAddress);
    }

    public static int clGetPipeInfo(long pipe, int param_name, long param_value_size, ByteBuffer param_value, ByteBuffer param_value_size_ret) {
        if (LWJGLUtil.CHECKS) {
            if (param_value != null) {
                Checks.checkBuffer((Buffer)param_value, param_value_size);
            }
            if (param_value_size_ret != null) {
                Checks.checkBuffer((Buffer)param_value_size_ret, 1 << Pointer.POINTER_SHIFT);
            }
        }
        return CL20.nclGetPipeInfo(pipe, param_name, param_value_size, MemoryUtil.memAddressSafe(param_value), MemoryUtil.memAddressSafe(param_value_size_ret));
    }

    public static int clGetPipeInfo(long pipe, int param_name, long param_value_size, ByteBuffer param_value, PointerBuffer param_value_size_ret) {
        if (LWJGLUtil.CHECKS && param_value_size_ret != null) {
            Checks.checkBuffer(param_value_size_ret, 1);
        }
        return CL20.nclGetPipeInfo(pipe, param_name, param_value_size, MemoryUtil.memAddressSafe(param_value), MemoryUtil.memAddressSafe(param_value_size_ret));
    }

    public static int clGetPipeInfo(long pipe, int param_name, IntBuffer param_value, PointerBuffer param_value_size_ret) {
        if (LWJGLUtil.CHECKS && param_value_size_ret != null) {
            Checks.checkBuffer(param_value_size_ret, 1);
        }
        return CL20.nclGetPipeInfo(pipe, param_name, (param_value == null ? 0 : param_value.remaining()) << 2, MemoryUtil.memAddressSafe(param_value), MemoryUtil.memAddressSafe(param_value_size_ret));
    }

    public static native long nclSVMAlloc(long var0, long var2, long var4, int var6, long var7);

    public static long nclSVMAlloc(long context, long flags, long size, int alignment) {
        long __functionAddress = CL20.getInstance().SVMAlloc;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(context);
        }
        return CL20.nclSVMAlloc(context, flags, size, alignment, __functionAddress);
    }

    public static ByteBuffer clSVMAlloc(long context, long flags, long size, int alignment) {
        long __result = CL20.nclSVMAlloc(context, flags, size, alignment);
        return MemoryUtil.memByteBuffer(__result, (int)size);
    }

    public static native void nclSVMFree(long var0, long var2, long var4);

    public static void nclSVMFree(long context, long svm_pointer) {
        long __functionAddress = CL20.getInstance().SVMFree;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(context);
        }
        CL20.nclSVMFree(context, svm_pointer, __functionAddress);
    }

    public static void clSVMFree(long context, ByteBuffer svm_pointer) {
        CL20.nclSVMFree(context, MemoryUtil.memAddress(svm_pointer));
    }

    public static native int nclEnqueueSVMFree(long var0, int var2, long var3, long var5, long var7, int var9, long var10, long var12, long var14);

    public static int nclEnqueueSVMFree(long command_queue, int num_svm_pointers, long svm_pointers, long pfn_free_func, long user_data, int num_events_in_wait_list, long event_wait_list, long event) {
        long __functionAddress = CL20.getInstance().EnqueueSVMFree;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(command_queue);
        }
        return CL20.nclEnqueueSVMFree(command_queue, num_svm_pointers, svm_pointers, pfn_free_func, user_data, num_events_in_wait_list, event_wait_list, event, __functionAddress);
    }

    public static int clEnqueueSVMFree(long command_queue, int num_svm_pointers, ByteBuffer svm_pointers, CLSVMFreeCallback pfn_free_func, ByteBuffer user_data, int num_events_in_wait_list, ByteBuffer event_wait_list, ByteBuffer event) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)svm_pointers, num_svm_pointers << Pointer.POINTER_SHIFT);
            if (event_wait_list != null) {
                Checks.checkBuffer((Buffer)event_wait_list, num_events_in_wait_list << Pointer.POINTER_SHIFT);
            }
            if (event != null) {
                Checks.checkBuffer((Buffer)event, 1 << Pointer.POINTER_SHIFT);
            }
        }
        return CL20.nclEnqueueSVMFree(command_queue, num_svm_pointers, MemoryUtil.memAddress(svm_pointers), pfn_free_func == null ? 0L : pfn_free_func.getPointer(), MemoryUtil.memAddressSafe(user_data), num_events_in_wait_list, MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event));
    }

    public static int clEnqueueSVMFree(long command_queue, PointerBuffer svm_pointers, CLSVMFreeCallback pfn_free_func, ByteBuffer user_data, PointerBuffer event_wait_list, PointerBuffer event) {
        if (LWJGLUtil.CHECKS && event != null) {
            Checks.checkBuffer(event, 1);
        }
        return CL20.nclEnqueueSVMFree(command_queue, svm_pointers.remaining(), MemoryUtil.memAddress(svm_pointers), pfn_free_func == null ? 0L : pfn_free_func.getPointer(), MemoryUtil.memAddressSafe(user_data), event_wait_list == null ? 0 : event_wait_list.remaining(), MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event));
    }

    public static native int nclEnqueueSVMMemcpy(long var0, int var2, long var3, long var5, long var7, int var9, long var10, long var12, long var14);

    public static int nclEnqueueSVMMemcpy(long command_queue, int blocking_copy, long dst_ptr, long src_ptr, long size, int num_events_in_wait_list, long event_wait_list, long event) {
        long __functionAddress = CL20.getInstance().EnqueueSVMMemcpy;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(command_queue);
        }
        return CL20.nclEnqueueSVMMemcpy(command_queue, blocking_copy, dst_ptr, src_ptr, size, num_events_in_wait_list, event_wait_list, event, __functionAddress);
    }

    public static int clEnqueueSVMMemcpy(long command_queue, int blocking_copy, ByteBuffer dst_ptr, ByteBuffer src_ptr, long size, int num_events_in_wait_list, ByteBuffer event_wait_list, ByteBuffer event) {
        if (LWJGLUtil.CHECKS) {
            if (event_wait_list != null) {
                Checks.checkBuffer((Buffer)event_wait_list, num_events_in_wait_list << Pointer.POINTER_SHIFT);
            }
            if (event != null) {
                Checks.checkBuffer((Buffer)event, 1 << Pointer.POINTER_SHIFT);
            }
        }
        return CL20.nclEnqueueSVMMemcpy(command_queue, blocking_copy, MemoryUtil.memAddress(dst_ptr), MemoryUtil.memAddress(src_ptr), size, num_events_in_wait_list, MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event));
    }

    public static int clEnqueueSVMMemcpy(long command_queue, int blocking_copy, ByteBuffer dst_ptr, ByteBuffer src_ptr, long size, PointerBuffer event_wait_list, PointerBuffer event) {
        if (LWJGLUtil.CHECKS && event != null) {
            Checks.checkBuffer(event, 1);
        }
        return CL20.nclEnqueueSVMMemcpy(command_queue, blocking_copy, MemoryUtil.memAddress(dst_ptr), MemoryUtil.memAddress(src_ptr), size, event_wait_list == null ? 0 : event_wait_list.remaining(), MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event));
    }

    public static native int nclEnqueueSVMMemFill(long var0, long var2, long var4, long var6, long var8, int var10, long var11, long var13, long var15);

    public static int nclEnqueueSVMMemFill(long command_queue, long svm_ptr, long pattern, long pattern_size, long size, int num_events_in_wait_list, long event_wait_list, long event) {
        long __functionAddress = CL20.getInstance().EnqueueSVMMemFill;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(command_queue);
        }
        return CL20.nclEnqueueSVMMemFill(command_queue, svm_ptr, pattern, pattern_size, size, num_events_in_wait_list, event_wait_list, event, __functionAddress);
    }

    public static int clEnqueueSVMMemFill(long command_queue, ByteBuffer svm_ptr, ByteBuffer pattern, long pattern_size, long size, int num_events_in_wait_list, ByteBuffer event_wait_list, ByteBuffer event) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)pattern, pattern_size);
            if (event_wait_list != null) {
                Checks.checkBuffer((Buffer)event_wait_list, num_events_in_wait_list << Pointer.POINTER_SHIFT);
            }
            if (event != null) {
                Checks.checkBuffer((Buffer)event, 1 << Pointer.POINTER_SHIFT);
            }
        }
        return CL20.nclEnqueueSVMMemFill(command_queue, MemoryUtil.memAddress(svm_ptr), MemoryUtil.memAddress(pattern), pattern_size, size, num_events_in_wait_list, MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event));
    }

    public static int clEnqueueSVMMemFill(long command_queue, ByteBuffer svm_ptr, ByteBuffer pattern, long size, PointerBuffer event_wait_list, PointerBuffer event) {
        if (LWJGLUtil.CHECKS && event != null) {
            Checks.checkBuffer(event, 1);
        }
        return CL20.nclEnqueueSVMMemFill(command_queue, MemoryUtil.memAddress(svm_ptr), MemoryUtil.memAddress(pattern), pattern.remaining(), size, event_wait_list == null ? 0 : event_wait_list.remaining(), MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event));
    }

    public static native int nclEnqueueSVMMap(long var0, int var2, long var3, long var5, long var7, int var9, long var10, long var12, long var14);

    public static int nclEnqueueSVMMap(long command_queue, int blocking_map, long map_flags, long svm_ptr, long size, int num_events_in_wait_list, long event_wait_list, long event) {
        long __functionAddress = CL20.getInstance().EnqueueSVMMap;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(command_queue);
        }
        return CL20.nclEnqueueSVMMap(command_queue, blocking_map, map_flags, svm_ptr, size, num_events_in_wait_list, event_wait_list, event, __functionAddress);
    }

    public static int clEnqueueSVMMap(long command_queue, int blocking_map, long map_flags, ByteBuffer svm_ptr, long size, int num_events_in_wait_list, ByteBuffer event_wait_list, ByteBuffer event) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)svm_ptr, size);
            if (event_wait_list != null) {
                Checks.checkBuffer((Buffer)event_wait_list, num_events_in_wait_list << Pointer.POINTER_SHIFT);
            }
            if (event != null) {
                Checks.checkBuffer((Buffer)event, 1 << Pointer.POINTER_SHIFT);
            }
        }
        return CL20.nclEnqueueSVMMap(command_queue, blocking_map, map_flags, MemoryUtil.memAddress(svm_ptr), size, num_events_in_wait_list, MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event));
    }

    public static int clEnqueueSVMMap(long command_queue, int blocking_map, long map_flags, ByteBuffer svm_ptr, PointerBuffer event_wait_list, PointerBuffer event) {
        if (LWJGLUtil.CHECKS && event != null) {
            Checks.checkBuffer(event, 1);
        }
        return CL20.nclEnqueueSVMMap(command_queue, blocking_map, map_flags, MemoryUtil.memAddress(svm_ptr), svm_ptr.remaining(), event_wait_list == null ? 0 : event_wait_list.remaining(), MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event));
    }

    public static native int nclEnqueueSVMUnmap(long var0, long var2, int var4, long var5, long var7, long var9);

    public static int nclEnqueueSVMUnmap(long command_queue, long svm_ptr, int num_events_in_wait_list, long event_wait_list, long event) {
        long __functionAddress = CL20.getInstance().EnqueueSVMUnmap;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(command_queue);
        }
        return CL20.nclEnqueueSVMUnmap(command_queue, svm_ptr, num_events_in_wait_list, event_wait_list, event, __functionAddress);
    }

    public static int clEnqueueSVMUnmap(long command_queue, ByteBuffer svm_ptr, int num_events_in_wait_list, ByteBuffer event_wait_list, ByteBuffer event) {
        if (LWJGLUtil.CHECKS) {
            if (event_wait_list != null) {
                Checks.checkBuffer((Buffer)event_wait_list, num_events_in_wait_list << Pointer.POINTER_SHIFT);
            }
            if (event != null) {
                Checks.checkBuffer((Buffer)event, 1 << Pointer.POINTER_SHIFT);
            }
        }
        return CL20.nclEnqueueSVMUnmap(command_queue, MemoryUtil.memAddress(svm_ptr), num_events_in_wait_list, MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event));
    }

    public static int clEnqueueSVMUnmap(long command_queue, ByteBuffer svm_ptr, PointerBuffer event_wait_list, PointerBuffer event) {
        if (LWJGLUtil.CHECKS && event != null) {
            Checks.checkBuffer(event, 1);
        }
        return CL20.nclEnqueueSVMUnmap(command_queue, MemoryUtil.memAddress(svm_ptr), event_wait_list == null ? 0 : event_wait_list.remaining(), MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event));
    }

    public static native int nclSetKernelArgSVMPointer(long var0, int var2, long var3, long var5);

    public static int nclSetKernelArgSVMPointer(long kernel, int arg_index, long arg_value) {
        long __functionAddress = CL20.getInstance().SetKernelArgSVMPointer;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(kernel);
        }
        return CL20.nclSetKernelArgSVMPointer(kernel, arg_index, arg_value, __functionAddress);
    }

    public static int clSetKernelArgSVMPointer(long kernel, int arg_index, ByteBuffer arg_value) {
        return CL20.nclSetKernelArgSVMPointer(kernel, arg_index, MemoryUtil.memAddress(arg_value));
    }

    public static native int nclSetKernelExecInfo(long var0, int var2, long var3, long var5, long var7);

    public static int nclSetKernelExecInfo(long kernel, int param_name, long param_value_size, long param_value) {
        long __functionAddress = CL20.getInstance().SetKernelExecInfo;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(kernel);
        }
        return CL20.nclSetKernelExecInfo(kernel, param_name, param_value_size, param_value, __functionAddress);
    }

    public static int clSetKernelExecInfo(long kernel, int param_name, long param_value_size, ByteBuffer param_value) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)param_value, param_value_size);
        }
        return CL20.nclSetKernelExecInfo(kernel, param_name, param_value_size, MemoryUtil.memAddress(param_value));
    }

    public static int clSetKernelExecInfo(long kernel, int param_name, PointerBuffer param_value) {
        return CL20.nclSetKernelExecInfo(kernel, param_name, param_value.remaining() << Pointer.POINTER_SHIFT, MemoryUtil.memAddress(param_value));
    }

    public static int clSetKernelExecInfo(long kernel, int param_name, IntBuffer param_value) {
        return CL20.nclSetKernelExecInfo(kernel, param_name, param_value.remaining() << 2, MemoryUtil.memAddress(param_value));
    }

    public static native long nclCreateSamplerWithProperties(long var0, long var2, long var4, long var6);

    public static long nclCreateSamplerWithProperties(long context, long sampler_properties, long errcode_ret) {
        long __functionAddress = CL20.getInstance().CreateSamplerWithProperties;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(context);
        }
        return CL20.nclCreateSamplerWithProperties(context, sampler_properties, errcode_ret, __functionAddress);
    }

    public static long clCreateSamplerWithProperties(long context, ByteBuffer sampler_properties, ByteBuffer errcode_ret) {
        if (LWJGLUtil.CHECKS) {
            if (sampler_properties != null) {
                Checks.checkNT4(sampler_properties);
            }
            if (errcode_ret != null) {
                Checks.checkBuffer((Buffer)errcode_ret, 4);
            }
        }
        return CL20.nclCreateSamplerWithProperties(context, MemoryUtil.memAddressSafe(sampler_properties), MemoryUtil.memAddressSafe(errcode_ret));
    }

    public static long clCreateSamplerWithProperties(long context, IntBuffer sampler_properties, IntBuffer errcode_ret) {
        if (LWJGLUtil.CHECKS) {
            if (sampler_properties != null) {
                Checks.checkNT(sampler_properties);
            }
            if (errcode_ret != null) {
                Checks.checkBuffer((Buffer)errcode_ret, 1);
            }
        }
        return CL20.nclCreateSamplerWithProperties(context, MemoryUtil.memAddressSafe(sampler_properties), MemoryUtil.memAddressSafe(errcode_ret));
    }

    public static CLSVMFreeCallback CLSVMFreeCallback(final CLSVMFreeCallback.SAM sam) {
        return new CLSVMFreeCallback(){

            @Override
            public void invoke(long queue, int num_svm_pointers, long svm_pointers, long user_data) {
                sam.invoke(queue, num_svm_pointers, svm_pointers, user_data);
            }
        };
    }
}

