/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openal;

import java.nio.ByteBuffer;
import java.util.Set;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.openal.AL;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.MemoryUtil;

public final class SOFTBufferSamples {
    public static final int AL_MONO8_SOFT = 4352;
    public static final int AL_MONO16_SOFT = 4353;
    public static final int AL_MONO32F_SOFT = 65552;
    public static final int AL_STEREO8_SOFT = 4354;
    public static final int AL_STEREO16_SOFT = 4355;
    public static final int AL_STEREO32F_SOFT = 65553;
    public static final int AL_QUAD8_SOFT = 4612;
    public static final int AL_QUAD16_SOFT = 4613;
    public static final int AL_QUAD32F_SOFT = 4614;
    public static final int AL_REAR8_SOFT = 4615;
    public static final int AL_REAR16_SOFT = 4616;
    public static final int AL_REAR32F_SOFT = 4617;
    public static final int AL_5POINT1_8_SOFT = 4618;
    public static final int AL_5POINT1_16_SOFT = 4619;
    public static final int AL_5POINT1_32F_SOFT = 4620;
    public static final int AL_6POINT1_8_SOFT = 4621;
    public static final int AL_6POINT1_16_SOFT = 4622;
    public static final int AL_6POINT1_32F_SOFT = 4623;
    public static final int AL_7POINT1_8_SOFT = 4624;
    public static final int AL_7POINT1_16_SOFT = 4625;
    public static final int AL_7POINT1_32F_SOFT = 4626;
    public static final int AL_MONO_SOFT = 5376;
    public static final int AL_STEREO_SOFT = 5377;
    public static final int AL_QUAD_SOFT = 5378;
    public static final int AL_REAR_SOFT = 5379;
    public static final int AL_5POINT1_SOFT = 5380;
    public static final int AL_6POINT1_SOFT = 5381;
    public static final int AL_7POINT1_SOFT = 5382;
    public static final int AL_BYTE_SOFT = 5120;
    public static final int AL_UNSIGNED_BYTE_SOFT = 5121;
    public static final int AL_SHORT_SOFT = 5122;
    public static final int AL_UNSIGNED_SHORT_SOFT = 5123;
    public static final int AL_INT_SOFT = 5124;
    public static final int AL_UNSIGNED_INT_SOFT = 5125;
    public static final int AL_FLOAT_SOFT = 5126;
    public static final int AL_DOUBLE_SOFT = 5127;
    public static final int AL_BYTE3_SOFT = 5128;
    public static final int AL_UNSIGNED_BYTE3_SOFT = 5129;
    public static final int AL_INTERNAL_FORMAT_SOFT = 8200;
    public static final int AL_BYTE_LENGTH_SOFT = 8201;
    public static final int AL_SAMPLE_LENGTH_SOFT = 8202;
    public static final int AL_SEC_LENGTH_SOFT = 8203;
    public static final int AL_BYTE_RW_OFFSETS_SOFT = 4145;
    public static final int AL_SAMPLE_RW_OFFSETS_SOFT = 4146;
    public final long BufferSamplesSOFT;
    public final long IsBufferFormatSupportedSOFT;
    public final long BufferSubSamplesSOFT;
    public final long GetBufferSamplesSOFT;

    public SOFTBufferSamples(FunctionProvider provider) {
        this.BufferSamplesSOFT = provider.getFunctionAddress("alBufferSamplesSOFT");
        this.IsBufferFormatSupportedSOFT = provider.getFunctionAddress("alIsBufferFormatSupportedSOFT");
        this.BufferSubSamplesSOFT = provider.getFunctionAddress("alBufferSubSamplesSOFT");
        this.GetBufferSamplesSOFT = provider.getFunctionAddress("alGetBufferSamplesSOFT");
    }

    public static SOFTBufferSamples getInstance() {
        return AL.getCapabilities().__SOFTBufferSamples;
    }

    static SOFTBufferSamples create(Set<String> ext, FunctionProvider provider) {
        if (!ext.contains("AL_SOFT_buffer_samples")) {
            return null;
        }
        SOFTBufferSamples funcs = new SOFTBufferSamples(provider);
        boolean supported = Checks.checkFunctions(funcs.BufferSamplesSOFT, funcs.IsBufferFormatSupportedSOFT, funcs.BufferSubSamplesSOFT, funcs.GetBufferSamplesSOFT);
        return AL.checkExtension("AL_SOFT_buffer_samples", funcs, supported);
    }

    public static native void nalBufferSamplesSOFT(int var0, int var1, int var2, int var3, int var4, int var5, long var6, long var8);

    public static void nalBufferSamplesSOFT(int buffer, int samplerate, int internalformat, int samples, int channels, int type, long data) {
        long __functionAddress = SOFTBufferSamples.getInstance().BufferSamplesSOFT;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        SOFTBufferSamples.nalBufferSamplesSOFT(buffer, samplerate, internalformat, samples, channels, type, data, __functionAddress);
    }

    public static void alBufferSamplesSOFT(int buffer, int samplerate, int internalformat, int samples, int channels, int type, ByteBuffer data) {
        SOFTBufferSamples.nalBufferSamplesSOFT(buffer, samplerate, internalformat, samples, channels, type, MemoryUtil.memAddress(data));
    }

    public static native boolean nalIsBufferFormatSupportedSOFT(int var0, long var1);

    public static boolean alIsBufferFormatSupportedSOFT(int format) {
        long __functionAddress = SOFTBufferSamples.getInstance().IsBufferFormatSupportedSOFT;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        return SOFTBufferSamples.nalIsBufferFormatSupportedSOFT(format, __functionAddress);
    }

    public static native void nalBufferSubSamplesSOFT(int var0, int var1, int var2, int var3, int var4, long var5, long var7);

    public static void nalBufferSubSamplesSOFT(int buffer, int offset, int samples, int channels, int type, long data) {
        long __functionAddress = SOFTBufferSamples.getInstance().BufferSubSamplesSOFT;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        SOFTBufferSamples.nalBufferSubSamplesSOFT(buffer, offset, samples, channels, type, data, __functionAddress);
    }

    public static void alBufferSubSamplesSOFT(int buffer, int offset, int samples, int channels, int type, ByteBuffer data) {
        SOFTBufferSamples.nalBufferSubSamplesSOFT(buffer, offset, samples, channels, type, MemoryUtil.memAddress(data));
    }

    public static native void nalGetBufferSamplesSOFT(int var0, int var1, int var2, int var3, int var4, long var5, long var7);

    public static void nalGetBufferSamplesSOFT(int buffer, int offset, int samples, int channels, int type, long data) {
        long __functionAddress = SOFTBufferSamples.getInstance().GetBufferSamplesSOFT;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        SOFTBufferSamples.nalGetBufferSamplesSOFT(buffer, offset, samples, channels, type, data, __functionAddress);
    }

    public static void alGetBufferSamplesSOFT(int buffer, int offset, int samples, int channels, int type, ByteBuffer data) {
        SOFTBufferSamples.nalGetBufferSamplesSOFT(buffer, offset, samples, channels, type, MemoryUtil.memAddress(data));
    }
}

