/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openal;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.Set;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.openal.ALC;
import org.lwjgl.system.APIBuffer;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProviderLocal;
import org.lwjgl.system.MemoryUtil;

public final class ALC11 {
    public static final int ALC_MONO_SOURCES = 4112;
    public static final int ALC_STEREO_SOURCES = 4113;
    public static final int ALC_DEFAULT_ALL_DEVICES_SPECIFIER = 4114;
    public static final int ALC_ALL_DEVICES_SPECIFIER = 4115;
    public static final int ALC_CAPTURE_DEVICE_SPECIFIER = 784;
    public static final int ALC_CAPTURE_DEFAULT_DEVICE_SPECIFIER = 785;
    public static final int ALC_CAPTURE_SAMPLES = 786;
    public final long CaptureOpenDevice;
    public final long CaptureCloseDevice;
    public final long CaptureStart;
    public final long CaptureStop;
    public final long CaptureSamples;

    public ALC11(FunctionProviderLocal provider) {
        this.CaptureOpenDevice = provider.getFunctionAddress("alcCaptureOpenDevice");
        this.CaptureCloseDevice = provider.getFunctionAddress("alcCaptureCloseDevice");
        this.CaptureStart = provider.getFunctionAddress("alcCaptureStart");
        this.CaptureStop = provider.getFunctionAddress("alcCaptureStop");
        this.CaptureSamples = provider.getFunctionAddress("alcCaptureSamples");
    }

    public static ALC11 getInstance() {
        return ALC.getCapabilities().__ALC11;
    }

    static ALC11 create(Set<String> ext, FunctionProviderLocal provider) {
        if (!ext.contains("OpenALC11")) {
            return null;
        }
        ALC11 funcs = new ALC11(provider);
        boolean supported = Checks.checkFunctions(funcs.CaptureOpenDevice, funcs.CaptureCloseDevice, funcs.CaptureStart, funcs.CaptureStop, funcs.CaptureSamples);
        return ALC.checkExtension("OpenALC11", funcs, supported);
    }

    public static native long nalcCaptureOpenDevice(long var0, int var2, int var3, int var4, long var5);

    public static long nalcCaptureOpenDevice(long devicename, int frequency, int format, int buffersize) {
        long __functionAddress = ALC11.getInstance().CaptureOpenDevice;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        return ALC11.nalcCaptureOpenDevice(devicename, frequency, format, buffersize, __functionAddress);
    }

    public static long alcCaptureOpenDevice(ByteBuffer devicename, int frequency, int format, int buffersize) {
        if (LWJGLUtil.CHECKS && devicename != null) {
            Checks.checkNT1(devicename);
        }
        return ALC11.nalcCaptureOpenDevice(MemoryUtil.memAddressSafe(devicename), frequency, format, buffersize);
    }

    public static long alcCaptureOpenDevice(CharSequence devicename, int frequency, int format, int buffersize) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int devicenameEncoded = __buffer.stringParamUTF8(devicename, true);
        return ALC11.nalcCaptureOpenDevice(__buffer.addressSafe(devicename, devicenameEncoded), frequency, format, buffersize);
    }

    public static native boolean nalcCaptureCloseDevice(long var0, long var2);

    public static boolean alcCaptureCloseDevice(long device) {
        long __functionAddress = ALC11.getInstance().CaptureCloseDevice;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(device);
        }
        return ALC11.nalcCaptureCloseDevice(device, __functionAddress);
    }

    public static native void nalcCaptureStart(long var0, long var2);

    public static void alcCaptureStart(long device) {
        long __functionAddress = ALC11.getInstance().CaptureStart;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(device);
        }
        ALC11.nalcCaptureStart(device, __functionAddress);
    }

    public static native void nalcCaptureStop(long var0, long var2);

    public static void alcCaptureStop(long device) {
        long __functionAddress = ALC11.getInstance().CaptureStop;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(device);
        }
        ALC11.nalcCaptureStop(device, __functionAddress);
    }

    public static native void nalcCaptureSamples(long var0, long var2, int var4, long var5);

    public static void nalcCaptureSamples(long device, long buffer, int samples) {
        long __functionAddress = ALC11.getInstance().CaptureSamples;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(device);
        }
        ALC11.nalcCaptureSamples(device, buffer, samples, __functionAddress);
    }

    public static void alcCaptureSamples(long device, ByteBuffer buffer, int samples) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)buffer, samples);
        }
        ALC11.nalcCaptureSamples(device, MemoryUtil.memAddress(buffer), samples);
    }

    public static void alcCaptureSamples(long device, ByteBuffer buffer) {
        ALC11.nalcCaptureSamples(device, MemoryUtil.memAddress(buffer), buffer.remaining());
    }
}

