/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.glfw;

import java.io.PrintStream;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.util.Map;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.Pointer;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWCharCallback;
import org.lwjgl.glfw.GLFWCharModsCallback;
import org.lwjgl.glfw.GLFWCursorEnterCallback;
import org.lwjgl.glfw.GLFWCursorPosCallback;
import org.lwjgl.glfw.GLFWDropCallback;
import org.lwjgl.glfw.GLFWErrorCallback;
import org.lwjgl.glfw.GLFWFramebufferSizeCallback;
import org.lwjgl.glfw.GLFWKeyCallback;
import org.lwjgl.glfw.GLFWMonitorCallback;
import org.lwjgl.glfw.GLFWMouseButtonCallback;
import org.lwjgl.glfw.GLFWScrollCallback;
import org.lwjgl.glfw.GLFWWindowCloseCallback;
import org.lwjgl.glfw.GLFWWindowFocusCallback;
import org.lwjgl.glfw.GLFWWindowIconifyCallback;
import org.lwjgl.glfw.GLFWWindowPosCallback;
import org.lwjgl.glfw.GLFWWindowRefreshCallback;
import org.lwjgl.glfw.GLFWWindowSizeCallback;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.libffi.Closure;

public final class Callbacks {
    private Callbacks() {
    }

    public static void glfwSetCallback(GLFWErrorCallback cbfun) {
        GLFW.glfwSetErrorCallback(cbfun);
    }

    public static void glfwSetCallback(GLFWMonitorCallback cbfun) {
        GLFW.glfwSetMonitorCallback(cbfun);
    }

    public static void glfwSetCallback(long window, GLFWWindowPosCallback cbfun) {
        GLFW.glfwSetWindowPosCallback(window, cbfun);
    }

    public static void glfwSetCallback(long window, GLFWWindowSizeCallback cbfun) {
        GLFW.glfwSetWindowSizeCallback(window, cbfun);
    }

    public static void glfwSetCallback(long window, GLFWWindowCloseCallback cbfun) {
        GLFW.glfwSetWindowCloseCallback(window, cbfun);
    }

    public static void glfwSetCallback(long window, GLFWWindowRefreshCallback cbfun) {
        GLFW.glfwSetWindowRefreshCallback(window, cbfun);
    }

    public static void glfwSetCallback(long window, GLFWWindowFocusCallback cbfun) {
        GLFW.glfwSetWindowFocusCallback(window, cbfun);
    }

    public static void glfwSetCallback(long window, GLFWWindowIconifyCallback cbfun) {
        GLFW.glfwSetWindowIconifyCallback(window, cbfun);
    }

    public static void glfwSetCallback(long window, GLFWFramebufferSizeCallback cbfun) {
        GLFW.glfwSetFramebufferSizeCallback(window, cbfun);
    }

    public static void glfwSetCallback(long window, GLFWKeyCallback cbfun) {
        GLFW.glfwSetKeyCallback(window, cbfun);
    }

    public static void glfwSetCallback(long window, GLFWCharCallback cbfun) {
        GLFW.glfwSetCharCallback(window, cbfun);
    }

    public static void glfwSetCallback(long window, GLFWCharModsCallback cbfun) {
        GLFW.glfwSetCharModsCallback(window, cbfun);
    }

    public static void glfwSetCallback(long window, GLFWMouseButtonCallback cbfun) {
        GLFW.glfwSetMouseButtonCallback(window, cbfun);
    }

    public static void glfwSetCallback(long window, GLFWCursorPosCallback cbfun) {
        GLFW.glfwSetCursorPosCallback(window, cbfun);
    }

    public static void glfwSetCallback(long window, GLFWCursorEnterCallback cbfun) {
        GLFW.glfwSetCursorEnterCallback(window, cbfun);
    }

    public static void glfwSetCallback(long window, GLFWScrollCallback cbfun) {
        GLFW.glfwSetScrollCallback(window, cbfun);
    }

    public static void glfwSetCallback(long window, GLFWDropCallback cbfun) {
        GLFW.glfwSetDropCallback(window, cbfun);
    }

    public static void releaseAllCallbacks(long window) {
        long[] callbacks;
        for (long callback : callbacks = new long[]{GLFW.nglfwSetWindowPosCallback(window, 0L), GLFW.nglfwSetWindowSizeCallback(window, 0L), GLFW.nglfwSetWindowCloseCallback(window, 0L), GLFW.nglfwSetWindowRefreshCallback(window, 0L), GLFW.nglfwSetWindowFocusCallback(window, 0L), GLFW.nglfwSetWindowIconifyCallback(window, 0L), GLFW.nglfwSetFramebufferSizeCallback(window, 0L), GLFW.nglfwSetKeyCallback(window, 0L), GLFW.nglfwSetCharCallback(window, 0L), GLFW.nglfwSetCharModsCallback(window, 0L), GLFW.nglfwSetMouseButtonCallback(window, 0L), GLFW.nglfwSetCursorPosCallback(window, 0L), GLFW.nglfwSetCursorEnterCallback(window, 0L), GLFW.nglfwSetScrollCallback(window, 0L), GLFW.nglfwSetDropCallback(window, 0L)}) {
            if (callback == 0L) continue;
            Closure.release(callback);
        }
    }

    public static GLFWErrorCallback errorCallbackPrint() {
        return Callbacks.errorCallbackPrint(System.err);
    }

    public static GLFWErrorCallback errorCallbackPrint(final PrintStream stream) {
        return new GLFWErrorCallback(){
            private final Map<Integer, String> ERROR_CODES = LWJGLUtil.getClassTokens(new LWJGLUtil.TokenFilter(){

                @Override
                public boolean accept(Field field, int value) {
                    return 65536 < value && value < 131072;
                }
            }, null, GLFW.class);

            @Override
            public void invoke(int error, long description) {
                String msg = Callbacks.errorCallbackDescriptionString(description);
                stream.printf("[LWJGL] %s error\n", this.ERROR_CODES.get(error));
                stream.println("\tDescription : " + msg);
                stream.println("\tStacktrace  :");
                StackTraceElement[] stack = Thread.currentThread().getStackTrace();
                for (int i = 4; i < stack.length; ++i) {
                    stream.print("\t\t");
                    stream.println(stack[i].toString());
                }
            }
        };
    }

    public static GLFWErrorCallback errorCallbackThrow() {
        return new GLFWErrorCallback(){

            @Override
            public void invoke(int error, long description) {
                throw new IllegalStateException(String.format("GLFW error [0x%X]: %s", error, Callbacks.errorCallbackDescriptionString(description)));
            }
        };
    }

    public static ByteBuffer errorCallbackDescriptionBuffer(long description) {
        return MemoryUtil.memByteBufferNT1(description);
    }

    public static String errorCallbackDescriptionString(long description) {
        return MemoryUtil.memDecodeUTF8(description);
    }

    public static ByteBuffer[] dropCallbackNamesBuffer(int count, long names) {
        ByteBuffer[] buffers = new ByteBuffer[count];
        for (int i = 0; i < count; ++i) {
            buffers[i] = MemoryUtil.memByteBufferNT1(MemoryUtil.memGetAddress(names + (long)(Pointer.POINTER_SIZE * i)));
        }
        return buffers;
    }

    public static String[] dropCallbackNamesString(int count, long names) {
        String[] strings = new String[count];
        for (int i = 0; i < count; ++i) {
            strings[i] = MemoryUtil.memDecodeUTF8(MemoryUtil.memGetAddress(names + (long)(Pointer.POINTER_SIZE * i)));
        }
        return strings;
    }

    public static void dropCallbackNamesApply(int count, long names, DropConsumerBuffer consumer) {
        for (int i = 0; i < count; ++i) {
            consumer.accept(i, MemoryUtil.memByteBufferNT1(MemoryUtil.memGetAddress(names + (long)(Pointer.POINTER_SIZE * i))));
        }
    }

    public static void dropCallbackNamesApply(int count, long names, DropConsumerString consumer) {
        for (int i = 0; i < count; ++i) {
            consumer.accept(i, MemoryUtil.memDecodeUTF8(MemoryUtil.memGetAddress(names + (long)(Pointer.POINTER_SIZE * i))));
        }
    }

    public static interface DropConsumerString {
        public void accept(int var1, String var2);
    }

    public static interface DropConsumerBuffer {
        public void accept(int var1, ByteBuffer var2);
    }
}

