/*
 * Decompiled with CFR 0.152.
 */
package demo;

import GLEngine.GLSLProgram;
import GLEngine.InputHandler;
import GLEngine.Matrix4f;
import GLEngine.MeshBatch;
import GLEngine.SpriteBatch;
import GLEngine.Vector3f;
import GLEngine.Window;
import demo.Camera;
import demo.Settings;
import demo.Sound;
import java.util.ArrayList;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL13;
import org.lwjgl.opengl.GL20;
import scene.Bridge;
import scene.Build;
import scene.Crazy;
import scene.Fast;
import scene.Intro;
import scene.Main;
import scene.Scene;

public class Demo {
    public static boolean DEBUG_KEYS = false;
    public static boolean DEBUG_SHOW_TRAFFIC_NODES = false;
    public static boolean DEBUG_SHOW_VEHICLE_NEXT_NODE = false;
    public static boolean DEBUG_SHOW_TRAFFIC_PATH = false;
    public static boolean DEBUG_SHOW_AI_BREAK = false;
    public static boolean DEBUG_SHOW_CAMERA_POS = false;
    public static boolean DEBUG_NO_TRAFFIC = false;
    public static boolean DEBUG_TEST_RESTART = false;
    public static boolean DEBUG_PRINT_HIGHSCORE = false;
    public static boolean DEBUG_SHORT_SPAWN_TIME = false;
    public static boolean DEBUG_WINDOW_SIZE = false;
    public static boolean DEBUG_SHOW_FPS = false;
    private GLSLProgram activeProgram;
    private GLSLProgram activeProgram2D;
    private GLSLProgram activeProgramMap;
    private MeshBatch meshBatch;
    private SpriteBatch spriteBatch;
    private Window window;
    private Camera camera;
    private float fov = 70.0f;
    private float current_FPS = 0.0f;
    public static final int FPS = 60;
    private int mainMenuSelected = 0;
    private Settings settings;
    private Sound sound;
    ArrayList<Scene> scenes = new ArrayList();
    int i = 0;

    public Demo(Settings settings) {
        this.settings = settings;
        this.oneTimeInit();
        this.loop();
        this.free();
        System.exit(0);
    }

    public void oneTimeInit() {
        this.window = new Window("Sten taxi", this.settings.width, this.settings.height);
        this.window.init(this.settings.aa, this.settings.full);
        this.activeProgram = new GLSLProgram("/shaders/vertex.vert", "/shaders/fragment.frag");
        this.spriteBatch = new SpriteBatch();
        this.spriteBatch.init();
        this.initMeshBatch();
        this.sound = new Sound(this.settings.volume, this.settings.volume);
        this.sound.setMusic(Sound.MUSIC);
        this.camera = new Camera();
        this.scenes.add(new Intro(this.camera));
        this.scenes.add(new Main(this.camera));
        this.scenes.add(new Bridge(this.camera));
        this.scenes.add(new Crazy(this.camera));
        this.scenes.add(new Build(this.camera));
        this.scenes.add(new Fast(this.camera));
    }

    public void initMeshBatch() {
        this.meshBatch = new MeshBatch();
        this.meshBatch.init();
    }

    private void restart() {
        this.camera = new Camera();
        this.camera.pos = new Vector3f(30.0f, 30.0f, 30.0f);
        this.camera.rot.x = -45.0f;
    }

    public void loop() {
        double tick = 0.0;
        while (!this.window.shouldClose()) {
            long time0 = System.nanoTime();
            InputHandler.update();
            this.window.pollEvents();
            GL11.glClear(16640);
            if (InputHandler.pressed(256)) {
                System.exit(0);
            }
            this.meshBatch.begin(this.activeProgram, this.camera, this.window);
            this.body((long)tick);
            this.meshBatch.end();
            this.window.swapBuffers();
            long dt = System.nanoTime() - time0;
            if (tick % 60.0 == 0.0 && dt != 0L) {
                this.current_FPS = (float)(1.0 / ((double)dt / 1.0E9));
            }
            if (this.current_FPS < 55.0f && this.current_FPS >= 1.0f) {
                System.out.println(this.current_FPS);
            }
            if (this.current_FPS >= 1.0f && this.current_FPS <= 60.0f) {
                tick += (double)(1.0f / (this.current_FPS / 60.0f));
                continue;
            }
            tick += 1.0;
        }
    }

    private void body(long tick) {
        if (this.scenes.isEmpty()) {
            System.exit(0);
        }
        Scene scene = this.scenes.get(0);
        this.meshBatch.lightPos.x = (float)(Math.cos((double)tick / 32.0) * 20.0);
        this.meshBatch.lightPos.z = (float)(Math.sin((double)tick / 32.0) * 20.0);
        this.meshBatch.tick = tick;
        scene.updateAndRender(this.meshBatch);
        --scene.duration;
        if (scene.duration <= 0L) {
            this.scenes.remove(0);
        }
    }

    public void initOrtho() {
        this.activeProgram2D.enable();
        GL13.glActiveTexture(33984);
        int textureUniform = this.activeProgram2D.getUniform("texSampler");
        GL20.glUniform1i(textureUniform, 0);
        Matrix4f proj = Matrix4f.orthoProjection(this.window.getWidth(), 0.0f, 0.0f, this.window.getHeight(), 0.1f, 100.0f);
        int pv = this.activeProgram2D.getUniform("PV");
        GL20.glUniformMatrix4fv(pv, true, proj.toFloatBuffer());
    }

    public void free() {
        this.activeProgram.free();
        this.activeProgram2D.free();
        this.activeProgramMap.free();
        this.spriteBatch.free();
        this.meshBatch.free();
        this.window.destroy();
    }
}

