/*
 * Decompiled with CFR 0.152.
 */
package GLEngine;

import GLEngine.Utilities;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import javax.imageio.ImageIO;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL13;
import org.lwjgl.opengl.GL30;

public class Texture {
    private static HashMap<String, Integer> textureMap = new HashMap();
    public static int WHITE = new Texture((String)"textures/white.png").textureID;
    public static int F1 = new Texture((String)"textures/f1.png").textureID;
    public static int F2 = new Texture((String)"textures/f2.png").textureID;
    public static int F3 = new Texture((String)"textures/f3.png").textureID;
    public static int F4 = new Texture((String)"textures/f4.png").textureID;
    private int width;
    private int height;
    public int textureID;
    private static int[] CHAR_ID;
    private static int[] CHAR_WIDTH;
    private static int[] CHAR_HEIGHT;

    static {
        char num = '\u0100';
        CHAR_ID = new int[num];
        CHAR_WIDTH = new int[num];
        CHAR_HEIGHT = new int[num];
        int height = 72;
        Font font = Texture.loadFont("/fonts/GROBOLD.ttf", height);
        FontMetrics metrics = new BufferedImage(30, 30, 2).getGraphics().getFontMetrics(font);
        char c = '\u0000';
        while (c < num) {
            if (!Character.isISOControl(c)) {
                int hgt = metrics.getHeight();
                int adv = metrics.stringWidth("" + c);
                Dimension size = new Dimension(adv + 10, hgt + 8);
                BufferedImage charImg = new BufferedImage(size.width, size.height, 2);
                Graphics go = charImg.getGraphics();
                Graphics2D g = (Graphics2D)go;
                g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                g.setFont(font);
                g.setColor(new Color(0, 0, 0, 0));
                g.fillRect(0, 0, size.width, size.height);
                g.setColor(new Color(0.1254902f, 0.1254902f, 0.1254902f, 1.0f));
                g.drawString("" + c, 5, size.height - 2);
                g.setColor(Color.WHITE);
                g.drawString("" + c, 5, size.height - 4);
                Texture.CHAR_ID[c] = Texture.createTexture(charImg);
                Texture.CHAR_WIDTH[c] = size.width;
                Texture.CHAR_HEIGHT[c] = size.height;
            }
            c = (char)(c + '\u0001');
        }
    }

    public Texture(String path) {
        this.textureID = this.load(path);
    }

    public static int getTexture(String path) {
        if (textureMap.containsKey(path)) {
            return textureMap.get(path);
        }
        return new Texture((String)path).textureID;
    }

    private int load(String path) {
        if (textureMap.containsKey(path)) {
            return textureMap.get(path);
        }
        int[] pixels = null;
        try {
            InputStream in = Utilities.class.getResourceAsStream("/" + path);
            BufferedImage image = ImageIO.read(in);
            this.width = image.getWidth();
            this.height = image.getHeight();
            pixels = new int[this.width * this.height];
            image.getRGB(0, 0, this.width, this.height, pixels, 0, this.width);
        }
        catch (Exception e) {
            System.out.println("fel med textur: " + path);
            e.printStackTrace();
        }
        int[] data = new int[this.width * this.height];
        int i = 0;
        while (i < this.width * this.height) {
            int a = (pixels[i] & 0xFF000000) >> 24;
            int r = (pixels[i] & 0xFF0000) >> 16;
            int g = (pixels[i] & 0xFF00) >> 8;
            int b = pixels[i] & 0xFF;
            data[i] = a << 24 | b << 16 | g << 8 | r;
            ++i;
        }
        int result = GL11.glGenTextures();
        GL13.glActiveTexture(33984);
        GL11.glBindTexture(3553, result);
        GL11.glTexImage2D(3553, 0, 6408, this.width, this.height, 0, 6408, 5121, Utilities.createIntBuffer(data));
        GL30.glGenerateMipmap(3553);
        GL11.glTexParameteri(3553, 10242, 10497);
        GL11.glTexParameteri(3553, 10243, 10497);
        GL11.glTexParameteri(3553, 10240, 9729);
        GL11.glTexParameteri(3553, 10241, 9987);
        GL11.glBindTexture(3553, 0);
        textureMap.put(path, result);
        return result;
    }

    public void bind() {
        GL11.glBindTexture(3553, this.textureID);
    }

    public void unbind() {
        GL11.glBindTexture(3553, 0);
    }

    public void free() {
        GL11.glDeleteTextures(this.textureID);
    }

    public static int createTexture(BufferedImage image) {
        int[] pixels = null;
        int width = 0;
        int height = 0;
        width = image.getWidth();
        height = image.getHeight();
        pixels = new int[width * height];
        image.getRGB(0, 0, width, height, pixels, 0, width);
        int[] data = new int[width * height];
        int i = 0;
        while (i < width * height) {
            int a = (pixels[i] & 0xFF000000) >> 24;
            int r = (pixels[i] & 0xFF0000) >> 16;
            int g = (pixels[i] & 0xFF00) >> 8;
            int b = pixels[i] & 0xFF;
            data[i] = a << 24 | b << 16 | g << 8 | r;
            ++i;
        }
        int result = GL11.glGenTextures();
        GL13.glActiveTexture(33984);
        GL11.glBindTexture(3553, result);
        GL11.glTexImage2D(3553, 0, 6408, width, height, 0, 6408, 5121, Utilities.createIntBuffer(data));
        GL30.glGenerateMipmap(3553);
        GL11.glTexParameteri(3553, 10242, 10497);
        GL11.glTexParameteri(3553, 10243, 10497);
        GL11.glTexParameteri(3553, 10240, 9729);
        GL11.glTexParameteri(3553, 10241, 9987);
        GL11.glBindTexture(3553, 0);
        return result;
    }

    private static Font loadFont(String path, float size) {
        InputStream is = Texture.class.getResourceAsStream(path);
        Font font = null;
        try {
            font = Font.createFont(0, is);
        }
        catch (FontFormatException | IOException e) {
            e.printStackTrace();
        }
        return font.deriveFont(size);
    }

    public static int getCharID(char c) {
        return CHAR_ID[c];
    }

    public static int getCharWidth(char c) {
        return CHAR_WIDTH[c];
    }

    public static int getCharHeight(char c) {
        return CHAR_HEIGHT[c];
    }
}

