/*
 * Decompiled with CFR 0.152.
 */
package GLEngine;

import GLEngine.GLSLProgram;
import GLEngine.Matrix4f;
import GLEngine.Texture;
import GLEngine.Utilities;
import GLEngine.Vector3f;
import java.util.ArrayList;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL15;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.GL30;

public class SpriteBatch {
    private ArrayList<Sprite> renderList = new ArrayList();
    private GLSLProgram activeShader;
    public static VAO quadVAO;

    public void init() {
        this.allocateVAO();
    }

    public void allocateVAO() {
        VAO vao = new VAO();
        vao.VAO = GL30.glGenVertexArrays();
        GL30.glBindVertexArray(vao.VAO);
        float[] vertices = new float[]{0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f, 0.0f, 0.0f};
        int[] nArray = new int[6];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 2;
        nArray[4] = 3;
        int[] elements = nArray;
        float[] uv = new float[]{0.0f, 0.0f, 1.0f, 0.0f, 1.0f, 1.0f, 0.0f, 1.0f};
        vao.VBO = GL15.glGenBuffers();
        GL15.glBindBuffer(34962, vao.VBO);
        GL15.glBufferData(34962, Utilities.createFloatBuffer(vertices), 35044);
        GL20.glVertexAttribPointer(0, 2, 5126, false, 0, 0L);
        GL20.glEnableVertexAttribArray(0);
        vao.UVBO = GL15.glGenBuffers();
        GL15.glBindBuffer(34962, vao.UVBO);
        GL15.glBufferData(34962, Utilities.createFloatBuffer(uv), 35044);
        GL20.glVertexAttribPointer(1, 2, 5126, false, 0, 0L);
        GL20.glEnableVertexAttribArray(1);
        vao.IBO = GL15.glGenBuffers();
        GL15.glBindBuffer(34963, vao.IBO);
        GL15.glBufferData(34963, Utilities.createIntBuffer(elements), 35044);
        GL30.glBindVertexArray(0);
        GL15.glBindBuffer(34962, 0);
        GL15.glBindBuffer(34963, 0);
        quadVAO = vao;
    }

    public void begin(GLSLProgram shader) {
        this.renderList.clear();
        this.activeShader = shader;
    }

    public void renderString(String text, Vector3f pos) {
        text = text.toUpperCase();
        int x = 0;
        int i = 0;
        while (i < text.length()) {
            Sprite m = new Sprite();
            int width = Texture.getCharWidth(text.charAt(i));
            int height = Texture.getCharHeight(text.charAt(i));
            Matrix4f modelMatrix = Matrix4f.translate(pos).multiply(Matrix4f.scaleX(width)).multiply(Matrix4f.scaleY(height));
            m.textureID = Texture.getCharID(text.charAt(i));
            m.modelMatrix = Matrix4f.translate(new Vector3f(x, 0.0f, 0.0f)).multiply(modelMatrix);
            x += width;
            this.renderList.add(m);
            ++i;
        }
    }

    public void renderString(String text, Vector3f pos, float scale, Vector3f color) {
        text = text.toUpperCase();
        int x = 0;
        int i = 0;
        while (i < text.length()) {
            Sprite m = new Sprite();
            float width = (float)Texture.getCharWidth(text.charAt(i)) * scale;
            float height = (float)Texture.getCharHeight(text.charAt(i)) * scale;
            Matrix4f modelMatrix = Matrix4f.translate(pos).multiply(Matrix4f.scaleX(width)).multiply(Matrix4f.scaleY(height));
            m.textureID = Texture.getCharID(text.charAt(i));
            m.modelMatrix = Matrix4f.translate(new Vector3f(x, 0.0f, 0.0f)).multiply(modelMatrix);
            m.color = color;
            x = (int)((float)x + width);
            this.renderList.add(m);
            ++i;
        }
    }

    public void render(int textureID, Matrix4f modelMatrix) {
        Sprite m = new Sprite();
        m.textureID = textureID;
        m.modelMatrix = modelMatrix;
        m.color = new Vector3f(1.0f, 1.0f, 1.0f);
        this.renderList.add(m);
    }

    public void render(int textureID, Matrix4f modelMatrix, Vector3f color) {
        Sprite m = new Sprite();
        m.textureID = textureID;
        m.modelMatrix = modelMatrix;
        m.color = color;
        this.renderList.add(m);
    }

    public void end() {
        GL11.glDisable(2929);
        GL11.glEnable(3042);
        VAO vao = quadVAO;
        int m = this.activeShader.getUniform("M");
        int c = this.activeShader.getUniform("color");
        for (Sprite s : this.renderList) {
            GL20.glUniformMatrix4fv(m, true, s.modelMatrix.toFloatBuffer());
            float[] color2 = new float[]{s.color.x, s.color.y, s.color.z, 1.0f};
            GL20.glUniform4fv(c, Utilities.createFloatBuffer(color2));
            GL11.glBindTexture(3553, s.textureID);
            GL20.glUniform1i(s.textureID, 0);
            GL30.glBindVertexArray(vao.VAO);
            GL11.glDrawElements(4, 6, 5125, 0L);
            GL30.glBindVertexArray(0);
            GL11.glBindTexture(3553, 0);
        }
        GL11.glDisable(3042);
        GL11.glEnable(2929);
    }

    public GLSLProgram getActiveShader() {
        return this.activeShader;
    }

    public void free() {
        VAO vao = quadVAO;
        GL15.glDeleteBuffers(vao.VBO);
        GL15.glDeleteBuffers(vao.UVBO);
        GL15.glDeleteBuffers(vao.IBO);
        GL30.glDeleteVertexArrays(vao.VAO);
    }

    public void renderString(String string, Vector3f pos, float s1) {
        this.renderString(string, pos, s1, new Vector3f(1.0f, 1.0f, 1.0f));
    }

    private class Sprite {
        public int textureID;
        public Matrix4f modelMatrix;
        public Vector3f color = new Vector3f(1.0f, 1.0f, 1.0f);

        private Sprite() {
        }
    }

    public class VAO {
        public int VAO;
        public int VBO;
        public int IBO;
        public int UVBO;
    }
}

