/*
 * Decompiled with CFR 0.152.
 */
package GLEngine;

import GLEngine.Mesh;
import GLEngine.Utilities;
import GLEngine.Vector3f;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Scanner;

public class OBJLoader {
    public static OBJLoader LOADER = new OBJLoader();

    public Mesh getIndexedMesh(String path, float scale) {
        return this.getIndexedMesh(path, scale, false);
    }

    public Mesh getIndexedMesh(String path, float scale, boolean forceFlatShading) {
        OBJMesh mesh = this.getOBJMesh(path, scale);
        ArrayList<OBJFace> faces = mesh.faceList;
        ArrayList<FaceVertex> fVertices = new ArrayList<FaceVertex>();
        ArrayList<Integer> findices = new ArrayList<Integer>();
        ArrayList<Vector3f> flatShadingNormals = new ArrayList<Vector3f>();
        int maxindex = 0;
        for (OBJFace f : faces) {
            int index;
            FaceVertex fa = new FaceVertex(f.vA, f.nA, f.tA);
            FaceVertex fb = new FaceVertex(f.vB, f.nB, f.tB);
            FaceVertex fc = new FaceVertex(f.vC, f.nC, f.tC);
            if (forceFlatShading) {
                Vector3f v1 = mesh.vertexList.get(f.vA - 1);
                Vector3f v2 = mesh.vertexList.get(f.vB - 1);
                Vector3f v3 = mesh.vertexList.get(f.vC - 1);
                fa.normalID = flatShadingNormals.size();
                fb.normalID = flatShadingNormals.size();
                fc.normalID = flatShadingNormals.size();
                flatShadingNormals.add(v1.subtract(v2).cross(v1.subtract(v3)).normalized());
            }
            if ((index = fa.existsIn(fVertices)) == -1) {
                findices.add(maxindex);
                ++maxindex;
                fVertices.add(fa);
            } else {
                findices.add(index);
            }
            index = fb.existsIn(fVertices);
            if (index == -1) {
                findices.add(maxindex);
                ++maxindex;
                fVertices.add(fb);
            } else {
                findices.add(index);
            }
            index = fc.existsIn(fVertices);
            if (index == -1) {
                findices.add(maxindex);
                ++maxindex;
                fVertices.add(fc);
                continue;
            }
            findices.add(index);
        }
        float[] vertices = new float[maxindex * 3];
        float[] textureCoordinates = new float[maxindex * 2];
        float[] normalCoordinates = new float[maxindex * 3];
        int[] indices = new int[findices.size()];
        int i = 0;
        while (i < indices.length) {
            indices[i] = (Integer)findices.get(i);
            ++i;
        }
        i = 0;
        while (i < maxindex) {
            int vID = ((FaceVertex)fVertices.get((int)i)).vertexID - 1;
            int nID = fVertices.get((int)i).normalID - 1;
            int tID = fVertices.get((int)i).texID - 1;
            Vector3f vertex = mesh.vertexList.get(vID);
            Vector3f normal = forceFlatShading ? (Vector3f)flatShadingNormals.get(fVertices.get((int)i).normalID) : mesh.normalList.get(nID);
            Vector3f tex = null;
            tex = mesh.texcoordList.size() == 0 || tID < 0 ? new Vector3f(0.0f, 0.0f, 0.0f) : mesh.texcoordList.get(tID);
            vertices[i * 3 + 0] = vertex.x;
            vertices[i * 3 + 1] = vertex.y;
            vertices[i * 3 + 2] = vertex.z;
            normalCoordinates[i * 3 + 0] = normal.x;
            normalCoordinates[i * 3 + 1] = normal.y;
            normalCoordinates[i * 3 + 2] = normal.z;
            textureCoordinates[i * 2 + 0] = tex.x;
            textureCoordinates[i * 2 + 1] = tex.y;
            ++i;
        }
        Mesh glMesh = new Mesh();
        glMesh.vertices = vertices;
        glMesh.normalCoords = normalCoordinates;
        glMesh.textureCoords = textureCoordinates;
        glMesh.indices = indices;
        glMesh.material = mesh.material;
        mesh = null;
        return glMesh;
    }

    static String convertStreamToString(InputStream is) {
        Scanner s = new Scanner(is).useDelimiter("\\A");
        return s.hasNext() ? s.next() : "";
    }

    public OBJFace getFace(String line) {
        OBJFace face = new OBJFace();
        while (line.charAt(0) == 'f' || line.charAt(0) == ' ') {
            line = line.substring(1, line.length());
        }
        line = line.replaceAll("//", "/");
        line = line.replaceAll("  ", " ");
        String[] vectors = line.split(" ");
        String a = vectors[0];
        String b = vectors[1];
        String c = vectors[2];
        String[] values = a.split("/");
        if (values.length == 1) {
            face.vA = Integer.parseInt(values[0]);
        }
        if (values.length == 2) {
            face.vA = Integer.parseInt(values[0]);
            face.nA = Integer.parseInt(values[1]);
        }
        if (values.length == 3) {
            face.vA = Integer.parseInt(values[0]);
            face.tA = Integer.parseInt(values[1]);
            face.nA = Integer.parseInt(values[2]);
        }
        if ((values = b.split("/")).length == 1) {
            face.vB = Integer.parseInt(values[0]);
        }
        if (values.length == 2) {
            face.vB = Integer.parseInt(values[0]);
            face.nB = Integer.parseInt(values[1]);
        }
        if (values.length == 3) {
            face.vB = Integer.parseInt(values[0]);
            face.tB = Integer.parseInt(values[1]);
            face.nB = Integer.parseInt(values[2]);
        }
        if ((values = c.split("/")).length == 1) {
            face.vC = Integer.parseInt(values[0]);
        }
        if (values.length == 2) {
            face.vC = Integer.parseInt(values[0]);
            face.nC = Integer.parseInt(values[1]);
        }
        if (values.length == 3) {
            face.vC = Integer.parseInt(values[0]);
            face.tC = Integer.parseInt(values[1]);
            face.nC = Integer.parseInt(values[2]);
        }
        return face;
    }

    public OBJMesh getOBJMesh(String filePath, float scale) {
        String[] s;
        String line;
        InputStream in = Utilities.class.getResourceAsStream("/" + filePath);
        String objString = OBJLoader.convertStreamToString(in);
        OBJMesh obj = new OBJMesh();
        Scanner scan = new Scanner(objString);
        while (scan.hasNext()) {
            double z;
            double y;
            double x;
            line = scan.nextLine();
            if (line.length() >= 2 && line.charAt(0) == 'v' && line.charAt(1) == ' ') {
                s = line.replace("  ", " ").split(" ");
                x = Double.parseDouble(s[1]) * (double)scale;
                y = Double.parseDouble(s[2]) * (double)scale;
                z = Double.parseDouble(s[3]) * (double)scale;
                obj.vertexList.add(new Vector3f((float)x, (float)y, (float)z));
            }
            if (line.length() >= 2 && line.charAt(0) == 'v' && line.charAt(1) == 'n') {
                s = line.replace("  ", " ").split(" ");
                x = Double.parseDouble(s[1]);
                y = Double.parseDouble(s[2]);
                z = Double.parseDouble(s[3]);
                obj.normalList.add(new Vector3f((float)x, (float)y, (float)z));
            }
            if (line.length() >= 2 && line.charAt(0) == 'v' && line.charAt(1) == 't') {
                s = line.replace("  ", " ").split(" ");
                x = 0.0;
                y = 0.0;
                z = 0.0;
                if (s.length > 1) {
                    x = Double.parseDouble(s[1]);
                }
                if (s.length > 2) {
                    y = Double.parseDouble(s[2]);
                }
                if (s.length > 3) {
                    z = Double.parseDouble(s[3]);
                }
                obj.texcoordList.add(new Vector3f((float)x, (float)y, (float)z));
            }
            if (line.length() < 2 || line.charAt(0) != 'f' || line.charAt(1) != ' ') continue;
            OBJFace face = this.getFace(line);
            obj.faceList.add(face);
        }
        filePath = filePath.replaceAll(".obj", ".mtl");
        in = Utilities.class.getResourceAsStream("/" + filePath);
        objString = OBJLoader.convertStreamToString(in);
        scan.close();
        scan = new Scanner(objString);
        while (scan.hasNext()) {
            line = scan.nextLine();
            s = line.split(" ");
            if (line.length() < 2 || line.charAt(0) != 'K' || line.charAt(1) != 's') continue;
            obj.material.specular = new Vector3f((float)Double.parseDouble(s[1]), (float)Double.parseDouble(s[2]), (float)Double.parseDouble(s[3]));
        }
        scan.close();
        return obj;
    }

    private class FaceVertex {
        int vertexID;
        int normalID;
        int texID;

        public FaceVertex(int v, int n, int t) {
            this.vertexID = v;
            this.normalID = n;
            this.texID = t;
        }

        public int existsIn(ArrayList<FaceVertex> fv) {
            int i = 0;
            while (i < fv.size()) {
                FaceVertex ftemp = fv.get(i);
                if (this.vertexID == ftemp.vertexID && this.normalID == ftemp.normalID && this.texID == ftemp.texID) {
                    return i;
                }
                ++i;
            }
            return -1;
        }
    }

    public class Material {
        Vector3f specular = new Vector3f(0.0f, 0.0f, 0.0f);
    }

    private class OBJFace {
        public int vA = -1;
        public int vB = -1;
        public int vC = -1;
        public int nA = -1;
        public int nB = -1;
        public int nC = -1;
        public int tA = -1;
        public int tB = -1;
        public int tC = -1;

        private OBJFace() {
        }
    }

    public class OBJMesh {
        public ArrayList<Vector3f> vertexList = new ArrayList();
        public ArrayList<Vector3f> normalList = new ArrayList();
        public ArrayList<Vector3f> texcoordList = new ArrayList();
        public ArrayList<OBJFace> faceList = new ArrayList();
        public Material material;

        public OBJMesh() {
            this.material = new Material();
        }
    }
}

