/*
 * Decompiled with CFR 0.152.
 */
package GLEngine;

import GLEngine.OBJLoader;
import java.util.HashMap;
import javax.vecmath.Vector3f;

public class Mesh {
    private static HashMap<MeshKey, Mesh> meshMap = new HashMap();
    public static Mesh ARROW = Mesh.getMesh("objfiles/arrow.obj", 1.0f, false);
    public static Mesh OPEN = Mesh.getMesh("objfiles/open.obj", 1.0f, false);
    public static Mesh KNOT = Mesh.getMesh("objfiles/knot.obj", 1.0f, false);
    public static Mesh SPRING = Mesh.getMesh("objfiles/spring.obj", 1.0f, false);
    public static Mesh CUBE = Mesh.getMesh("objfiles/cube.obj", 1.0f, false);
    public static Mesh CUBETEX = Mesh.getMesh("objfiles/cubetex.obj", 1.0f, false);
    public int textureID;
    public float[] vertices;
    public float[] textureCoords;
    public float[] normalCoords;
    public float[] colorCoords = new float[0];
    public int[] indices;
    public OBJLoader.Material material;

    public Vector3f getBounds() {
        float x = Math.abs(this.vertices[0]);
        float y = Math.abs(this.vertices[1]);
        float z = Math.abs(this.vertices[2]);
        int i = 3;
        while (i < this.vertices.length) {
            x = Math.max(x, Math.abs(this.vertices[i + 0]));
            y = Math.max(y, Math.abs(this.vertices[i + 1]));
            z = Math.max(z, Math.abs(this.vertices[i + 2]));
            i += 3;
        }
        return new Vector3f(x, y, z);
    }

    public void getBounds(Vector3f size, Vector3f center) {
        float xmin = this.vertices[0];
        float ymin = this.vertices[1];
        float zmin = this.vertices[2];
        float xmax = this.vertices[0];
        float ymax = this.vertices[1];
        float zmax = this.vertices[2];
        int i = 3;
        while (i < this.vertices.length) {
            xmin = Math.min(xmin, this.vertices[i + 0]);
            ymin = Math.min(ymin, this.vertices[i + 1]);
            zmin = Math.min(zmin, this.vertices[i + 2]);
            xmax = Math.max(xmax, this.vertices[i + 0]);
            ymax = Math.max(ymax, this.vertices[i + 1]);
            zmax = Math.max(zmax, this.vertices[i + 2]);
            i += 3;
        }
        size.x = xmax - xmin;
        size.y = ymax - ymin;
        size.z = zmax - zmin;
        center.x = (xmax + xmin) * 0.5f;
        center.y = (ymax + ymin) * 0.5f;
        center.z = (zmax + zmin) * 0.5f;
    }

    public static Mesh getMesh(String path) {
        return Mesh.getMesh(path, 1.0f, true);
    }

    public static Mesh getMesh(String path, float scale) {
        return Mesh.getMesh(path, scale, true);
    }

    public static Mesh getMesh(String path, float scale, boolean forceFlatShading) {
        MeshKey key = new MeshKey(path, scale);
        if (meshMap.containsKey(key)) {
            return meshMap.get(key);
        }
        Mesh value = OBJLoader.LOADER.getIndexedMesh(path, scale, forceFlatShading);
        meshMap.put(key, value);
        return value;
    }

    public static class MeshKey {
        String mesh;
        float scale = 1.0f;

        public MeshKey(String m, float s) {
            this.mesh = m;
            this.scale = s;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.mesh == null ? 0 : this.mesh.hashCode());
            result = 31 * result + Float.floatToIntBits(this.scale);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            MeshKey other = (MeshKey)obj;
            if (this.mesh == null ? other.mesh != null : !this.mesh.equals(other.mesh)) {
                return false;
            }
            return Float.floatToIntBits(this.scale) == Float.floatToIntBits(other.scale);
        }
    }
}

