/*
 * Decompiled with CFR 0.152.
 */
package GLEngine;

import GLEngine.GLSLProgram;
import GLEngine.InputHandler;
import GLEngine.Matrix4f;
import GLEngine.Mesh;
import GLEngine.MeshBatch;
import GLEngine.OBJLoader;
import GLEngine.Texture;
import GLEngine.Utilities;
import GLEngine.Vector3f;
import GLEngine.VertexArray;
import GLEngine.Window;
import java.util.ArrayList;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL13;
import org.lwjgl.opengl.GL20;

public class Main {
    public boolean running = true;
    private Window window;
    private VertexArray VATest;
    private GLSLProgram PRTest;
    private Texture TxTest;
    private ArrayList<VertexArray> VAOS = new ArrayList();
    Mesh mesh = new Mesh();
    MeshBatch meshBatch = new MeshBatch();
    Vector3f camera = new Vector3f(0.0f, 0.1f, 30.0f);
    float rot = 0.0f;

    public static void main(String[] args) {
        new Main();
    }

    public Main() {
        float[] vertices = new float[]{-0.5f, -0.5f, -0.5f, -0.5f, 0.5f, -0.5f, 0.5f, 0.5f, -0.5f, 0.5f, -0.5f, -0.5f, -0.5f, 0.5f, -0.5f, -0.5f, -0.5f, -0.5f, -0.5f, -0.5f, 0.5f, -0.5f, 0.5f, 0.5f, -0.5f, -0.5f, 0.5f, -0.5f, 0.5f, 0.5f, 0.5f, 0.5f, 0.5f, 0.5f, -0.5f, 0.5f, -0.5f, -0.5f, 0.5f, 0.5f, -0.5f, 0.5f, 0.5f, -0.5f, -0.5f, -0.5f, -0.5f, -0.5f, 0.5f, 0.5f, -0.5f, 0.5f, -0.5f, -0.5f, 0.5f, -0.5f, 0.5f, 0.5f, 0.5f, 0.5f, -0.5f, 0.5f, 0.5f, 0.5f, 0.5f, 0.5f, 0.5f, 0.5f, -0.5f, -0.5f, 0.5f, -0.5f};
        float[] tex = new float[]{0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 1.0f, 1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 1.0f, 1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 1.0f, 1.0f};
        float[] color = new float[]{1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 1.0f, 0.0f, 1.0f, 0.0f, 1.0f, 0.0f, 1.0f, 0.0f, 1.0f, 0.0f, 1.0f, 0.0f, 1.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 1.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f, 1.0f, 0.0f, 1.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 1.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f, 1.0f, 0.0f, 1.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 1.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f, 1.0f, 0.0f, 1.0f};
        int[] nArray = new int[36];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 2;
        nArray[4] = 3;
        nArray[6] = 4;
        nArray[7] = 5;
        nArray[8] = 6;
        nArray[9] = 6;
        nArray[10] = 7;
        nArray[11] = 4;
        nArray[12] = 8;
        nArray[13] = 9;
        nArray[14] = 10;
        nArray[15] = 10;
        nArray[16] = 11;
        nArray[17] = 8;
        nArray[18] = 12;
        nArray[19] = 13;
        nArray[20] = 14;
        nArray[21] = 14;
        nArray[22] = 15;
        nArray[23] = 12;
        nArray[24] = 16;
        nArray[25] = 17;
        nArray[26] = 18;
        nArray[27] = 18;
        nArray[28] = 19;
        nArray[29] = 16;
        nArray[30] = 20;
        nArray[31] = 21;
        nArray[32] = 22;
        nArray[33] = 22;
        nArray[34] = 23;
        nArray[35] = 20;
        int[] indices = nArray;
        this.initWindow();
        this.PRTest = new GLSLProgram("shaders/vertex.vert", "shaders/fragment.frag");
        float[] color2 = new float[]{};
        this.TxTest = new Texture("textures/text.png");
        this.initMesh();
        this.loop();
        this.free();
    }

    private void initMesh() {
        OBJLoader oe = new OBJLoader();
        this.mesh = oe.getIndexedMesh("objfiles/skyscraper.obj", 1.0f);
        float[] colorCoordinates = new float[]{};
        this.meshBatch.init();
        this.meshBatch.preAllocateVAO(this.mesh);
    }

    private void initWindow() {
        this.window = new Window("GLEngine");
    }

    public void update() {
        this.window.pollEvents();
        if (InputHandler.keys[256]) {
            this.window.setShouldClose(true);
        }
        if (InputHandler.keys[263]) {
            this.camera.x = (float)((double)this.camera.x - 0.1);
        }
        if (InputHandler.keys[262]) {
            this.camera.x = (float)((double)this.camera.x + 0.1);
        }
        if (InputHandler.keys[264]) {
            this.camera.z = (float)((double)this.camera.z + 0.1);
        }
        if (InputHandler.keys[265]) {
            this.camera.z = (float)((double)this.camera.z - 0.1);
        }
        if (InputHandler.keys[65]) {
            this.rot += 1.0f;
        }
        if (InputHandler.keys[68]) {
            this.rot -= 1.0f;
        }
        if (InputHandler.keys[32]) {
            this.camera.y = (float)((double)this.camera.y + 0.1);
        }
        if (InputHandler.keys[341]) {
            this.camera.y = (float)((double)this.camera.y - 0.1);
        }
    }

    public void render() {
        GL11.glClear(16640);
        this.PRTest.enable();
        GL13.glActiveTexture(33984);
        int textureUniform = this.PRTest.getUniform("texSampler");
        GL20.glUniform1i(textureUniform, 0);
        float[] vec = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
        int vecUniform = this.PRTest.getUniform("uniColor");
        GL20.glUniform4fv(vecUniform, Utilities.createFloatBuffer(vec));
        Matrix4f proj = Matrix4f.perspective(70.0f, this.window.getAspect(), 1.0f, 1000.0f);
        Matrix4f view = Matrix4f.lookAt(new Vector3f(1.2f, 1.2f, 1.2f), new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.0f, 1.0f, 0.0f));
        Matrix4f model = Matrix4f.rotateY((float)GLFW.glfwGetTime() * 50.0f);
        model = Matrix4f.identity();
        view = Matrix4f.rotateY(-this.rot).multiply(Matrix4f.translate(this.camera.multiply(-1.0f)));
        Matrix4f total = proj.multiply(view);
        int ortho = this.PRTest.getUniform("PV");
        GL20.glUniformMatrix4fv(ortho, true, total.toFloatBuffer());
        this.meshBatch.render(this.mesh, this.TxTest.textureID, Matrix4f.translate(new Vector3f(-10.0f, 0.0f, 0.0f)));
        this.meshBatch.end();
        this.PRTest.disable();
        this.window.swapBuffers();
    }

    public void free() {
        this.TxTest.free();
        this.PRTest.free();
        this.meshBatch.free();
        this.window.destroy();
    }

    public void loop() {
        long counter = 0L;
        while (this.running) {
            ++counter;
            long time0 = System.nanoTime();
            this.update();
            this.render();
            if (this.window.shouldClose()) {
                this.running = false;
            }
            long dt = System.nanoTime() - time0;
            if (counter % 60L != 0L || dt == 0L) continue;
            System.out.println("FPS: " + 1.0 / ((double)dt / 1.0E9));
        }
    }
}

