var Texts = function(){
  PartBase.call(this);
  this.initScene();
};

Texts.prototype = PartBase.prototype.inheritance();

Texts.prototype.initScene = function(){
  PartBase.prototype.initScene.call(this);

  this.camera.position.set(0., 0., 200.);
//  this.createLetters();

  this.textObj = new THREE.Object3D();
  this.scene.add(this.textObj);

  this.createThings();
  this.createGreets();
  this.createCubes();
};


Texts.prototype.animate = function(timeStep, elapsedTime){
  PartBase.prototype.animate.call(this, timeStep, elapsedTime);
  
  this.cubes1.rotation.z += timeStep*2;
  this.cubes2.rotation.z -= timeStep;
  
  this.cubes1.rotation.y += timeStep;
  this.cubes2.rotation.y -= timeStep*2;
  
  this.cubes3.rotation.x += timeStep*2;
  this.cubes4.rotation.x -= timeStep;
  
  this.cubes3.rotation.y += timeStep;
  this.cubes4.rotation.y -= timeStep*2;
  
  //if(this.elapsed > 1) {
  if(elapsedTime > MUSIC.syncPoints.modulation){
    this.animateGreet("WideLoad");
  }


  //if(this.elapsed > 3) {
  if(elapsedTime > MUSIC.syncPoints.modulation+MUSIC.barLength){
    this.animateGreet("Nalleperhe");
  }
  
  //if(this.elapsed > 4) {
  if(elapsedTime > MUSIC.syncPoints.modulation+MUSIC.barLength*2){
    this.animateGreet("Quadtrip");
  }

  //if(this.elapsed > 6) {
  if(elapsedTime > MUSIC.syncPoints.modulation+MUSIC.barLength*3){
    this.animateGreet("Epoch");
  }
  
  //if(this.elapsed > 13 ) {
  if(elapsedTime > MUSIC.syncPoints.modulation+MUSIC.barLength*6){
    this.removeGreet("WideLoad");
    this.removeGreet("Nalleperhe");
    this.removeGreet("Quadtrip");
    this.removeGreet("Epoch");

  }
  

  //if(this.elapsed > 15) {
  if(elapsedTime > MUSIC.syncPoints.modulation+MUSIC.barLength*8){
    this.animateGreet("Primitive");
  }

  //if(this.elapsed > 16) {
  if(elapsedTime > MUSIC.syncPoints.modulation+MUSIC.barLength*9){
    this.animateGreet("Gluster");
  }
  
  //if(this.elapsed > 18) {
  if(elapsedTime > MUSIC.syncPoints.modulation+MUSIC.barLength*10){
    this.animateGreet("Mercury");
  }

  //if(this.elapsed > 19) {
  if(elapsedTime > MUSIC.syncPoints.modulation+MUSIC.barLength*11){
    this.animateGreet("REN");
  }


  //if(this.elapsed > 26 ) {
  if(elapsedTime > MUSIC.syncPoints.modulation+MUSIC.barLength*14){
    this.removeGreet("Primitive");
    this.removeGreet("Gluster");
    this.removeGreet("Mercury");
    this.removeGreet("REN");

  }
};

Texts.prototype.animateGreet = function(greet) {
  for(var i = 0; i<this.greetings[greet].textArr.length; i++) {
    var endp = this.greetings[greet].txtopts[i].endpos;
    var speed = this.greetings[greet].txtopts[i].speed
    this.animateText(this.greetings[greet].textArr[i], endp, speed);
  }
};

Texts.prototype.animateText = function(txtpart, endpos, speed) {
  if(txtpart.position.x > endpos) {
    if(Math.abs(txtpart.position.x-endpos) < speed) {
      txtpart.position.x = endpos;
    }
    txtpart.position.x -= speed;
  }

};


Texts.prototype.removeGreet = function(greet) {
  for(var i = 0; i<this.greetings[greet].textArr.length; i++) {
    var endp = -600;
    var speed = this.greetings[greet].txtopts[i].speed
    this.animateText(this.greetings[greet].textArr[i], endp, speed);
  }

}


Texts.prototype.createTextPart = function(txtpart) {
  var material = new THREE.MeshFaceMaterial( [
    new THREE.MeshLambertMaterial( { color: 0xCCCCCC/*0x00688B*/, shading: THREE.FlatShading, opacity: 0.9 } ),
    new THREE.MeshLambertMaterial( { color: 0xFF7D40 } )
  ] );
  
  var options = {
    size: 10,
    height: 25,
    curveSegments: 16,
    font: "helvetiker",
    
    bevelEnabled: true,
    bevelThickness: 2,
    bevelSize: 2,

    material: 0,
    extrudeMaterial: 1
  };
  
  var name = txtpart;
  
  var hash = document.location.hash.substr( 1 );
  if ( hash.length !== 0 ) {
    name = hash;
  } 
  var text3d = new THREE.TextGeometry( name, options);
  text3d.computeVertexNormals();
  text3d.computeBoundingBox();
  text3d.center();
  
  return new THREE.Mesh(text3d, material);
}; 


Texts.prototype.createTexts = function(txt, beginX, posY, posZ) {
  var txtArray = [];

  for(var i=0; i<txt.length; i++) {
    if(i<txt.length) {
      var txtpart = this.createTextPart(txt.substring(i, i+1));
    } else {
      var txtpart = this.createTextPart(txt[i-1]);
    }
    txtpart.position.x = beginX;
    txtpart.position.y = posY;
    txtpart.position.z = posZ;

    beginX += 14;
    this.textObj.add(txtpart);
    txtArray.push(txtpart);
  }
  
  return txtArray;
};

Texts.prototype.countTxtOpts = function(txtArr, endpos) {
  var txtopts = [];
  for(var i = 0; i<txtArr.length; i++) {
    var endp = txtArr[i].position.x+endpos;
    var speed = (Math.random()+0.5)*5;
    txtopts.push({endpos : endp, speed :speed });
  }
  
  return txtopts;
}


Texts.prototype.createGreets = function() {
  this.greetings = {};
  
  this.greetings.WideLoad = new Greet("WideLoad", 300, 30, 0, 5, -300);//nimi, x, y, z, offset (aika)
  this.greetings.Nalleperhe = new Greet("Nalleperhe", 300, -15, 0, 10, -350);//createTexts("toinen",300,0,0);
  this.greetings.Quadtrip = new Greet("Quadtrip",300,-30,0, 15, -400);
  this.greetings.Epoch = new Greet("Epoch", 300, 6, 0, 5, -290);
  
  this.greetings.Primitive = new Greet("Primitive", 300, 30, 0, 5, -400);//nimi, x, y, z, offset (aika)
  this.greetings.Gluster = new Greet("Gluster", 300, -10, 0, 10, -290);//createTexts("toinen",300,0,0);
  this.greetings.Mercury = new Greet("Mercury",300,-30,0, 15, -330);
  this.greetings.REN = new Greet("REN", 300, 5, 0, 10, -360);//createTexts("toinen",300,0,0);


  
  for(greet in this.greetings) {
    this.greetings[greet].textArr = this.createTexts(this.greetings[greet].name, this.greetings[greet].xpos, this.greetings[greet].ypos, this.greetings[greet].zpos);
    this.greetings[greet].txtopts = this.countTxtOpts(this.greetings[greet].textArr, this.greetings[greet].endpos);
  }
};

Texts.prototype.createThings = function() {  
  var directionalLight = new THREE.DirectionalLight( 0xD9D9F3, 0.5 );
  directionalLight.position.set( 0, -1, 1 );
  directionalLight.position.normalize();
  this.scene.add( directionalLight );
};


var Greet = function(name, xpos, ypos, zpos, startOffset, endpos) {
  this.name = name;
  this.offset = startOffset;
  this.xpos = xpos;
  this.ypos = ypos;
  this.zpos = zpos;
  this.endpos = endpos;
};

Texts.prototype.createCubes = function(){
  var amount = 5;
  this.cubesAll = new THREE.Object3D();
  this.cubes1 = new THREE.Object3D();
  this.cubes2 = new THREE.Object3D();
  this.cubes3 = new THREE.Object3D();
  this.cubes4 = new THREE.Object3D();
  this.cubesAll.add(this.cubes1);
  this.cubesAll.add(this.cubes2);
  this.cubesAll.add(this.cubes3);
  this.cubesAll.add(this.cubes4);
  var material = new THREE.MeshPhongMaterial({
    color : 0xFF7D40,//0x525052,
    ambient : 0xFF7D40,
    emissive : 0xFF7D40,//0x855285,
    specular : 0x990099,//
  });
  
  var material2 = new THREE.MeshPhongMaterial({
    color : 0x990099,//0x525052,
    ambient : 0x990099,
    emissive : 0x990099,//0x855285,
    specular : 0xFF7D40,//
  });
  
  for(var i = 0; i < amount; ++i){
    var mat = material;
    if(i%2 == 0){
      mat = material2;
    }
    var cube = new THREE.Mesh(new THREE.BoxGeometry(10, 10, 10), mat);
    if(i == 0){
      cube.position.x = 30;
      cube.position.y = 0;
      cube.position.z = -20;
    }
    else if(i == 1){
      cube.position.x = 30;
      cube.position.y = -20;
      cube.position.z = 15;
    }
    else if(i == 2){
      cube.position.x = -15;
      cube.position.y = -15;
      cube.position.z = -15;
    }
    else if(i == 3){
      cube.position.x = -20;
      cube.position.y = 20;
      cube.position.z = 20;
    }
    else{
      cube.position.x = 0;
      cube.position.y = 30;
      cube.position.z = -5;
    }
    this.cubes1.add(cube);
    this.cubes2.add(cube.clone());
    this.cubes3.add(cube.clone());
    this.cubes4.add(cube.clone());
  }
  
  this.cubes1.position.x = 200;
  this.cubes2.position.x = -200;
  this.cubes3.position.x = 200;
  this.cubes4.position.x = -200;
  
  this.cubes1.position.y = 100;
  this.cubes2.position.y = -100;
  this.cubes3.position.y = -100;
  this.cubes4.position.y = 100;
  
  this.cubes1.position.z = -90;
  this.cubes2.position.z = -90;
  this.cubes3.position.z = -90;
  this.cubes4.position.z = -90;
  
  this.scene.add(this.cubesAll);
}

