varying vec2 v_uv;
varying vec2 v_pos;

uniform vec2 u_b1;
uniform vec2 u_b2;


#ifdef VERTEX

attribute vec2 a_pos;
attribute vec2 a_uv;


void vfunction()
{
	//vec2 scaledpos = (a_pos - vec2(0.5)) * 1.0;
	vec2 scaledpos = mix(u_b1, u_b2, a_pos);
	gl_Position = vec4(scaledpos, 0.0, 1.0);
	v_uv = a_uv;
	v_pos = scaledpos;
}

#endif

#ifdef FRAGMENT
vec4 function()
{
	vec2 wsz = vec2(212.0, 79.0);
	vec2 middle = vec2(154.0, 49.0) / wsz;
	middle.y = 1.0-middle.y;

	vec2 war = vec2(1.0, wsz.x/wsz.y);


	vec3 col;
	vec2 w95uv;

	float ft = u_time;

	w95uv = middle;


	float leftsize = 0.3;
	float rightsize = 0.12;

	float upsize = 0.06;
	float downsize = 0.095;

	leftsize /= u_aspect;
	rightsize /= u_aspect;



	vec2 pp = v_pos;

	if ((pp.x-u_b1.x) < leftsize)
		w95uv.x = mix(0.0, middle.x, (pp.x-u_b1.x)/leftsize);
	if ((pp.y-u_b1.y) < upsize)
		w95uv.y = mix(0.0, middle.y, (pp.y-u_b1.y)/upsize);

	if (pp.x > (u_b2.x - rightsize))
		w95uv.x = mix(middle.x, 1.0,(pp.x-(u_b2.x - rightsize))/rightsize);
	if (pp.y > (u_b2.y - downsize))
		w95uv.y = mix(middle.y, 1.0,(pp.y-(u_b2.y - downsize))/downsize);



	w95uv = clamp(w95uv, vec2(0.0), vec2(1.0));



	col = texture2D(iChannel1, w95uv).rgb;

	vec2 upleft = vec2(0.008, 0.048);
	vec2 downright = vec2(0.014, 0.084);

	upleft.x /= u_aspect;
	downright.x /= u_aspect;

	vec2 bb1 = u_b1 + upleft;
	vec2 bb2 = u_b2 - downright;

	vec2 cuv = (pp-bb1) / (bb2-bb1);

	if (cuv.x >= 0.0 && cuv.x < 1.0 && cuv.y >= 0.0 && cuv.y < 1.0)
	{
		cuv -= vec2(0.5);
		cuv += vec2(0.5);
		col = texture2D(iChannel0, cuv).rgb;
	}



	
	return vec4(col, 0.0);
}
#endif
