package uselessUtility;

import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.*;

import java.util.Random;

public class UselessCalculator extends JFrame implements ActionListener {
	
	private JLabel overviewLabel = new JLabel();
	private JButton[] numberButtons = new JButton[9];
	private JButton zeroButton = new JButton();
	private JButton resetButton = new JButton();
	private JButton equalsButton = new JButton();
	private JButton questionMarkButton = new JButton();
	private JPanel panel = new JPanel();
	private JPanel panelEquals = new JPanel();
	private JPanel panelButton = new JPanel(new GridLayout(4, 3));
	private String bigNumber = "";
	private int number1 = -1;
	private int number2 = -1;
	private boolean questionPressed = false;
	private boolean equalsPressed = false;
	
	public static void main(String [] args) {
		new UselessCalculator();
	}
	
	public UselessCalculator () {
		setTitle("Useless Calculator");
		panel.add(overviewLabel, BorderLayout.NORTH);
		overviewLabel.setText("0");
		
		add(panel, BorderLayout.NORTH);
		add(panelButton, BorderLayout.CENTER);
		add(panelEquals, BorderLayout.SOUTH);
		for(int i = 0; i < numberButtons.length; i++) {
			numberButtons[i] = createButton(Integer.toString(i + 1));
		}
		
		resetButton = createButton("C");
		zeroButton = createButton("0");
		questionMarkButton = createButton("?");
		equalsButton = createEqualsButton("=");
		
		setDefaultCloseOperation(EXIT_ON_CLOSE);
		setLocationRelativeTo(null);
		setPreferredSize(new Dimension(200,200));
		pack();
		setVisible(true);
	}
	
	public void actionPerformed (ActionEvent a) {
			
		JButton source = (JButton) a.getSource();
		
		if (numberButtonsContainsButton(source) || source == zeroButton) {
			bigNumber += source.getText();
			overviewLabel.setText(bigNumber);
		}
		else if (source == resetButton) {
			System.out.println("Reset");
			overviewLabel.setText("0");
		}
		else if(source == questionMarkButton){
			number1 = Integer.parseInt(overviewLabel.getText());
			bigNumber = "";
			overviewLabel.setText("0");
			questionPressed = true;
		}
		else if (source == equalsButton) {
			if(questionPressed == false){
				number1 = Integer.parseInt(overviewLabel.getText());
				bigNumber = "";
				overviewLabel.setText("0");
			}	
			if(equalsPressed == true){
				bigNumber = "";
				overviewLabel.setText("0");
				equalsPressed = false;
			}
			equalsPressed = true;
			int sum = 0;
			number2 = Integer.parseInt(overviewLabel.getText());
			Random rand = new Random();
			int randomOperator = rand.nextInt(5);
			
			if(number1 != -1 && number2 != -1){
				switch (randomOperator) {
				
				case 0:
					sum = number1 + number2;
					break;
				case 1:
					sum = number1 - number2;
					break;
				case 2:
					sum = number1 * number2;
					break;
				case 3:
					sum = number1 / number2;
					break;
				case 4:
					sum = (number1*number1) * (number2*number2);
					break;
				}
			}else{
				overviewLabel.setText("wrong input, press C!");
			}
			overviewLabel.setText(Integer.toString(sum));
			number1 = -1;
			number2 = -2;
			bigNumber = "";
		}
	}
	
	private boolean numberButtonsContainsButton(JButton source) {
		for(int i = 0; i < numberButtons.length; i++) {
			if(numberButtons[i] == source) return true;
		}
		return false;
	}
	
	private JButton createButton(String text) {
		JButton button = new JButton(text);
		button.addActionListener(this);
		panelButton.add(button, BorderLayout.SOUTH);
		return button;
	}
	private JButton createEqualsButton(String text) {
		JButton button = new JButton(text);
		button.addActionListener(this);
		panelEquals.add(button, BorderLayout.SOUTH);
		return button;
	}
}
