import sys
sys.path.append("..")
import random
import pprint
from coord import Coord
from connector import GameConnector
from world import World


class Bot(object):
    debug = False
    name = "TelcBot"
    gc = None
    mapData = World(Coord(x=0, y=0), [])
    enemies = None
    wait = True
    target = Coord(x=3, y=3)

    def __init__(self, hostname="localhost", port="54321"):
        self.gc = GameConnector(self.name)

        self.gc.handler_mapdata = self.mapUpdate
        self.gc.handler_ownposition = self.ownPosition
        self.gc.handler_enemylist = self.enemyList
        self.gc.handler_commandrequest = self.makeChoice
        self.gc.handler_bomblist = self.bombList
        self.gc.handler_endround = self.endOfRound
        self.gc.handler_dead = self.dead

#        self.gc.connect("77.234.48.103", 54321)
#        self.gc.connect("90.146.44.79", 54321)
        self.gc.connect(hostname, int(port))

        self.mapData.debug = self.debug

    def run(self):
        self.gc.parsingLoop()

    def dead(self):
        pass

    def endOfRound(self):
        pass

    def bombList(self, bombs):
        if self.debug:
            print "There are {0} bombs on the map".format(len(bombs))
        self.mapData.updateBombs(bombs)

    def newTarget(self):
        self.target = self.closestEnemy()

    def closestEnemy(self):
        minDist = 100000
        target = None
        for player in self.enemies:
            pos = Coord(x=player["x"], y=player["y"])
            dist = pos.distance(self.ownPosition)
            if dist < minDist:
                minDist = dist
                target = pos;
        return target

    def makeChoice(self):
        # Find new target
        self.newTarget()
        if self.mapData.isDeadly(self.ownPosition):
            return self.mapData.escapeDanger(self.ownPosition)

        enemy = self.closestEnemy()
        if enemy and enemy.distance(self.ownPosition) <= 2:
            return "BOMB"
        moves = self.mapData.search(self.ownPosition, self.target)
        if self.debug:
            print "Moves: {0}".format(moves)

        if moves == None:
            self.newTarget()

        if moves != None and len(moves) > 0:
            firstMove = self.mapData.moveRequired(self.ownPosition, moves[0])
            return firstMove
        else:
            return None

    def enemyList(self, enemies):
        if self.debug:
            print "There are {0} enemies playing".format(len(enemies))
        self.enemies = enemies
        self.mapData.enemies = enemies

    def ownPosition(self, ownPosition):
        if self.debug:
            print "I am at {0}".format(ownPosition)
        self.ownPosition = ownPosition

    def mapUpdate(self, mapSize, mapTiles):
        if self.debug:
            print "Map is {0}".format(mapSize)
        self.mapData.update(mapSize, mapTiles)


if __name__ == "__main__":
    bot = None
    if len(sys.argv) > 2:
        bot = Bot(sys.argv[1], sys.argv[2])
    elif len(sys.argv) > 1:
        bot = Bot(sys.argv[1])
    else:
        bot = Bot()
        
    bot.run()
