import socket               # Import socket module
import random
from time import sleep
import  json
import math

so = socket.socket()         # Create a socket object
host = socket.gethostname() # Get local machine name
port = 54321                # Reserve a port for your service.
lastDir = -1

so.connect((host, port))
so.send(b"NAME GrimBot\n")
so.send(b"JSON\n")

def numBlocks(gamemap):
    numBlocks = 0
    for i in range(len(gamemap[0])):
        for j in range(len(gamemap[0][i])):
            if(gamemap[0][i][j] == "#"):
                numBlocks += 1
    return numBlocks

def findLength(startX, startY, endX, endY):
    length = math.sqrt(math.pow(math.fabs(endX - startX), 2) + math.pow(math.fabs(endY - startY), 2))
    return length

def findPlayer(players, x, y, gamemap):
    shortestX = gamemap[1]
    shortestY = gamemap[2]
    shortestLen = gamemap[1]*gamemap[2]
    for  i in range(len(players)):
        length = findLength(x, y, players[i]["x"], players[i]["y"])
        if(length < shortestLen):
            shortestLen = length
            shortestX = players[i]["x"]
            shortestY = players[i]["y"]
    moveTowards(x, y, shortestX, shortestY, gamemap)
        

def findBlock(gamemap, x, y):
    shortestX = gamemap[1]
    shortestY = gamemap[2]
    shortestLen = gamemap[1]*gamemap[2]
    for i in range(len(gamemap[0])):
        for j in range(len(gamemap[0][i])):
            if(gamemap[0][i][j] == "#"):
                length = findLength(x, y, j, i)
                if(length < shortestLen):
                    shortestLen = length
                    shortestX = j
                    shortestY = i
    moveTowards(x, y, shortestX, shortestY, gamemap)
                    
def moveTowards(x, y, endX, endY, gamemap):
    if(endX > x):
        if(gamemap[0][y][x+1] == "."):
            cmd(0)
        else:
            cmd(random.randint(0,3))
    elif(endX < x):
        if(gamemap[0][y][x-1] == "."):
            cmd(2)
        else:
            cmd(random.randint(0,3))
    elif(endY > y):
        if(gamemap[0][y+1][x] == "."):
            cmd(3)
        else:
            trace("ye")
            cmd(random.randint(0,3))
    elif(endY < y):
        if(gamemap[0][y-1][x] == "."):
            cmd(1)
        else:
            cmd(random.randint(0,3))

def checkSurround(gamemap, x, y):
    intel = []
    temp = []
    temp.append(gamemap[0][y][x+1])
    temp.append(gamemap[0][y-1][x])
    temp.append(gamemap[0][y][x-1])
    temp.append(gamemap[0][y+1][x])
    solid = 0
    canblow = 0
    for i in range(0, len(temp)):
        if(temp[i] == "+"):
            solid+=1
        elif(temp[i] == "#"):
            canblow+=1
    intel.append(temp)
    intel.append(solid)
    intel.append(canblow)
    return intel

def cmd(dir):
    global lastDir
    print(dir)
    if(dir == 0):
        lastDir = 2
        so.send(b"RIGHT\n")
    elif(dir == 1):
        lastDir = 3
        so.send(b"UP\n")
    elif(dir == 2):
        lastDir = 0
        so.send(b"LEFT\n")
    elif(dir == 3):
        lastDir = 1
        so.send(b"DOWN\n")
    elif(dir==4):
        so.send(b"BOMB\n")
    
def escapeRoutes(gamemap, x, y, bx, by):
    if(y == by and x == bx):
        if(gamemap[0][y][x+1] == "."):
            if(gamemap[0][y+1][x+1] == "." or gamemap[0][y-1][x+1] == "."):
                cmd(0)
                return
            elif((gamemap[0][y+1][x+2] == "." or gamemap[0][y-1][x+2] == ".") and gamemap[0][y][x+2] == "."):
                cmd(0)
                return
        elif(gamemap[0][y][x-1] == "."):
            if(gamemap[0][y+1][x-1] == "." or gamemap[0][y-1][x-1]  == "."):
                cmd(2)
                return
            elif((gamemap[0][y+1][x-2] == "." or gamemap[0][y-1][x-2] == ".") and gamemap[0][y][x-2] == "."):
                cmd(2)
                return
        if(gamemap[0][y+1][x] == "."):
            if(gamemap[0][y+1][x+1] == "." or gamemap[0][y+1][x-1]  == "."):
                cmd(3)
                return
            elif((gamemap[0][y+2][x+1] == "." or gamemap[0][y+2][x-1] == ".") and gamemap[0][y+2][x] == "."):
                cmd(3)
                return
        elif(gamemap[0][y-1][x] == "."):
            if(gamemap[0][y-1][x+1] == "." or gamemap[0][y-1][x-1]  == "."):
                cmd(1)
                return
            elif((gamemap[0][y-2][x+1] == "." or gamemap[0][y-2][x-1] == ".") and gamemap[0][y-2][x] == "."):
                cmd(1)
                return
        
    if(y == by):
        if(gamemap[0][y-1][x] == "."):
            cmd(1)
            return
        elif(gamemap[0][y+1][x] == "."):
            cmd(3)
            return
        elif(gamemap[0][y][x+1] == "." and x >= bx):
            if(gamemap[0][y+1][x+1] or gamemap[0][y-1][x+1]  == "."):
                cmd(0)
                return
            elif((gamemap[0][y+1][x+2] == "." or gamemap[0][y-1][x+2] == ".") and gamemap[0][y][x+2] == "."):
                cmd(0)
                return
        elif(gamemap[0][y][x-1] == "." and x <= bx):
            if(gamemap[0][y+1][x-1] == "." or gamemap[0][y-1][x-1]  == "."):
                cmd(2)
                return
            elif((gamemap[0][y+1][x-2] == "." or gamemap[0][y-1][x-2] == ".") and gamemap[0][y][x-2] == "."):
                cmd(2)
                return
    if(x == bx):
        if(gamemap[0][y][x-1] == "."):
            cmd(2)
            return
        elif(gamemap[0][y][x+1] == "."):
            cmd(0)
            return
        elif(gamemap[0][y+1][x] == "." and y >= by):
            if(gamemap[0][y+1][x+1] == "." or gamemap[0][y+1][x-1]  == "."):
                cmd(3)
                return
            elif((gamemap[0][y+2][x+1] == "." or gamemap[0][y+2][x-1] == ".") and gamemap[0][y+2][x] == "."):
                cmd(3)
                return
        elif(gamemap[0][y-1][x] == "." and y <= by):
            if(gamemap[0][y-1][x+1] == "." or gamemap[0][y-1][x-1]  == "."):
                cmd(1)
                return
            elif((gamemap[0][y-2][x+1]== "." or gamemap[0][y-2][x-1]== ".") and gamemap[0][y-2][x] == "."):
                cmd(1)
                return
    
while True:
    sleep(0.1)
    rawdata = str(so.recv(1024))
    if("dead" in rawdata):
        print("dead")
    else:
        #Get data from server
        newdata = rawdata[2:len(rawdata)-3]
        try:
            decoded_data = json.loads(newdata)
        except ValueError:
            continue
        player_data = []
        bombs_data = []
        map_data = []
        my_pos = []
        if(decoded_data["type"] == "status update"):
            for i in range(0, len(decoded_data["players"])):
                player_data.append((decoded_data["players"][i]))
            map_data.append(decoded_data["map"])
            map_data.append(decoded_data["width"])
            map_data.append(decoded_data["height"])
            for i in range(0, len(decoded_data["bombs"])):
                bombs_data.append((decoded_data["bombs"][i]))
            my_pos.append(decoded_data["x"])
            my_pos.append(decoded_data["y"])

            #The AI
            #Reactive
            bombsInRange = 0
            playersInRange = 0
            for i in range(0, len(bombs_data)):
                if((math.fabs(bombs_data[i]["y"]-my_pos[1]) <= 2) and (math.fabs(bombs_data[i]["x"]-my_pos[0]) <= 2)):
                    escapeRoutes(map_data, my_pos[0], my_pos[1], bombs_data[i]["x"], bombs_data[i]["y"])
                    bombsInRange += 1
            if(bombsInRange == 0):
                 surr = checkSurround(map_data, my_pos[0], my_pos[1])
                 for i in range(0, len(player_data)):
                     if((math.fabs(player_data[i]["y"]-my_pos[1]) <= 1) and (math.fabs(player_data[i]["x"]-my_pos[0]) <= 1)):
                         print("hah")
                         cmd(4)
                         playersInRange += 1
                 if(playersInRange == 0):
                     if(surr[2] > 0):
                        cmd(4)
                     elif(surr[1] > 1):
                         for i in range(0, len(surr[0])):
                             if(surr[0][i] == "." and lastDir != i):
                                 cmd(i)
                     elif(numBlocks(map_data) > 0):
                        print("ye")
                        findBlock(map_data, my_pos[0], my_pos[1])
                     elif(len(player_data) > 0):
                        findPlayer(player_data, my_pos[0], my_pos[1], map_data)
                        
s.close
