#include "OdinAI/OdinAIRoot.h"
#include "OdinAI/Timer.h"
namespace OdinAI
{
	OdinAIRoot::OdinAIRoot():
		m_isRunning(false)
	{

	}

	bool OdinAIRoot::Init(int argc, char** argv)
	{
		if(!Timer::Init())
            return false;

		if (!OnInit(argc, argv))
			return false;

		return true;
	}

	void OdinAIRoot::Loop()
	{
		m_isRunning = true;
		
		while (m_isRunning)
		{
			m_networkManager.Update();
			m_eventManager.Update();
			
			if(!OnLoop())
            {
                m_isRunning = false;
            }
		}
	}

    EventManager &OdinAIRoot::GetEventMgr()
    {
        return m_eventManager;
    }

    NetworkManager &OdinAIRoot::GetNetworkMgr()
    {
        return m_networkManager;
    }
}
