#include "MoveToGoal.h"
#include "GameManager.h"
#include "Player.h"
#include "FollowPathGoal.h"
#include "GameManager.h"

void MoveToGoal::Activate()
{
    m_status = OdinAI::GOAL_ACTIVE;
    AddGoal(new FollowPathGoal(m_pOwner, gGameMgr.GetMap().GetPath(m_pOwner->GetPosition(), m_target), true));
}

int MoveToGoal::Process()
{
    ActivateIfInactive();

    m_status = ProcessSubgoals();

    if(m_status == OdinAI::GOAL_FAILED || (m_status == OdinAI::GOAL_COMPLETE && m_pOwner->GetPosition() != m_target))
    {
        m_status = OdinAI::GOAL_FAILED;
    }

    return m_status;
}

void MoveToGoal::OnMapChanged(const OdinAI::Event *pEvent)
{
    Clear();
    Activate();
}

void MoveToGoal::SetTarget(const iVec2 &target)
{
    m_target = target;
}

const iVec2 &MoveToGoal::GetTarget() const
{
    return m_target;
}

void MoveToGoal::End()
{
    gGameMgr.GetEventMgr().RemoveEventListener("mapChanged", std::bind(&MoveToGoal::OnMapChanged, this, std::placeholders::_1), this);
}