#include "FollowPathGoal.h"
#include "TraverseEdgeGoal.h"
#include "BombGoal.h"
#include "GameManager.h"

void FollowPathGoal::Activate()
{
    m_status = OdinAI::GOAL_ACTIVE;

    if(m_path.size() > 1)
    {
        if(m_destroyWalls)
        {
            auto nodeA = *m_path.begin();
            auto nodeB = *(++m_path.begin());

            if(gGameMgr.GetMap().CanTileBeDestroyed(gGameMgr.GetMap().GetTile(nodeB)))
            {
                AddGoal(new BombGoal(m_pOwner));
            }
            else
            {
                AddGoal(new TraverseEdgeGoal(m_pOwner, OdinAI::GraphEdge(*(m_path.begin()), *(++m_path.begin()))));
            }
        }
        else
        {
            AddGoal(new TraverseEdgeGoal(m_pOwner, OdinAI::GraphEdge(*(m_path.begin()), *(++m_path.begin()))));
        }
    }
}

int FollowPathGoal::Process()
{
    ActivateIfInactive();
    m_status = ProcessSubgoals();

    if(m_status == OdinAI::GOAL_COMPLETE)
    {
        if(m_path.size() > 1) 
        {
            m_path.pop_front();
            Activate();
        }
    }

    return m_status;
}

void FollowPathGoal::End()
{
}