#ifndef DNB_EXPLORE_GOAL_H_
#define DNB_EXPLORE_GOAL_H_

#include "OdinAI/Goals.h"
#include "OdinAI/Event.h"

class Player;

/**
 * Explore goal is used when we don't have anything else to do.
 * It will just go around and bomb as much as possible.
 */
class ExploreGoal : public OdinAI::CompositeGoal
{
public:
    ExploreGoal(Player *pPlayer);

	/**
	 * Function called before a goal is processed.
	 */
	void Activate();

	/**
	 * Function used to process goal.
	 */
	int Process();

    /**
     * Callback when map changed.
     */
    void OnMapChanged(const OdinAI::Event *pEvent);

	/**
	 * Function used to clean up an goal.
	 */
	void End();
private:
    Player *m_pPlayer;
};

#endif