#ifndef DNB_EVALUATORS_H_
#define DNB_EVALUATORS_H_

#include <vector>
#include "OdinAI/Goals.h"
#include "FleeGoal.h"

class Player;

/**
 * Base class for evaluation.
 * Calculates the desireability, the number returned should be between 0 - 100.
 */
class Evaluator
{
public:
    virtual double Desireability() const {return 0.0;}

    virtual OdinAI::BaseGoal *GetGoal() const {return nullptr;}
};

/**
 * A class for bomb risk evaluation.
 */
class BombRiskEval : public Evaluator
{
public:
    BombRiskEval(Player *pPlayer, const std::vector< std::vector<char> > &map) : m_pPlayer(pPlayer), m_map(map) {}

    double Desireability() const;

    OdinAI::BaseGoal *GetGoal() const
    {
        return new FleeGoal(m_pPlayer, m_map);
    }
private:
    Player *m_pPlayer;
    const std::vector< std::vector<char> > &m_map;
};

#endif