#ifndef DNB_BOMB_GOAL_H_
#define DNB_BOMB_GOAL_H_

#include "OdinAI/Goals.h"
#include <list>
#include <vector>

class Player;

/**
 * Bomb goal is used when the AI should drop a bomb.
 * It will calculate an escape path. The goal will fail if there are no escape path.
 */
class BombGoal : public OdinAI::AtomicGoal
{
public:
    BombGoal(Player *pPlayer) : m_pPlayer(pPlayer) {}

    /**
     * Function called before a goal is processed.
     */
    void Activate();

    /**
     * Function used to process goal.
     */
    int Process();

    /**
     * Function used to clean up an goal.
     */
    void End();
private:
    Player *m_pPlayer;
};

#endif