/*******************************************************************************
 * ________       .___.__           _____  .___ 
 * \_____  \    __| _/|__| ____    /  _  \ |   |
 *  /   |   \  / __ | |  |/    \  /  /_\  \|   |
 * /    |    \/ /_/ | |  |   |  \/    |    \   |
 * \_______  /\____ | |__|___|  /\____|__  /___|
 *         \/      \/         \/         \/     
 *
 * Copyright (c) Emil Sandst 2012
 *******************************************************************************/
#ifndef ODINAI_ODINAIROOT_H
#define ODINAI_ODINAIROOT_H

#include "OdinAI/NetworkManager.h"
#include "OdinAI/EventManager.h"
namespace OdinAI
{
	class OdinAIRoot
	{
	public:
		OdinAIRoot();
		
		/**
		 * @brief Inits all OdinAI systems
		 * 
		 * @return True on success
		 */
		bool Init(int argc, char** argv);
		
		/**
		 * @brief Enters the main loop, executes until OdinAIRoot::Halt() is called
		 */
		void Loop();

        /**
         * @return The event manager. 
         */
        EventManager &GetEventMgr();

        /**
         * @return The network manager.
         */
        NetworkManager &GetNetworkMgr();
	protected:
		void Halt() { m_isRunning = false; };

		EventManager m_eventManager;
		NetworkManager m_networkManager;
	private:
		/**
		 * @brief OdinAIRoot runs this method on each iteration of the main loop
		 * 
		 * AI implementations should implement this method to update implementation spesific systems
		 */
		virtual bool OnLoop() { return true; };
		
		/**
		 * @brief OdinAIRoot runs this method when Init() is called
		 * 
		 * AI implementations should implement this method to init implementation spesific systems
		 * 
		 * @return True on success
		 */
		virtual bool OnInit(int argc, char** argv) { return true; };
		bool m_isRunning;
	
	};
}

#endif