/*******************************************************************************
 * ________       .___.__           _____  .___ 
 * \_____  \    __| _/|__| ____    /  _  \ |   |
 *  /   |   \  / __ | |  |/    \  /  /_\  \|   |
 * /    |    \/ /_/ | |  |   |  \/    |    \   |
 * \_______  /\____ | |__|___|  /\____|__  /___|
 *         \/      \/         \/         \/     
 *
 * Copyright (c) Emil Sandst 2012
 *******************************************************************************/
#ifndef ODINAI_DEBUG_UTIL_H
#define ODINAI_DEBUG_UTIL_H

#ifdef _WINDOWS
#pragma once
#endif

#include <cassert>
#include <iostream>

namespace OdinAI
{
	#ifdef SAFE_VERSION
		#ifdef NDEBUG
			#define Assert(x) (if(!x){return;})
		#else
			#define Assert(x) (assert(x))
		#endif
	#else
		#define Assert(x)
	#endif

#ifdef _DEBUG
	inline void DebugMessage(const char *msg)
	{
		std::cout << msg << std::endl;
	}
#else
    inline void DebugMessage(const char *msg)
	{
	}
#endif

	//Assertion with message
	#define AssertMsg(x, msg) (DebugMessage(msg);assert(x);)

	//Free heap allocated memory safely.
	#define SAFE_DELETE(x) if(x){delete x;x=nullptr;}
	#define SAFE_DELETE_ARRAY(x) if(x){delete[]x;x=nullptr;}

	//User defined Compiler warning
	#ifdef _MSC_VER
		#define __STR2__(x) #x
		#define __STR1__(x) __STR2__(x)
		#define __LOC__ __FILE__ "("__STR1__(__LINE__)") : Warning Msg: "
		#define CompilerWarning(x) message(__LOC__ x)
	#else
		#define CompilerWarning(x)
	#endif
}
#endif