package com.petterroea.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URLEncoder;
import java.security.MessageDigest;

public class MiscUtils {
	public static OS getPlatform() {
		  String osName = System.getProperty("os.name").toLowerCase();
		  if (osName.contains("win")) return OS.windows;
		  if (osName.contains("mac")) return OS.macos;
		  if (osName.contains("solaris")) return OS.solaris;
		  if (osName.contains("sunos")) return OS.solaris;
		  if (osName.contains("linux")) return OS.linux;
		  if (osName.contains("unix")) return OS.linux;
		  return OS.unknown;
	}
	public static String getOsName()
	{
		OS platform = getPlatform();
		if(platform==OS.windows) return "windows";
		if(platform==OS.linux) return "linux";
		if(platform==OS.macos) return "macosx";
		if(platform==OS.solaris) return "solaris";
		return "unknown";
	}
	public static enum OS
	{
		linux, solaris, windows, macos, unknown;
	}
	public static String makeSafeForArgs(String s)
	{
		if(!s.contains(" ")) return s;
		return "\""+s+"\"";
	}
	public static String getMd5(byte[] bytes)
	{
		try {
			MessageDigest md = MessageDigest.getInstance("MD5");
			md.update(bytes);
			byte[] digest = md.digest();
			String res = "";
			String tmp = "";
			for (int i = 0; i < digest.length; i++) {
				tmp = (Integer.toHexString(0xFF & digest[i]));
				if (tmp.length() == 1) {
					res += "0" + tmp;
				} else {
					res += tmp;
				}
			}
			res = URLEncoder.encode(res, "UTF-8");
			return res;
		} catch(Exception e) {
			e.printStackTrace();
		}
		return "";
	}
	public static byte[] toSubArray(byte[] contents, int start, int end)
	{
		if(end > contents.length) throw new RuntimeException("End index longer then array size");
		if(start < 0) throw new RuntimeException("Start index smaller then 0");
		if(start>end) throw new RuntimeException("Start index larger then end index");
		if(start==end) throw new RuntimeException("Start index is end index");
		
		int len = end-start;
		byte[] returnable = new byte[len];
		
		for(int i = 0; i < returnable.length; i++)
		{
			returnable[i] = contents[i+start];
		}
		return returnable;
	}
	
	public static boolean toBool(byte b)
	{
		if(b==1) return true;
		return false;
	}
	public static byte boolToByte(boolean in)
	{
		if(in) return 1;
		return 0;
	}
	public static String byteArrayToString(byte[] array)
	{
		StringBuilder sb = new StringBuilder();
		
		for(int i = 0; i < array.length; i++)
		{
			sb.append(Integer.toString(array[i], 16));
			if(i!=array.length-1) sb.append(" ");
		}
		
		return sb.toString();
	}
	public static boolean arrayContains(String[] array, String name)
	{
		for(int i = 0; i < array.length; i++)
		{
			if(array[i].equals(name)) return true;
		}
		return false;
	}
	public static void printArray(int[] array)
	{
		System.out.print("[");
		for(int i = 0; i < array.length; i++)
		{
			System.out.print(array[i]);
			if(i!=array.length-1)
			{
				System.out.print(", ");
			}
		}
		System.out.println("]");
	}
	public static void printArray(byte[] array)
	{
		System.out.print("[");
		for(int i = 0; i < array.length; i++)
		{
			System.out.print(array[i]);
			if(i!=array.length-1)
			{
				System.out.print(", ");
			}
		}
		System.out.println("]");
	}
	public static void printArray(short[] array)
	{
		System.out.print("[");
		for(int i = 0; i < array.length; i++)
		{
			System.out.print(array[i]);
			if(i!=array.length-1)
			{
				System.out.print(", ");
			}
		}
		System.out.println("]");
	}
}
