package com.petterroea.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
/**
 * Contains different functions related to command line, including promting the user
 * @author petterroea
 * @since Commit 2
 */
public class CommandLineUtils
{
	private static BufferedReader br;
	/**
	 * Sets the BufferedReader to use for input
	 * @param reader
	 * @since Commit 3
	 */
	public static void setBufferedReader(BufferedReader reader)
	{
		br = reader;
	}
	/**
	 * Sets the InputStream to use for input
	 * @param stream
	 * @since Commit 3
	 */
	public static void setInputStream(InputStream stream)
	{
		br = new BufferedReader(new InputStreamReader(stream));
	}
	public static String getInput()
	{
		if(br == null)
		{
			br = new BufferedReader(new InputStreamReader(System.in));
		}
		try {
			return br.readLine();
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return "";
	}
	public static int getIntFromInput(String query)
	{
		String str = "";
		while(str.equals("")||!MathUtils.isInt(str))
		{
			System.out.println(query);
			str = getInput();
		}
		return Integer.parseInt(str);
	}
	public static float getFloatFromInput(String query)
	{
		String str = "";
		while(str.equals("")||!MathUtils.isFloat(str))
		{
			System.out.println(query);
			str = getInput();
		}
		return Float.parseFloat(str);
	}
	public static boolean yn() {
		String in = "";
		while(!in.equalsIgnoreCase("y")&&!in.equalsIgnoreCase("n"))
		{
			in = getInput();
		}
		if(in.equalsIgnoreCase("y")) return true;
		return false;
	}
	public static File promptFile(String missing) {
		System.out.println("The value \""+missing+"\" is missing from the config file. What do you want it to be?(Filename)");
		while(true)
		{
			System.out.print("What file do you want to use?: ");
			String in = CommandLineUtils.getInput();
			File f = new File(in);
			if(f.exists()) return f;
			System.out.println("Hmm... Please try that again...");
		}
	}
	public static int promptInt(String missing, int startRange, int endRange)
	{
		System.out.println("The value \""+missing+"\" is missing from the config file. What do you want it to be? Range: " + startRange + " - " + endRange);
		while(true)
		{
			int in = CommandLineUtils.getIntFromInput("What do you want it to be? Range: " + startRange + " - " + endRange);
			if(in>=startRange&&in<=endRange)
			{
				return in;
			}
			System.out.println("Hmm... Please try that again...");
		}
	}
	public static float promptFloat(String missing, float startRange, float endRange)
	{
		System.out.println("The value \""+missing+"\" is missing from the config file. What do you want it to be? Range: " + startRange + " - " + endRange);
		while(true)
		{
			float in = CommandLineUtils.getFloatFromInput("What do you want it to be? Range: " + startRange + " - " + endRange);
			if(in>=startRange&&in<=endRange)
			{
				return in;
			}
			System.out.println("Hmm... Please try that again...");
		}
	}
	public static boolean promptBool(String missing)
	{
		System.out.println("The value \""+missing+"\" is missing from the config file. What do you want it to be?(true/false)");
		while(true)
		{
			String in = CommandLineUtils.getInput();
			if(in.equalsIgnoreCase("true")) return true;
			if(in.equalsIgnoreCase("false")) return false;
			System.out.println("Hmm... Please try that again...");
		}
	}
}