-- Name: prod.lua

inspect = require 'inspect'

function linearInterpolate(inmin, inmax, outmin, outmax, val)
  local proportion = (val - inmin) / (inmax - inmin)
  local out = proportion * (outmax - outmin) + outmin
  return out
end

dofile("unpack2.lua")
dofile("reflect.lua")
dofile("geometry.lua")
dofile("queue.lua")
dofile("widgets.lua")
dofile("slider.lua")
dofile("drawto.lua")
dofile("intersection.lua")

dofile("timeline.lua")

dofile("track.lua")
dofile("mech.lua")

function render()
  timeline[currentTimelineItem].effect.render()
end

function update()
  if g_bDemoMode == true then
    if isMp3Playing() == false then
        os.exit()
    end
  end
  
  if isTransitionDue() then
    nextScene()
  end
  
  timeline[currentTimelineItem].effect.update()
end

initTimeline()

function f12Pressed() hideEditor() end
function f11Pressed() showEditor() end
function f10Pressed() demoMode() end
function f9Pressed() testMode() end

edSetRenderMode(0)
function f8Pressed() print2(getMp3Time()) saveBuffer() end
setBufferName("times.txt")

function demoMode()
  turnOffBorders()
  fullscreenMode()
  hideEditor()
  setFloorGrid(false)
  setPickSphere(false)
  g_bDemoMode = true
  playMp3()
end

function testMode()
  turnOnBorders()
  windowedMode(50,50,800,600)
  showEditor()
  setFloorGrid(true)
  setPickSphere(true)
  g_bDemoMode = false
end

demoMode()
--testMode()
