//Namespace
this.wideload = this.wideload || {};

/**
* Main class for each part of the demo
*/

(function(){
	
	
	/**
	* Constructor
	* @param beginTime When the effect should start
	* @param prepareTime How long should the effect be allowed to stay in prepare phase (visible during previous parts end phase).
	         Value of 0 indicates immediate change. The endtime for previous part is the same as this parts prepare. First part has no prepare.
	  @param main Reference to main class
	*/
	var RenderBuffer = function(amount){
		this.maxAmount = amount;
		this.writeIndex = 0;
		this.buffer = new Array();
		this.readIndex = 0;
	}
	wideload.RenderBuffer = RenderBuffer;
	
	var p = RenderBuffer.prototype;
	
	p.isBuffered = function(){
		return this.buffer.length != 0;
	}

	p.getNext = function(i){
		if(this.buffer.length == 0){
			return;
		}
		if(this.readIndex < this.buffer.length){
			return this.buffer[this.readIndex];	
		}
		else{
			this.readIndex = 0;
			return this.buffer[this.readIndex];
		}
	}

	/**
	* Initialize the part. This is called during page load.
	*/
	p.add = function(o){
		this.buffer[this.index] = o;
		this.writeIndex++;
		if(this.writeIndex > this.maxAmount ){
			this.writeIndex = 0;
		}
	}
	
}())